/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.gui;

import NC.noChance.core.ACConfig;
import NC.noChance.core.ViolationType;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class ACMenuGUI {
    private final Plugin plugin;
    private final ACConfig config;

    public ACMenuGUI(Plugin plugin, ACConfig config) {
        this.plugin = plugin;
        this.config = config;
    }

    public void openMainMenu(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)"\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Main Menu");
        this.fillBorders(inv);
        inv.setItem(10, this.createItem(Material.FEATHER, "\u00a7c\u00a7lMovement Checks", "\u00a77Click to manage movement checks", "\u00a78\u2022 \u00a77Fly, Speed, NoClip, Jesus, Blink"));
        inv.setItem(12, this.createItem(Material.DIAMOND_PICKAXE, "\u00a7c\u00a7lBlock Interaction Checks", "\u00a77Click to manage block checks", "\u00a78\u2022 \u00a77FastBreak, FastPlace, Nuker, Scaffold"));
        inv.setItem(14, this.createItem(Material.DIAMOND_SWORD, "\u00a7c\u00a7lCombat Checks", "\u00a77Click to manage combat checks", "\u00a78\u2022 \u00a77KillAura, AutoClicker, Reach, Inventory"));
        inv.setItem(16, this.createItem(Material.GOLDEN_BOOTS, "\u00a7c\u00a7lOther Checks", "\u00a77Click to manage other checks", "\u00a78\u2022 \u00a77NoFall, Timer, Velocity, Criticals"));
        inv.setItem(28, this.createItem(Material.COMPARATOR, "\u00a7c\u00a7lThreshold Settings", "\u00a77Adjust confidence thresholds", "\u00a78\u2022 \u00a77Low, Medium, High confidence"));
        inv.setItem(30, this.createItem(Material.REDSTONE, "\u00a7c\u00a7lStatistical Settings", "\u00a77Configure statistical analysis", "\u00a78\u2022 \u00a77Deviation, Outlier forgiveness"));
        inv.setItem(32, this.createItem(Material.PLAYER_HEAD, "\u00a7c\u00a7lSkill Profiles", "\u00a77Configure skill-based detection", "\u00a78\u2022 \u00a77Low, Medium, High skill"));
        inv.setItem(34, this.createItem(Material.PAPER, "\u00a7c\u00a7lGeneral Settings", "\u00a77General configuration options", "\u00a78\u2022 \u00a77Time window, Grace period"));
        inv.setItem(49, this.createItem(Material.BARRIER, "\u00a7c\u00a7lClose Menu", "\u00a77Click to close"));
        player.openInventory(inv);
    }

    public void openMovementChecksMenu(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)"\u00a7c\u00a7lMovement Checks");
        this.fillBorders(inv);
        this.addCheckItem(inv, 10, ViolationType.FLY, Material.ELYTRA, "fly");
        this.addCheckItem(inv, 12, ViolationType.SPEED, Material.SUGAR, "speed");
        this.addCheckItem(inv, 14, ViolationType.NOCLIP, Material.BARRIER, "noclip");
        this.addCheckItem(inv, 16, ViolationType.JESUS, Material.WATER_BUCKET, "jesus");
        this.addCheckItem(inv, 28, ViolationType.BLINK, Material.ENDER_PEARL, "blink");
        inv.setItem(49, this.createItem(Material.ARROW, "\u00a7c\u00a7lBack", "\u00a77Return to main menu"));
        player.openInventory(inv);
    }

    public void openBlockChecksMenu(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)"\u00a7c\u00a7lBlock Interaction Checks");
        this.fillBorders(inv);
        this.addCheckItem(inv, 10, ViolationType.FASTBREAK, Material.DIAMOND_PICKAXE, "fastbreak");
        this.addCheckItem(inv, 12, ViolationType.FASTPLACE, Material.SCAFFOLDING, "fastplace");
        this.addCheckItem(inv, 14, ViolationType.NUKER, Material.TNT, "nuker");
        this.addCheckItem(inv, 16, ViolationType.SCAFFOLD, Material.OAK_PLANKS, "scaffold");
        inv.setItem(28, this.createItem(Material.REDSTONE_TORCH, "\u00a7e\u00a7lFastBreak Settings", "\u00a77Adjust FastBreak detection", "\u00a78\u2022 \u00a77Tolerances & bonuses", "\u00a78\u2022 \u00a77Tool-specific settings"));
        inv.setItem(49, this.createItem(Material.ARROW, "\u00a7c\u00a7lBack", "\u00a77Return to main menu"));
        player.openInventory(inv);
    }

    public void openCombatChecksMenu(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)"\u00a7c\u00a7lCombat Checks");
        this.fillBorders(inv);
        this.addCheckItem(inv, 10, ViolationType.KILLAURA, Material.DIAMOND_SWORD, "killaura");
        this.addCheckItem(inv, 12, ViolationType.AUTOCLICKER, Material.LEVER, "autoclicker");
        this.addCheckItem(inv, 14, ViolationType.REACH, Material.STICK, "reach");
        this.addCheckItem(inv, 16, ViolationType.INVENTORY, Material.CHEST, "inventory");
        inv.setItem(28, this.createItem(Material.REDSTONE_TORCH, "\u00a7e\u00a7lKillAura Settings", "\u00a77Adjust KillAura detection", "\u00a78\u2022 \u00a77CPS, Angle, Rotation limits", "\u00a78\u2022 \u00a77Trust bonuses & penalties"));
        inv.setItem(49, this.createItem(Material.ARROW, "\u00a7c\u00a7lBack", "\u00a77Return to main menu"));
        player.openInventory(inv);
    }

    public void openDamageChecksMenu(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)"\u00a7c\u00a7lOther Checks");
        this.fillBorders(inv);
        this.addCheckItem(inv, 10, ViolationType.NOFALL, Material.GOLDEN_BOOTS, "nofall");
        this.addCheckItem(inv, 12, ViolationType.TIMER, Material.CLOCK, "timer");
        this.addCheckItem(inv, 14, ViolationType.VELOCITY, Material.SLIME_BALL, "velocity");
        this.addCheckItem(inv, 16, ViolationType.CRITICALS, Material.DIAMOND_AXE, "criticals");
        this.addCheckItem(inv, 28, ViolationType.PHASE, Material.END_PORTAL_FRAME, "phase");
        this.addCheckItem(inv, 30, ViolationType.STEP, Material.STONE_STAIRS, "step");
        inv.setItem(49, this.createItem(Material.ARROW, "\u00a7c\u00a7lBack", "\u00a77Return to main menu"));
        player.openInventory(inv);
    }

    public void openCheckConfigMenu(Player player, String checkName) {
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)("\u00a7c\u00a7lConfigure \u00a7f" + checkName.toUpperCase()));
        this.fillBorders(inv);
        boolean enabled = this.config.isCheckEnabled(checkName);
        inv.setItem(10, this.createItem(enabled ? Material.LIME_DYE : Material.GRAY_DYE, enabled ? "\u00a7a\u00a7lEnabled" : "\u00a7c\u00a7lDisabled", "\u00a77Click to toggle"));
        int threshold = this.config.getViolationThreshold(checkName);
        inv.setItem(13, this.createThresholdItem(threshold));
        double severity = this.config.getSeverityMultiplier(checkName);
        inv.setItem(16, this.createSeverityItem(severity));
        inv.setItem(31, this.createItem(Material.WRITABLE_BOOK, "\u00a7c\u00a7lSave Changes", "\u00a77Click to save to config.yml"));
        inv.setItem(49, this.createItem(Material.ARROW, "\u00a7c\u00a7lBack", "\u00a77Return to checks menu"));
        player.openInventory(inv);
    }

    public void openThresholdMenu(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)"\u00a7c\u00a7lThreshold Settings");
        this.fillBorders(inv);
        double lowConf = this.config.getLowConfidenceThreshold();
        double medConf = this.config.getMediumConfidenceThreshold();
        double highConf = this.config.getHighConfidenceThreshold();
        inv.setItem(11, this.createProgressBarItem("\u00a7e\u00a7lLow Confidence", lowConf, Material.YELLOW_STAINED_GLASS_PANE, "\u00a77Current: \u00a7f" + String.format("%.0f%%", lowConf * 100.0), "", "\u00a77\u00a7lLeft Click \u00a78- \u00a77Decrease by 5%", "\u00a77\u00a7lRight Click \u00a78- \u00a77Increase by 5%"));
        inv.setItem(13, this.createProgressBarItem("\u00a76\u00a7lMedium Confidence", medConf, Material.ORANGE_STAINED_GLASS_PANE, "\u00a77Current: \u00a7f" + String.format("%.0f%%", medConf * 100.0), "", "\u00a77\u00a7lLeft Click \u00a78- \u00a77Decrease by 5%", "\u00a77\u00a7lRight Click \u00a78- \u00a77Increase by 5%"));
        inv.setItem(15, this.createProgressBarItem("\u00a7c\u00a7lHigh Confidence", highConf, Material.RED_STAINED_GLASS_PANE, "\u00a77Current: \u00a7f" + String.format("%.0f%%", highConf * 100.0), "", "\u00a77\u00a7lLeft Click \u00a78- \u00a77Decrease by 5%", "\u00a77\u00a7lRight Click \u00a78- \u00a77Increase by 5%"));
        inv.setItem(31, this.createItem(Material.WRITABLE_BOOK, "\u00a7c\u00a7lSave Changes", "\u00a77Click to save to config.yml"));
        inv.setItem(49, this.createItem(Material.ARROW, "\u00a7c\u00a7lBack", "\u00a77Return to main menu"));
        player.openInventory(inv);
    }

    public void openStatisticalMenu(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)"\u00a7c\u00a7lStatistical Settings");
        this.fillBorders(inv);
        double stdDev = this.config.getStandardDeviationMultiplier();
        int outlier = this.config.getOutlierForgiveness();
        inv.setItem(12, this.createProgressBarItem("\u00a7b\u00a7lStd Dev Multiplier", stdDev / 5.0, Material.CYAN_STAINED_GLASS_PANE, "\u00a77Current: \u00a7f" + String.format("%.1f", stdDev), "", "\u00a77\u00a7lLeft Click \u00a78- \u00a77Decrease by 0.5", "\u00a77\u00a7lRight Click \u00a78- \u00a77Increase by 0.5"));
        inv.setItem(14, this.createProgressBarItem("\u00a7d\u00a7lOutlier Forgiveness", (double)outlier / 10.0, Material.MAGENTA_STAINED_GLASS_PANE, "\u00a77Current: \u00a7f" + outlier, "", "\u00a77\u00a7lLeft Click \u00a78- \u00a77Decrease by 1", "\u00a77\u00a7lRight Click \u00a78- \u00a77Increase by 1"));
        inv.setItem(31, this.createItem(Material.WRITABLE_BOOK, "\u00a7c\u00a7lSave Changes", "\u00a77Click to save to config.yml"));
        inv.setItem(49, this.createItem(Material.ARROW, "\u00a7c\u00a7lBack", "\u00a77Return to main menu"));
        player.openInventory(inv);
    }

    private void addCheckItem(Inventory inv, int slot, ViolationType type, Material material, String checkName) {
        boolean enabled = this.config.isCheckEnabled(checkName);
        int threshold = this.config.getViolationThreshold(checkName);
        double severity = this.config.getSeverityMultiplier(checkName);
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName((enabled ? "\u00a7a" : "\u00a7c") + "\u00a7l" + type.name());
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add("\u00a78\u00a7m                              ");
        lore.add("\u00a77Status: " + (enabled ? "\u00a7aEnabled" : "\u00a7cDisabled"));
        lore.add("\u00a77Threshold: \u00a7f" + threshold);
        lore.add("\u00a77Severity: \u00a7f" + String.format("%.1fx", severity));
        lore.add("\u00a77Complexity: \u00a7f" + type.getComplexity() + "/5");
        lore.add("\u00a78\u00a7m                              ");
        lore.add("\u00a7e\u00a7lClick to configure");
        meta.setLore(lore);
        item.setItemMeta(meta);
        inv.setItem(slot, item);
    }

    private ItemStack createThresholdItem(int threshold) {
        double percentage = Math.min(1.0, (double)threshold / 20.0);
        return this.createProgressBarItem("\u00a7c\u00a7lViolation Threshold", percentage, Material.RED_STAINED_GLASS_PANE, "\u00a77Current: \u00a7f" + threshold, "", "\u00a77\u00a7lLeft Click \u00a78- \u00a77Decrease by 1", "\u00a77\u00a7lRight Click \u00a78- \u00a77Increase by 1");
    }

    private ItemStack createSeverityItem(double severity) {
        double percentage = Math.min(1.0, severity / 3.0);
        return this.createProgressBarItem("\u00a76\u00a7lSeverity Multiplier", percentage, Material.ORANGE_STAINED_GLASS_PANE, "\u00a77Current: \u00a7f" + String.format("%.1fx", severity), "", "\u00a77\u00a7lLeft Click \u00a78- \u00a77Decrease by 0.1x", "\u00a77\u00a7lRight Click \u00a78- \u00a77Increase by 0.1x");
    }

    private ItemStack createProgressBarItem(String name, double percentage, Material material, String ... extraLore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add("\u00a78\u00a7m                              ");
        lore.add(this.createProgressBar(percentage));
        lore.add("\u00a77Percentage: \u00a7f" + String.format("%.0f%%", percentage * 100.0));
        for (String line : extraLore) {
            lore.add(line);
        }
        lore.add("\u00a78\u00a7m                              ");
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private String createProgressBar(double percentage) {
        int filled = (int)(percentage * 20.0);
        StringBuilder bar = new StringBuilder("\u00a77[");
        for (int i = 0; i < 20; ++i) {
            if (i < filled) {
                bar.append("\u00a7a\u2588");
                continue;
            }
            bar.append("\u00a78\u2588");
        }
        bar.append("\u00a77]");
        return bar.toString();
    }

    private ItemStack createItem(Material material, String name, String ... lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        ArrayList<String> loreList = new ArrayList<String>();
        loreList.add("\u00a78\u00a7m                              ");
        for (String line : lore) {
            loreList.add(line);
        }
        loreList.add("\u00a78\u00a7m                              ");
        meta.setLore(loreList);
        item.setItemMeta(meta);
        return item;
    }

    private void fillBorders(Inventory inv) {
        int i;
        ItemStack border = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta borderMeta = border.getItemMeta();
        borderMeta.setDisplayName("\u00a78");
        border.setItemMeta(borderMeta);
        for (i = 0; i < 9; ++i) {
            if (inv.getItem(i) != null) continue;
            inv.setItem(i, border);
        }
        for (i = 45; i < 54; ++i) {
            if (inv.getItem(i) != null) continue;
            inv.setItem(i, border);
        }
        for (i = 9; i < 45; i += 9) {
            if (inv.getItem(i) == null) {
                inv.setItem(i, border);
            }
            if (inv.getItem(i + 8) != null) continue;
            inv.setItem(i + 8, border);
        }
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public ACConfig getConfig() {
        return this.config;
    }

    public void openSkillProfilesMenu(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)"\u00a7c\u00a7lSkill Profiles");
        this.fillBorders(inv);
        inv.setItem(11, this.createItem(Material.WOODEN_SWORD, "\u00a7e\u00a7lLow Skill Profile", "\u00a77Min CPS: \u00a7f" + this.config.getLowSkillMinCPS(), "\u00a77Max CPS: \u00a7f" + this.config.getLowSkillMaxCPS(), "\u00a77Min Rotation: \u00a7f" + String.format("%.0f\u00b0/s", this.config.getLowSkillMinRotation()), "\u00a77Max Rotation: \u00a7f" + String.format("%.0f\u00b0/s", this.config.getLowSkillMaxRotation()), "\u00a77Min Accuracy: \u00a7f" + String.format("%.0f%%", this.config.getLowSkillMinAccuracy() * 100.0), "\u00a77Max Accuracy: \u00a7f" + String.format("%.0f%%", this.config.getLowSkillMaxAccuracy() * 100.0), "", "\u00a7e\u00a7lClick to configure"));
        inv.setItem(13, this.createItem(Material.IRON_SWORD, "\u00a76\u00a7lMedium Skill Profile", "\u00a77Min CPS: \u00a7f" + this.config.getMediumSkillMinCPS(), "\u00a77Max CPS: \u00a7f" + this.config.getMediumSkillMaxCPS(), "\u00a77Min Rotation: \u00a7f" + String.format("%.0f\u00b0/s", this.config.getMediumSkillMinRotation()), "\u00a77Max Rotation: \u00a7f" + String.format("%.0f\u00b0/s", this.config.getMediumSkillMaxRotation()), "\u00a77Min Accuracy: \u00a7f" + String.format("%.0f%%", this.config.getMediumSkillMinAccuracy() * 100.0), "\u00a77Max Accuracy: \u00a7f" + String.format("%.0f%%", this.config.getMediumSkillMaxAccuracy() * 100.0), "", "\u00a7e\u00a7lClick to configure"));
        inv.setItem(15, this.createItem(Material.DIAMOND_SWORD, "\u00a7c\u00a7lHigh Skill Profile", "\u00a77Min CPS: \u00a7f" + this.config.getHighSkillMinCPS(), "\u00a77Max CPS: \u00a7f" + this.config.getHighSkillMaxCPS(), "\u00a77Min Rotation: \u00a7f" + String.format("%.0f\u00b0/s", this.config.getHighSkillMinRotation()), "\u00a77Max Rotation: \u00a7f" + String.format("%.0f\u00b0/s", this.config.getHighSkillMaxRotation()), "\u00a77Min Accuracy: \u00a7f" + String.format("%.0f%%", this.config.getHighSkillMinAccuracy() * 100.0), "\u00a77Max Accuracy: \u00a7f" + String.format("%.0f%%", this.config.getHighSkillMaxAccuracy() * 100.0), "", "\u00a7e\u00a7lClick to configure"));
        inv.setItem(31, this.createItem(Material.BOOK, "\u00a7b\u00a7lInfo", "\u00a77Skill profiles are auto-calibrated", "\u00a77per player based on their stats.", "", "\u00a77These ranges determine what is", "\u00a77considered normal for each skill level."));
        inv.setItem(49, this.createItem(Material.ARROW, "\u00a7c\u00a7lBack", "\u00a77Return to main menu"));
        player.openInventory(inv);
    }

    public void openSkillConfigMenu(Player player, String skillLevel) {
        double maxAccuracy;
        double minAccuracy;
        double maxRotation;
        double minRotation;
        int maxCPS;
        int minCPS;
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)("\u00a7c\u00a7lConfigure \u00a7f" + skillLevel.toUpperCase() + " Skill"));
        this.fillBorders(inv);
        if (skillLevel.equals("low")) {
            minCPS = this.config.getLowSkillMinCPS();
            maxCPS = this.config.getLowSkillMaxCPS();
            minRotation = this.config.getLowSkillMinRotation();
            maxRotation = this.config.getLowSkillMaxRotation();
            minAccuracy = this.config.getLowSkillMinAccuracy();
            maxAccuracy = this.config.getLowSkillMaxAccuracy();
        } else if (skillLevel.equals("medium")) {
            minCPS = this.config.getMediumSkillMinCPS();
            maxCPS = this.config.getMediumSkillMaxCPS();
            minRotation = this.config.getMediumSkillMinRotation();
            maxRotation = this.config.getMediumSkillMaxRotation();
            minAccuracy = this.config.getMediumSkillMinAccuracy();
            maxAccuracy = this.config.getMediumSkillMaxAccuracy();
        } else {
            minCPS = this.config.getHighSkillMinCPS();
            maxCPS = this.config.getHighSkillMaxCPS();
            minRotation = this.config.getHighSkillMinRotation();
            maxRotation = this.config.getHighSkillMaxRotation();
            minAccuracy = this.config.getHighSkillMinAccuracy();
            maxAccuracy = this.config.getHighSkillMaxAccuracy();
        }
        inv.setItem(10, this.createItem(Material.CLOCK, "\u00a7a\u00a7lMin CPS", "\u00a77Current: \u00a7f" + minCPS, "", "\u00a77\u00a7lLeft Click \u00a78- \u00a77Decrease by 1", "\u00a77\u00a7lRight Click \u00a78- \u00a77Increase by 1"));
        inv.setItem(11, this.createItem(Material.CLOCK, "\u00a7c\u00a7lMax CPS", "\u00a77Current: \u00a7f" + maxCPS, "", "\u00a77\u00a7lLeft Click \u00a78- \u00a77Decrease by 1", "\u00a77\u00a7lRight Click \u00a78- \u00a77Increase by 1"));
        inv.setItem(13, this.createItem(Material.COMPASS, "\u00a7a\u00a7lMin Rotation Speed", "\u00a77Current: \u00a7f" + String.format("%.0f\u00b0/s", minRotation), "", "\u00a77\u00a7lLeft Click \u00a78- \u00a77Decrease by 10", "\u00a77\u00a7lRight Click \u00a78- \u00a77Increase by 10"));
        inv.setItem(14, this.createItem(Material.COMPASS, "\u00a7c\u00a7lMax Rotation Speed", "\u00a77Current: \u00a7f" + String.format("%.0f\u00b0/s", maxRotation), "", "\u00a77\u00a7lLeft Click \u00a78- \u00a77Decrease by 10", "\u00a77\u00a7lRight Click \u00a78- \u00a77Increase by 10"));
        inv.setItem(16, this.createItem(Material.BOW, "\u00a7a\u00a7lMin Accuracy", "\u00a77Current: \u00a7f" + String.format("%.0f%%", minAccuracy * 100.0), "", "\u00a77\u00a7lLeft Click \u00a78- \u00a77Decrease by 5%", "\u00a77\u00a7lRight Click \u00a78- \u00a77Increase by 5%"));
        inv.setItem(17, this.createItem(Material.BOW, "\u00a7c\u00a7lMax Accuracy", "\u00a77Current: \u00a7f" + String.format("%.0f%%", maxAccuracy * 100.0), "", "\u00a77\u00a7lLeft Click \u00a78- \u00a77Decrease by 5%", "\u00a77\u00a7lRight Click \u00a78- \u00a77Increase by 5%"));
        inv.setItem(31, this.createItem(Material.WRITABLE_BOOK, "\u00a7c\u00a7lSave Changes", "\u00a77Click to save to config.yml"));
        inv.setItem(49, this.createItem(Material.ARROW, "\u00a7c\u00a7lBack", "\u00a77Return to skill profiles"));
        player.openInventory(inv);
    }

    public void openGeneralSettingsMenu(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)"\u00a7c\u00a7lGeneral Settings");
        this.fillBorders(inv);
        int timeWindow = this.config.getTimeWindow();
        int gracePeriod = this.config.getGracePeriod();
        int minSamples = this.config.getMinSamples();
        inv.setItem(11, this.createItem(Material.CLOCK, "\u00a7e\u00a7lTime Window", "\u00a77Current: \u00a7f" + timeWindow + " seconds", "", "\u00a77Duration for tracking violations", "\u00a77and calculating scores.", "", "\u00a77\u00a7lLeft Click \u00a78- \u00a77Decrease by 5s", "\u00a77\u00a7lRight Click \u00a78- \u00a77Increase by 5s"));
        inv.setItem(13, this.createItem(Material.FEATHER, "\u00a7b\u00a7lGrace Period", "\u00a77Current: \u00a7f" + gracePeriod + " seconds", "", "\u00a77Time after join before checks", "\u00a77start monitoring the player.", "", "\u00a77\u00a7lLeft Click \u00a78- \u00a77Decrease by 1s", "\u00a77\u00a7lRight Click \u00a78- \u00a77Increase by 1s"));
        inv.setItem(15, this.createItem(Material.REDSTONE, "\u00a7d\u00a7lMin Samples", "\u00a77Current: \u00a7f" + minSamples, "", "\u00a77Minimum data points required", "\u00a77before flagging violations.", "", "\u00a77\u00a7lLeft Click \u00a78- \u00a77Decrease by 1", "\u00a77\u00a7lRight Click \u00a78- \u00a77Increase by 1"));
        inv.setItem(31, this.createItem(Material.WRITABLE_BOOK, "\u00a7c\u00a7lSave Changes", "\u00a77Click to save to config.yml"));
        inv.setItem(49, this.createItem(Material.ARROW, "\u00a7c\u00a7lBack", "\u00a77Return to main menu"));
        player.openInventory(inv);
    }

    public void openKillAuraSettingsMenu(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)"\u00a7e\u00a7lKillAura Settings");
        this.fillBorders(inv);
        double maxCPS = this.config.getKillAuraMaxCPS();
        inv.setItem(10, this.createItem(Material.REDSTONE, "\u00a7c\u00a7lMax CPS", "\u00a77Current: \u00a7f" + maxCPS, "", "\u00a77Maximum clicks per second", "\u00a77before triggering detection.", "", "\u00a77\u00a7lLeft Click \u00a78- \u00a77Decrease by 1", "\u00a77\u00a7lRight Click \u00a78- \u00a77Increase by 1"));
        double cpsTrustBonus = this.config.getKillAuraCPSTrustedBonus();
        inv.setItem(11, this.createItem(Material.LIME_DYE, "\u00a7a\u00a7lCPS Trust Bonus", "\u00a77Current: \u00a7f+" + cpsTrustBonus, "", "\u00a77Extra CPS for trusted players", "", "\u00a77\u00a7lLeft Click \u00a78- \u00a77Decrease by 0.5", "\u00a77\u00a7lRight Click \u00a78- \u00a77Increase by 0.5"));
        double maxAngle = this.config.getKillAuraMaxAngle();
        inv.setItem(13, this.createItem(Material.COMPASS, "\u00a7c\u00a7lMax Angle", "\u00a77Current: \u00a7f" + maxAngle + "\u00b0", "", "\u00a77Maximum hit angle before flag", "", "\u00a77\u00a7lLeft Click \u00a78- \u00a77Decrease by 2\u00b0", "\u00a77\u00a7lRight Click \u00a78- \u00a77Increase by 2\u00b0"));
        double angleTrustBonus = this.config.getKillAuraAngleTrustedBonus();
        inv.setItem(14, this.createItem(Material.LIME_DYE, "\u00a7a\u00a7lAngle Trust Bonus", "\u00a77Current: \u00a7f+" + angleTrustBonus + "\u00b0", "", "\u00a77Extra angle for trusted players", "", "\u00a77\u00a7lLeft Click \u00a78- \u00a77Decrease by 2\u00b0", "\u00a77\u00a7lRight Click \u00a78- \u00a77Increase by 2\u00b0"));
        double maxRotation = this.config.getKillAuraMaxRotationSpeed();
        inv.setItem(16, this.createItem(Material.ENDER_EYE, "\u00a7c\u00a7lMax Rotation", "\u00a77Current: \u00a7f" + maxRotation + "\u00b0/s", "", "\u00a77Max rotation speed before flag", "", "\u00a77\u00a7lLeft Click \u00a78- \u00a77Decrease by 20", "\u00a77\u00a7lRight Click \u00a78- \u00a77Increase by 20"));
        int requiredViolations = this.config.getKillAuraRequiredViolations();
        inv.setItem(28, this.createItem(Material.PAPER, "\u00a7e\u00a7lRequired Violations", "\u00a77Current: \u00a7f" + requiredViolations, "", "\u00a77Violations needed before flag", "", "\u00a77\u00a7lLeft Click \u00a78- \u00a77Decrease by 1", "\u00a77\u00a7lRight Click \u00a78- \u00a77Increase by 1"));
        double packetVariance = this.config.getKillAuraPacketVarianceThreshold();
        inv.setItem(30, this.createItem(Material.HOPPER, "\u00a7d\u00a7lPacket Variance", "\u00a77Current: \u00a7f" + packetVariance, "", "\u00a77Packet timing consistency limit", "", "\u00a77\u00a7lLeft Click \u00a78- \u00a77Decrease by 5", "\u00a77\u00a7lRight Click \u00a78- \u00a77Increase by 5"));
        int packetRate = this.config.getKillAuraPacketAttackRateLimit();
        inv.setItem(32, this.createItem(Material.CLOCK, "\u00a7d\u00a7lPacket Rate Limit", "\u00a77Current: \u00a7f" + packetRate + "/s", "", "\u00a77Max packet attacks per second", "", "\u00a77\u00a7lLeft Click \u00a78- \u00a77Decrease by 2", "\u00a77\u00a7lRight Click \u00a78- \u00a77Increase by 2"));
        inv.setItem(49, this.createItem(Material.ARROW, "\u00a7c\u00a7lBack", "\u00a77Return to combat checks"));
        player.openInventory(inv);
    }

    public void openFastBreakSettingsMenu(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)"\u00a7e\u00a7lFastBreak Settings");
        this.fillBorders(inv);
        int baseTolerance = this.config.getFastBreakBaseToleranceMs();
        inv.setItem(10, this.createItem(Material.CLOCK, "\u00a7c\u00a7lBase Tolerance", "\u00a77Current: \u00a7f" + baseTolerance + "ms", "", "\u00a77Base time tolerance in ms", "", "\u00a77\u00a7lLeft Click \u00a78- \u00a77Decrease by 5ms", "\u00a77\u00a7lRight Click \u00a78- \u00a77Increase by 5ms"));
        double percentTolerance = this.config.getFastBreakPercentageTolerance() * 100.0;
        inv.setItem(12, this.createItem(Material.REDSTONE, "\u00a7c\u00a7lPercentage Tolerance", "\u00a77Current: \u00a7f" + percentTolerance + "%", "", "\u00a77Percentage of expected time", "", "\u00a77\u00a7lLeft Click \u00a78- \u00a77Decrease by 2%", "\u00a77\u00a7lRight Click \u00a78- \u00a77Increase by 2%"));
        int shovelTolerance = this.config.getFastBreakShovelInstantToleranceMs();
        inv.setItem(14, this.createItem(Material.IRON_SHOVEL, "\u00a7e\u00a7lShovel Tolerance", "\u00a77Current: \u00a7f" + shovelTolerance + "ms", "", "\u00a77Instant-mine shovel tolerance", "", "\u00a77\u00a7lLeft Click \u00a78- \u00a77Decrease by 5ms", "\u00a77\u00a7lRight Click \u00a78- \u00a77Increase by 5ms"));
        double shovelPercent = this.config.getFastBreakShovelInstantPercentage() * 100.0;
        inv.setItem(15, this.createItem(Material.DIAMOND_SHOVEL, "\u00a7e\u00a7lShovel Percent", "\u00a77Current: \u00a7f" + shovelPercent + "%", "", "\u00a77Shovel percentage tolerance", "", "\u00a77\u00a7lLeft Click \u00a78- \u00a77Decrease by 3%", "\u00a77\u00a7lRight Click \u00a78- \u00a77Increase by 3%"));
        int handTolerance = this.config.getFastBreakHandInstantToleranceMs();
        inv.setItem(28, this.createItem(Material.PAPER, "\u00a7b\u00a7lHand Tolerance", "\u00a77Current: \u00a7f" + handTolerance + "ms", "", "\u00a77Hand-breaking tolerance", "", "\u00a77\u00a7lLeft Click \u00a78- \u00a77Decrease by 3ms", "\u00a77\u00a7lRight Click \u00a78- \u00a77Increase by 3ms"));
        int trustBonusInstant = this.config.getFastBreakTrustBonusInstantMs();
        inv.setItem(30, this.createItem(Material.LIME_DYE, "\u00a7a\u00a7lTrust Bonus (Instant)", "\u00a77Current: \u00a7f+" + trustBonusInstant + "ms", "", "\u00a77Trust bonus for instant-mine", "", "\u00a77\u00a7lLeft Click \u00a78- \u00a77Decrease by 3ms", "\u00a77\u00a7lRight Click \u00a78- \u00a77Increase by 3ms"));
        int trustBonusNormal = this.config.getFastBreakTrustBonusNormalMs();
        inv.setItem(32, this.createItem(Material.LIME_DYE, "\u00a7a\u00a7lTrust Bonus (Normal)", "\u00a77Current: \u00a7f+" + trustBonusNormal + "ms", "", "\u00a77Trust bonus for normal breaks", "", "\u00a77\u00a7lLeft Click \u00a78- \u00a77Decrease by 5ms", "\u00a77\u00a7lRight Click \u00a78- \u00a77Increase by 5ms"));
        inv.setItem(49, this.createItem(Material.ARROW, "\u00a7c\u00a7lBack", "\u00a77Return to block checks"));
        player.openInventory(inv);
    }
}

