/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.gui;

import NC.noChance.core.ACConfig;
import NC.noChance.gui.ACMenuGUI;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class GUIListener
implements Listener {
    private final ACMenuGUI menuGUI;
    private final Plugin plugin;
    private final ACConfig config;

    public GUIListener(ACMenuGUI menuGUI, Plugin plugin, ACConfig config) {
        this.menuGUI = menuGUI;
        this.plugin = plugin;
        this.config = config;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=false)
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        String title = event.getView().getTitle();
        if (!this.isNoChanceGUI(title)) {
            return;
        }
        event.setCancelled(true);
        event.setResult(Event.Result.DENY);
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        if (!clicked.getItemMeta().hasDisplayName()) {
            return;
        }
        String itemName = clicked.getItemMeta().getDisplayName();
        if (itemName.equals("\u00a78") || itemName.trim().isEmpty()) {
            return;
        }
        if (title.equals("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Main Menu")) {
            this.handleMainMenu(player, itemName);
        } else if (title.equals("\u00a7c\u00a7lMovement Checks")) {
            this.handleMovementMenu(player, itemName);
        } else if (title.equals("\u00a7c\u00a7lBlock Interaction Checks")) {
            this.handleBlockMenu(player, itemName);
        } else if (title.equals("\u00a7c\u00a7lCombat Checks")) {
            this.handleCombatMenu(player, itemName);
        } else if (title.equals("\u00a7c\u00a7lOther Checks")) {
            this.handleDamageMenu(player, itemName);
        } else if (title.startsWith("\u00a7c\u00a7lConfigure \u00a7f") && title.contains("Skill")) {
            this.handleSkillConfigMenu(player, title, itemName, event);
        } else if (title.startsWith("\u00a7c\u00a7lConfigure \u00a7f")) {
            this.handleCheckConfig(player, title, itemName, event);
        } else if (title.equals("\u00a7c\u00a7lThreshold Settings")) {
            this.handleThresholdMenu(player, itemName, event);
        } else if (title.equals("\u00a7c\u00a7lStatistical Settings")) {
            this.handleStatisticalMenu(player, itemName, event);
        } else if (title.equals("\u00a7c\u00a7lSkill Profiles")) {
            this.handleSkillProfilesMenu(player, itemName);
        } else if (title.equals("\u00a7c\u00a7lGeneral Settings")) {
            this.handleGeneralSettingsMenu(player, itemName, event);
        } else if (title.equals("\u00a7e\u00a7lKillAura Settings")) {
            this.handleKillAuraSettingsMenu(player, itemName, event);
        } else if (title.equals("\u00a7e\u00a7lFastBreak Settings")) {
            this.handleFastBreakSettingsMenu(player, itemName, event);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=false)
    public void onInventoryDrag(InventoryDragEvent event) {
        if (this.isNoChanceGUI(event.getView().getTitle())) {
            event.setCancelled(true);
            event.setResult(Event.Result.DENY);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=false)
    public void onInventoryInteract(InventoryInteractEvent event) {
        if (this.isNoChanceGUI(event.getView().getTitle())) {
            event.setCancelled(true);
            event.setResult(Event.Result.DENY);
        }
    }

    private boolean isNoChanceGUI(String title) {
        return title.contains("\u00a7c\u00a7lNoChance") || title.equals("\u00a7c\u00a7lMovement Checks") || title.equals("\u00a7c\u00a7lBlock Interaction Checks") || title.equals("\u00a7c\u00a7lCombat Checks") || title.equals("\u00a7c\u00a7lOther Checks") || title.startsWith("\u00a7c\u00a7lConfigure \u00a7f") || title.equals("\u00a7c\u00a7lThreshold Settings") || title.equals("\u00a7c\u00a7lStatistical Settings") || title.equals("\u00a7c\u00a7lSkill Profiles") || title.equals("\u00a7c\u00a7lGeneral Settings") || title.equals("\u00a7e\u00a7lKillAura Settings") || title.equals("\u00a7e\u00a7lFastBreak Settings");
    }

    private void handleMainMenu(Player player, String itemName) {
        if (itemName.equals("\u00a7c\u00a7lMovement Checks")) {
            this.menuGUI.openMovementChecksMenu(player);
        } else if (itemName.equals("\u00a7c\u00a7lBlock Interaction Checks")) {
            this.menuGUI.openBlockChecksMenu(player);
        } else if (itemName.equals("\u00a7c\u00a7lCombat Checks")) {
            this.menuGUI.openCombatChecksMenu(player);
        } else if (itemName.equals("\u00a7c\u00a7lOther Checks")) {
            this.menuGUI.openDamageChecksMenu(player);
        } else if (itemName.equals("\u00a7c\u00a7lThreshold Settings")) {
            this.menuGUI.openThresholdMenu(player);
        } else if (itemName.equals("\u00a7c\u00a7lStatistical Settings")) {
            this.menuGUI.openStatisticalMenu(player);
        } else if (itemName.equals("\u00a7c\u00a7lSkill Profiles")) {
            this.menuGUI.openSkillProfilesMenu(player);
        } else if (itemName.equals("\u00a7c\u00a7lGeneral Settings")) {
            this.menuGUI.openGeneralSettingsMenu(player);
        } else if (itemName.equals("\u00a7c\u00a7lClose Menu")) {
            player.closeInventory();
        }
    }

    private void handleMovementMenu(Player player, String itemName) {
        if (itemName.equals("\u00a7c\u00a7lBack")) {
            this.menuGUI.openMainMenu(player);
        } else if (itemName.contains("FLY")) {
            this.menuGUI.openCheckConfigMenu(player, "fly");
        } else if (itemName.contains("SPEED")) {
            this.menuGUI.openCheckConfigMenu(player, "speed");
        } else if (itemName.contains("NOCLIP")) {
            this.menuGUI.openCheckConfigMenu(player, "noclip");
        } else if (itemName.contains("JESUS")) {
            this.menuGUI.openCheckConfigMenu(player, "jesus");
        } else if (itemName.contains("BLINK")) {
            this.menuGUI.openCheckConfigMenu(player, "blink");
        }
    }

    private void handleBlockMenu(Player player, String itemName) {
        if (itemName.equals("\u00a7c\u00a7lBack")) {
            this.menuGUI.openMainMenu(player);
        } else if (itemName.equals("\u00a7e\u00a7lFastBreak Settings")) {
            this.menuGUI.openFastBreakSettingsMenu(player);
        } else if (itemName.contains("FASTBREAK")) {
            this.menuGUI.openCheckConfigMenu(player, "fastbreak");
        } else if (itemName.contains("FASTPLACE")) {
            this.menuGUI.openCheckConfigMenu(player, "fastplace");
        } else if (itemName.contains("NUKER")) {
            this.menuGUI.openCheckConfigMenu(player, "nuker");
        } else if (itemName.contains("SCAFFOLD")) {
            this.menuGUI.openCheckConfigMenu(player, "scaffold");
        }
    }

    private void handleCombatMenu(Player player, String itemName) {
        if (itemName.equals("\u00a7c\u00a7lBack")) {
            this.menuGUI.openMainMenu(player);
        } else if (itemName.equals("\u00a7e\u00a7lKillAura Settings")) {
            this.menuGUI.openKillAuraSettingsMenu(player);
        } else if (itemName.contains("KILLAURA")) {
            this.menuGUI.openCheckConfigMenu(player, "killaura");
        } else if (itemName.contains("AUTOCLICKER")) {
            this.menuGUI.openCheckConfigMenu(player, "autoclicker");
        } else if (itemName.contains("REACH")) {
            this.menuGUI.openCheckConfigMenu(player, "reach");
        } else if (itemName.contains("INVENTORY")) {
            this.menuGUI.openCheckConfigMenu(player, "inventory");
        }
    }

    private void handleDamageMenu(Player player, String itemName) {
        if (itemName.equals("\u00a7c\u00a7lBack")) {
            this.menuGUI.openMainMenu(player);
        } else if (itemName.contains("NOFALL")) {
            this.menuGUI.openCheckConfigMenu(player, "nofall");
        } else if (itemName.contains("TIMER")) {
            this.menuGUI.openCheckConfigMenu(player, "timer");
        } else if (itemName.contains("VELOCITY")) {
            this.menuGUI.openCheckConfigMenu(player, "velocity");
        } else if (itemName.contains("CRITICALS")) {
            this.menuGUI.openCheckConfigMenu(player, "criticals");
        } else if (itemName.contains("PHASE")) {
            this.menuGUI.openCheckConfigMenu(player, "phase");
        } else if (itemName.contains("STEP")) {
            this.menuGUI.openCheckConfigMenu(player, "step");
        }
    }

    private void handleCheckConfig(Player player, String title, String itemName, InventoryClickEvent event) {
        String checkName = title.replace("\u00a7c\u00a7lConfigure \u00a7f", "").toLowerCase();
        if (itemName.equals("\u00a7c\u00a7lBack")) {
            if (checkName.equals("fly") || checkName.equals("speed") || checkName.equals("noclip") || checkName.equals("jesus") || checkName.equals("blink")) {
                this.menuGUI.openMovementChecksMenu(player);
            } else if (checkName.equals("fastbreak") || checkName.equals("fastplace") || checkName.equals("nuker") || checkName.equals("scaffold")) {
                this.menuGUI.openBlockChecksMenu(player);
            } else if (checkName.equals("killaura") || checkName.equals("autoclicker") || checkName.equals("reach") || checkName.equals("inventory")) {
                this.menuGUI.openCombatChecksMenu(player);
            } else if (checkName.equals("nofall") || checkName.equals("timer") || checkName.equals("velocity") || checkName.equals("criticals") || checkName.equals("phase") || checkName.equals("step")) {
                this.menuGUI.openDamageChecksMenu(player);
            }
        } else if (itemName.contains("Enabled") || itemName.contains("Disabled")) {
            boolean currentValue = this.config.isCheckEnabled(checkName);
            this.plugin.getConfig().set("checks." + checkName + ".enabled", (Object)(!currentValue ? 1 : 0));
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Toggled " + checkName + " to " + (!currentValue ? "\u00a7aenabled" : "\u00a7cdisabled"));
            this.menuGUI.openCheckConfigMenu(player, checkName);
        } else if (itemName.contains("Violation Threshold")) {
            int current = this.config.getViolationThreshold(checkName);
            int newValue = event.isLeftClick() ? Math.max(1, current - 1) : current + 1;
            this.plugin.getConfig().set("checks." + checkName + ".threshold", (Object)newValue);
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Set threshold to \u00a7f" + newValue);
            this.menuGUI.openCheckConfigMenu(player, checkName);
        } else if (itemName.contains("Severity Multiplier")) {
            double current = this.config.getSeverityMultiplier(checkName);
            double newValue = event.isLeftClick() ? Math.max(0.1, current - 0.1) : Math.min(5.0, current + 0.1);
            this.plugin.getConfig().set("checks." + checkName + ".severity_multiplier", (Object)((double)Math.round(newValue * 10.0) / 10.0));
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Set severity to \u00a7f" + String.format("%.1fx", newValue));
            this.menuGUI.openCheckConfigMenu(player, checkName);
        } else if (itemName.contains("Save Changes")) {
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a7a\u00a7lSaved \u00a77all changes to config.yml");
            player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
        }
    }

    private void handleThresholdMenu(Player player, String itemName, InventoryClickEvent event) {
        if (itemName.equals("\u00a7c\u00a7lBack")) {
            this.menuGUI.openMainMenu(player);
        } else if (itemName.contains("Low Confidence")) {
            double current = this.config.getLowConfidenceThreshold();
            double medium = this.config.getMediumConfidenceThreshold();
            double change = event.isLeftClick() ? -0.05 : 0.05;
            double newValue = Math.max(0.0, Math.min(1.0, current + change));
            if (newValue >= medium) {
                player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a7cLow threshold must be less than medium!");
                return;
            }
            this.plugin.getConfig().set("thresholds.low_confidence", (Object)((double)Math.round(newValue * 100.0) / 100.0));
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Low threshold: \u00a7f" + String.format("%.0f%%", newValue * 100.0));
            this.menuGUI.openThresholdMenu(player);
        } else if (itemName.contains("Medium Confidence")) {
            double change;
            double low = this.config.getLowConfidenceThreshold();
            double high = this.config.getHighConfidenceThreshold();
            double current = this.config.getMediumConfidenceThreshold();
            double newValue = Math.max(0.0, Math.min(1.0, current + (change = event.isLeftClick() ? -0.05 : 0.05)));
            if (newValue <= low || newValue >= high) {
                player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a7cMedium must be between low and high!");
                return;
            }
            this.plugin.getConfig().set("thresholds.medium_confidence", (Object)((double)Math.round(newValue * 100.0) / 100.0));
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Medium threshold: \u00a7f" + String.format("%.0f%%", newValue * 100.0));
            this.menuGUI.openThresholdMenu(player);
        } else if (itemName.contains("High Confidence")) {
            double change;
            double medium = this.config.getMediumConfidenceThreshold();
            double current = this.config.getHighConfidenceThreshold();
            double newValue = Math.max(0.0, Math.min(1.0, current + (change = event.isLeftClick() ? -0.05 : 0.05)));
            if (newValue <= medium) {
                player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a7cHigh threshold must be greater than medium!");
                return;
            }
            this.plugin.getConfig().set("thresholds.high_confidence", (Object)((double)Math.round(newValue * 100.0) / 100.0));
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77High threshold: \u00a7f" + String.format("%.0f%%", newValue * 100.0));
            this.menuGUI.openThresholdMenu(player);
        } else if (itemName.contains("Save Changes")) {
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a7a\u00a7lSaved \u00a77all changes to config.yml");
            player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
        }
    }

    private void handleStatisticalMenu(Player player, String itemName, InventoryClickEvent event) {
        if (itemName.equals("\u00a7c\u00a7lBack")) {
            this.menuGUI.openMainMenu(player);
        } else if (itemName.contains("Std Dev Multiplier")) {
            double current = this.config.getStandardDeviationMultiplier();
            double change = event.isLeftClick() ? -0.5 : 0.5;
            double newValue = Math.max(1.0, Math.min(5.0, current + change));
            this.plugin.getConfig().set("statistical.std_dev_multiplier", (Object)((double)Math.round(newValue * 10.0) / 10.0));
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Std Dev: \u00a7f" + String.format("%.1f", newValue));
            this.menuGUI.openStatisticalMenu(player);
        } else if (itemName.contains("Outlier Forgiveness")) {
            int current = this.config.getOutlierForgiveness();
            int change = event.isLeftClick() ? -1 : 1;
            int newValue = Math.max(0, Math.min(10, current + change));
            this.plugin.getConfig().set("statistical.outlier_forgiveness", (Object)newValue);
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Outlier forgiveness: \u00a7f" + newValue);
            this.menuGUI.openStatisticalMenu(player);
        } else if (itemName.contains("Save Changes")) {
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a7a\u00a7lSaved \u00a77all changes to config.yml");
            player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
        }
    }

    private void handleSkillProfilesMenu(Player player, String itemName) {
        if (itemName.equals("\u00a7c\u00a7lBack")) {
            this.menuGUI.openMainMenu(player);
        } else if (itemName.contains("Low Skill Profile")) {
            this.menuGUI.openSkillConfigMenu(player, "low");
        } else if (itemName.contains("Medium Skill Profile")) {
            this.menuGUI.openSkillConfigMenu(player, "medium");
        } else if (itemName.contains("High Skill Profile")) {
            this.menuGUI.openSkillConfigMenu(player, "high");
        }
    }

    private void handleSkillConfigMenu(Player player, String title, String itemName, InventoryClickEvent event) {
        String skillLevel = title.replace("\u00a7c\u00a7lConfigure \u00a7f", "").replace(" SKILL", "").toLowerCase();
        if (itemName.equals("\u00a7c\u00a7lBack")) {
            this.menuGUI.openSkillProfilesMenu(player);
        } else if (itemName.contains("Min CPS")) {
            int current = skillLevel.equals("low") ? this.config.getLowSkillMinCPS() : (skillLevel.equals("medium") ? this.config.getMediumSkillMinCPS() : this.config.getHighSkillMinCPS());
            int change = event.isLeftClick() ? -1 : 1;
            int newValue = Math.max(1, Math.min(30, current + change));
            this.plugin.getConfig().set("skill_profiles." + skillLevel + ".min_cps", (Object)newValue);
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Min CPS: \u00a7f" + newValue);
            this.menuGUI.openSkillConfigMenu(player, skillLevel);
        } else if (itemName.contains("Max CPS")) {
            int current = skillLevel.equals("low") ? this.config.getLowSkillMaxCPS() : (skillLevel.equals("medium") ? this.config.getMediumSkillMaxCPS() : this.config.getHighSkillMaxCPS());
            int change = event.isLeftClick() ? -1 : 1;
            int newValue = Math.max(1, Math.min(30, current + change));
            this.plugin.getConfig().set("skill_profiles." + skillLevel + ".max_cps", (Object)newValue);
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Max CPS: \u00a7f" + newValue);
            this.menuGUI.openSkillConfigMenu(player, skillLevel);
        } else if (itemName.contains("Min Rotation Speed")) {
            double current = skillLevel.equals("low") ? this.config.getLowSkillMinRotation() : (skillLevel.equals("medium") ? this.config.getMediumSkillMinRotation() : this.config.getHighSkillMinRotation());
            double change = event.isLeftClick() ? -10.0 : 10.0;
            double newValue = Math.max(0.0, Math.min(1000.0, current + change));
            this.plugin.getConfig().set("skill_profiles." + skillLevel + ".min_rotation_speed", (Object)newValue);
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Min Rotation: \u00a7f" + String.format("%.0f\u00b0/s", newValue));
            this.menuGUI.openSkillConfigMenu(player, skillLevel);
        } else if (itemName.contains("Max Rotation Speed")) {
            double current = skillLevel.equals("low") ? this.config.getLowSkillMaxRotation() : (skillLevel.equals("medium") ? this.config.getMediumSkillMaxRotation() : this.config.getHighSkillMaxRotation());
            double change = event.isLeftClick() ? -10.0 : 10.0;
            double newValue = Math.max(0.0, Math.min(1000.0, current + change));
            this.plugin.getConfig().set("skill_profiles." + skillLevel + ".max_rotation_speed", (Object)newValue);
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Max Rotation: \u00a7f" + String.format("%.0f\u00b0/s", newValue));
            this.menuGUI.openSkillConfigMenu(player, skillLevel);
        } else if (itemName.contains("Min Accuracy")) {
            double current = skillLevel.equals("low") ? this.config.getLowSkillMinAccuracy() : (skillLevel.equals("medium") ? this.config.getMediumSkillMinAccuracy() : this.config.getHighSkillMinAccuracy());
            double change = event.isLeftClick() ? -0.05 : 0.05;
            double newValue = Math.max(0.0, Math.min(1.0, current + change));
            this.plugin.getConfig().set("skill_profiles." + skillLevel + ".min_accuracy", (Object)((double)Math.round(newValue * 100.0) / 100.0));
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Min Accuracy: \u00a7f" + String.format("%.0f%%", newValue * 100.0));
            this.menuGUI.openSkillConfigMenu(player, skillLevel);
        } else if (itemName.contains("Max Accuracy")) {
            double current = skillLevel.equals("low") ? this.config.getLowSkillMaxAccuracy() : (skillLevel.equals("medium") ? this.config.getMediumSkillMaxAccuracy() : this.config.getHighSkillMaxAccuracy());
            double change = event.isLeftClick() ? -0.05 : 0.05;
            double newValue = Math.max(0.0, Math.min(1.0, current + change));
            this.plugin.getConfig().set("skill_profiles." + skillLevel + ".max_accuracy", (Object)((double)Math.round(newValue * 100.0) / 100.0));
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Max Accuracy: \u00a7f" + String.format("%.0f%%", newValue * 100.0));
            this.menuGUI.openSkillConfigMenu(player, skillLevel);
        } else if (itemName.contains("Save Changes")) {
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a7a\u00a7lSaved \u00a77all changes to config.yml");
            player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
        }
    }

    private void handleGeneralSettingsMenu(Player player, String itemName, InventoryClickEvent event) {
        if (itemName.equals("\u00a7c\u00a7lBack")) {
            this.menuGUI.openMainMenu(player);
        } else if (itemName.contains("Time Window")) {
            int current = this.config.getTimeWindow();
            int change = event.isLeftClick() ? -5 : 5;
            int newValue = Math.max(10, Math.min(300, current + change));
            this.plugin.getConfig().set("general.time_window_seconds", (Object)newValue);
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Time Window: \u00a7f" + newValue + "s");
            this.menuGUI.openGeneralSettingsMenu(player);
        } else if (itemName.contains("Grace Period")) {
            int current = this.config.getGracePeriod();
            int change = event.isLeftClick() ? -1 : 1;
            int newValue = Math.max(0, Math.min(60, current + change));
            this.plugin.getConfig().set("general.grace_period_seconds", (Object)newValue);
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Grace Period: \u00a7f" + newValue + "s");
            this.menuGUI.openGeneralSettingsMenu(player);
        } else if (itemName.contains("Min Samples")) {
            int current = this.config.getMinSamples();
            int change = event.isLeftClick() ? -1 : 1;
            int newValue = Math.max(1, Math.min(50, current + change));
            this.plugin.getConfig().set("general.min_samples", (Object)newValue);
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Min Samples: \u00a7f" + newValue);
            this.menuGUI.openGeneralSettingsMenu(player);
        } else if (itemName.contains("Save Changes")) {
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a7a\u00a7lSaved \u00a77all changes to config.yml");
            player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
        }
    }

    private void handleKillAuraSettingsMenu(Player player, String itemName, InventoryClickEvent event) {
        if (itemName.equals("\u00a7c\u00a7lBack")) {
            this.menuGUI.openCombatChecksMenu(player);
        } else if (itemName.contains("Max CPS")) {
            double current = this.config.getKillAuraMaxCPS();
            double change = event.isLeftClick() ? -1.0 : 1.0;
            double newValue = Math.max(10.0, Math.min(30.0, current + change));
            this.plugin.getConfig().set("checks.killaura.max_cps", (Object)newValue);
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Max CPS: \u00a7f" + newValue);
            this.menuGUI.openKillAuraSettingsMenu(player);
        } else if (itemName.contains("CPS Trust Bonus")) {
            double current = this.config.getKillAuraCPSTrustedBonus();
            double change = event.isLeftClick() ? -0.5 : 0.5;
            double newValue = Math.max(0.0, Math.min(10.0, current + change));
            this.plugin.getConfig().set("checks.killaura.cps_trusted_bonus", (Object)((double)Math.round(newValue * 10.0) / 10.0));
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77CPS Trust Bonus: \u00a7f+" + newValue);
            this.menuGUI.openKillAuraSettingsMenu(player);
        } else if (itemName.contains("Max Angle")) {
            double current = this.config.getKillAuraMaxAngle();
            double change = event.isLeftClick() ? -2.0 : 2.0;
            double newValue = Math.max(20.0, Math.min(90.0, current + change));
            this.plugin.getConfig().set("checks.killaura.max_angle", (Object)newValue);
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Max Angle: \u00a7f" + newValue + "\u00b0");
            this.menuGUI.openKillAuraSettingsMenu(player);
        } else if (itemName.contains("Angle Trust Bonus")) {
            double current = this.config.getKillAuraAngleTrustedBonus();
            double change = event.isLeftClick() ? -2.0 : 2.0;
            double newValue = Math.max(0.0, Math.min(30.0, current + change));
            this.plugin.getConfig().set("checks.killaura.angle_trusted_bonus", (Object)newValue);
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Angle Trust Bonus: \u00a7f+" + newValue + "\u00b0");
            this.menuGUI.openKillAuraSettingsMenu(player);
        } else if (itemName.contains("Max Rotation")) {
            double current = this.config.getKillAuraMaxRotationSpeed();
            double change = event.isLeftClick() ? -20.0 : 20.0;
            double newValue = Math.max(300.0, Math.min(1200.0, current + change));
            this.plugin.getConfig().set("checks.killaura.max_rotation_speed", (Object)newValue);
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Max Rotation: \u00a7f" + newValue + "\u00b0/s");
            this.menuGUI.openKillAuraSettingsMenu(player);
        } else if (itemName.contains("Required Violations")) {
            int current = this.config.getKillAuraRequiredViolations();
            int change = event.isLeftClick() ? -1 : 1;
            int newValue = Math.max(1, Math.min(5, current + change));
            this.plugin.getConfig().set("checks.killaura.required_violations", (Object)newValue);
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Required Violations: \u00a7f" + newValue);
            this.menuGUI.openKillAuraSettingsMenu(player);
        } else if (itemName.contains("Packet Variance")) {
            double current = this.config.getKillAuraPacketVarianceThreshold();
            double change = event.isLeftClick() ? -5.0 : 5.0;
            double newValue = Math.max(10.0, Math.min(100.0, current + change));
            this.plugin.getConfig().set("checks.killaura.packet_variance_threshold", (Object)newValue);
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Packet Variance: \u00a7f" + newValue);
            this.menuGUI.openKillAuraSettingsMenu(player);
        } else if (itemName.contains("Packet Rate Limit")) {
            int current = this.config.getKillAuraPacketAttackRateLimit();
            int change = event.isLeftClick() ? -2 : 2;
            int newValue = Math.max(15, Math.min(40, current + change));
            this.plugin.getConfig().set("checks.killaura.packet_attack_rate_limit", (Object)newValue);
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Packet Rate Limit: \u00a7f" + newValue + "/s");
            this.menuGUI.openKillAuraSettingsMenu(player);
        }
    }

    private void handleFastBreakSettingsMenu(Player player, String itemName, InventoryClickEvent event) {
        if (itemName.equals("\u00a7c\u00a7lBack")) {
            this.menuGUI.openBlockChecksMenu(player);
        } else if (itemName.contains("Base Tolerance")) {
            int current = this.config.getFastBreakBaseToleranceMs();
            int change = event.isLeftClick() ? -5 : 5;
            int newValue = Math.max(20, Math.min(150, current + change));
            this.plugin.getConfig().set("checks.fastbreak.base_tolerance_ms", (Object)newValue);
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Base Tolerance: \u00a7f" + newValue + "ms");
            this.menuGUI.openFastBreakSettingsMenu(player);
        } else if (itemName.contains("Percentage Tolerance")) {
            double current = this.config.getFastBreakPercentageTolerance();
            double change = event.isLeftClick() ? -0.02 : 0.02;
            double newValue = Math.max(0.05, Math.min(0.5, current + change));
            this.plugin.getConfig().set("checks.fastbreak.percentage_tolerance", (Object)((double)Math.round(newValue * 100.0) / 100.0));
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Percentage Tolerance: \u00a7f" + String.format("%.0f%%", newValue * 100.0));
            this.menuGUI.openFastBreakSettingsMenu(player);
        } else if (itemName.contains("Shovel Tolerance")) {
            int current = this.config.getFastBreakShovelInstantToleranceMs();
            int change = event.isLeftClick() ? -5 : 5;
            int newValue = Math.max(20, Math.min(80, current + change));
            this.plugin.getConfig().set("checks.fastbreak.shovel_instant_tolerance_ms", (Object)newValue);
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Shovel Tolerance: \u00a7f" + newValue + "ms");
            this.menuGUI.openFastBreakSettingsMenu(player);
        } else if (itemName.contains("Shovel Percent")) {
            double current = this.config.getFastBreakShovelInstantPercentage();
            double change = event.isLeftClick() ? -0.03 : 0.03;
            double newValue = Math.max(0.1, Math.min(0.5, current + change));
            this.plugin.getConfig().set("checks.fastbreak.shovel_instant_percentage", (Object)((double)Math.round(newValue * 100.0) / 100.0));
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Shovel Percent: \u00a7f" + String.format("%.0f%%", newValue * 100.0));
            this.menuGUI.openFastBreakSettingsMenu(player);
        } else if (itemName.contains("Hand Tolerance")) {
            int current = this.config.getFastBreakHandInstantToleranceMs();
            int change = event.isLeftClick() ? -3 : 3;
            int newValue = Math.max(15, Math.min(60, current + change));
            this.plugin.getConfig().set("checks.fastbreak.hand_instant_tolerance_ms", (Object)newValue);
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Hand Tolerance: \u00a7f" + newValue + "ms");
            this.menuGUI.openFastBreakSettingsMenu(player);
        } else if (itemName.contains("Trust Bonus (Instant)")) {
            int current = this.config.getFastBreakTrustBonusInstantMs();
            int change = event.isLeftClick() ? -3 : 3;
            int newValue = Math.max(0, Math.min(50, current + change));
            this.plugin.getConfig().set("checks.fastbreak.trust_bonus_instant_ms", (Object)newValue);
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Trust Bonus (Instant): \u00a7f+" + newValue + "ms");
            this.menuGUI.openFastBreakSettingsMenu(player);
        } else if (itemName.contains("Trust Bonus (Normal)")) {
            int current = this.config.getFastBreakTrustBonusNormalMs();
            int change = event.isLeftClick() ? -5 : 5;
            int newValue = Math.max(0, Math.min(100, current + change));
            this.plugin.getConfig().set("checks.fastbreak.trust_bonus_normal_ms", (Object)newValue);
            this.plugin.saveConfig();
            this.config.reload();
            player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Trust Bonus (Normal): \u00a7f+" + newValue + "ms");
            this.menuGUI.openFastBreakSettingsMenu(player);
        }
    }
}

