/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.listeners;

import NC.noChance.NoChance;
import NC.noChance.alerts.StaffAlertManager;
import NC.noChance.core.ACConfig;
import NC.noChance.core.CheckRegistry;
import NC.noChance.core.CheckResult;
import NC.noChance.core.MultiLayerValidator;
import NC.noChance.core.PlayerData;
import NC.noChance.core.ViolationScoring;
import NC.noChance.core.ViolationType;
import NC.noChance.core.WaterHelper;
import NC.noChance.replay.ReplayMgr;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class PlayerListener
implements Listener {
    private final NoChance plugin;
    private final Map<UUID, PlayerData> playerDataMap;
    private final ViolationScoring violationScoring;
    private final MultiLayerValidator multiLayerValidator;
    private final StaffAlertManager alertManager;
    private final ACConfig config;
    private final CheckRegistry checks;

    public PlayerListener(NoChance plugin, Map<UUID, PlayerData> playerDataMap, ViolationScoring violationScoring, MultiLayerValidator multiLayerValidator, StaffAlertManager alertManager, ACConfig config, CheckRegistry checkRegistry) {
        this.plugin = plugin;
        this.playerDataMap = playerDataMap;
        this.violationScoring = violationScoring;
        this.multiLayerValidator = multiLayerValidator;
        this.alertManager = alertManager;
        this.config = config;
        this.checks = checkRegistry;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerJoin(PlayerJoinEvent event) {
        ReplayMgr replay;
        Player player = event.getPlayer();
        PlayerData data = new PlayerData(player.getUniqueId());
        this.playerDataMap.put(player.getUniqueId(), data);
        long timeWindow = (long)this.config.getTimeWindow() * 1000L;
        this.plugin.getDatabase().getPlayerHistory(player.getUniqueId(), timeWindow).thenAccept(history -> {
            if (history != null) {
                data.setHistoricalData(history.violationCount, history.lastKickTime);
                if (history.wasRecentlyKicked(300000L)) {
                    Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                        for (Player staff : Bukkit.getOnlinePlayers()) {
                            if (!staff.hasPermission("nochance.alerts")) continue;
                            staff.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Strict detection enabled for \u00a7e" + player.getName() + " \u00a77- recent kick detected");
                        }
                    }, 20L);
                }
            }
        });
        if (player.hasPermission("nochance.alerts")) {
            this.alertManager.enableAlerts(player.getUniqueId());
        }
        if (player.hasPermission("nochance.admin") || player.isOp()) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (this.plugin.getUpdateChecker() != null && this.plugin.getUpdateChecker().isCheckComplete() && this.plugin.getUpdateChecker().isUpdateAvailable()) {
                    player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Update available!");
                    player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Current: \u00a7f" + this.plugin.getUpdateChecker().getCurrentVersion() + " \u00a78| \u00a77Latest: \u00a7f" + this.plugin.getUpdateChecker().getLatestVersion());
                    player.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Download: \u00a7fhttps://www.spigotmc.org/resources/129357/");
                }
            }, 60L);
        }
        if ((replay = this.plugin.getReplayMgr()) != null) {
            replay.onPlayerJoin(player);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        ReplayMgr replay = this.plugin.getReplayMgr();
        if (replay != null) {
            replay.onPlayerQuit(event.getPlayer());
        }
        this.cleanupPlayer(event.getPlayer().getUniqueId());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerKick(PlayerKickEvent event) {
        ReplayMgr replay = this.plugin.getReplayMgr();
        if (replay != null) {
            replay.onPlayerQuit(event.getPlayer());
        }
        this.cleanupPlayer(event.getPlayer().getUniqueId());
    }

    private void cleanupPlayer(UUID playerId) {
        this.multiLayerValidator.cleanupPlayer(playerId);
        this.checks.cleanupPlayer(playerId);
        this.alertManager.cleanup(playerId);
        this.playerDataMap.remove(playerId);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (player.hasPermission("nochance.bypass")) {
            return;
        }
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data == null) {
            return;
        }
        if (event.getFrom().getX() == event.getTo().getX() && event.getFrom().getY() == event.getTo().getY() && event.getFrom().getZ() == event.getTo().getZ()) {
            return;
        }
        data.updateLocationHistory(event.getTo());
        data.updateRotationHistory(event.getTo().getYaw(), event.getTo().getPitch());
        CheckResult flyResult = this.checks.getFlyCheck().check(player, event.getFrom(), event.getTo());
        this.handleMultiLayerValidation(player, flyResult, ViolationType.FLY);
        CheckResult speedResult = this.checks.getSpeedCheck().check(player, event.getFrom(), event.getTo());
        this.handleMultiLayerValidation(player, speedResult, ViolationType.SPEED);
        CheckResult noClipResult = this.checks.getNoClipCheck().check(player, event.getFrom(), event.getTo());
        this.handleMultiLayerValidation(player, noClipResult, ViolationType.NOCLIP);
        CheckResult jesusResult = this.checks.getJesusCheck().check(player, event.getFrom(), event.getTo());
        this.handleMultiLayerValidation(player, jesusResult, ViolationType.JESUS);
        CheckResult timerResult = this.checks.getTimerCheck().check(player);
        this.handleMultiLayerValidation(player, timerResult, ViolationType.TIMER);
        CheckResult phaseResult = this.checks.getPhaseCheck().check(player, event.getFrom(), event.getTo());
        this.handleMultiLayerValidation(player, phaseResult, ViolationType.PHASE);
        CheckResult stepResult = this.checks.getStepCheck().check(player, event.getFrom(), event.getTo());
        this.handleMultiLayerValidation(player, stepResult, ViolationType.STEP);
        CheckResult blinkResult = this.checks.getBlinkCheck().checkForBlink(player);
        this.handleMultiLayerValidation(player, blinkResult, ViolationType.BLINK);
        CheckResult noSlowResult = this.checks.getNoSlowCheck().check(player, event.getFrom(), event.getTo());
        this.handleMultiLayerValidation(player, noSlowResult, ViolationType.NOSLOW);
        CheckResult groundSpoofResult = this.checks.getGroundSpoofCheck().check(player, event.getFrom(), event.getTo(), player.isOnGround());
        this.handleMultiLayerValidation(player, groundSpoofResult, ViolationType.GROUNDSPOOF);
        CheckResult elytraResult = this.checks.getElytraFlyCheck().check(player, event.getFrom(), event.getTo());
        this.handleMultiLayerValidation(player, elytraResult, ViolationType.ELYTRAFLY);
        CheckResult striderResult = this.checks.getStriderCheck().check(player, event.getFrom(), event.getTo());
        this.handleMultiLayerValidation(player, striderResult, ViolationType.STRIDER);
        CheckResult boatResult = this.checks.getBoatFlyCheck().check(player);
        this.handleMultiLayerValidation(player, boatResult, ViolationType.BOATFLY);
        this.checks.getNoFallCheck().updateFallDistance(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockDamage(BlockDamageEvent event) {
        Player player = event.getPlayer();
        this.checks.getFastBreakCheck().onStartDigging(player, event.getBlock());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (player.hasPermission("nochance.bypass")) {
            return;
        }
        CheckResult fastBreakResult = this.checks.getFastBreakCheck().check(player, event.getBlock());
        this.handleMultiLayerValidation(player, fastBreakResult, ViolationType.FASTBREAK);
        CheckResult nukerResult = this.checks.getNukerCheck().check(player, event.getBlock().getLocation());
        this.handleMultiLayerValidation(player, nukerResult, ViolationType.NUKER);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        if (player.hasPermission("nochance.bypass")) {
            return;
        }
        CheckResult fastPlaceResult = this.checks.getFastPlaceCheck().check(player, event.getBlock().getLocation());
        this.handleMultiLayerValidation(player, fastPlaceResult, ViolationType.FASTPLACE);
        CheckResult reachResult = this.checks.getReachCheck().checkBlockReach(player, event.getBlock());
        this.handleMultiLayerValidation(player, reachResult, ViolationType.REACH);
        CheckResult scaffoldResult = this.checks.getScaffoldCheck().check(player, event.getBlock());
        this.handleMultiLayerValidation(player, scaffoldResult, ViolationType.SCAFFOLD);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getDamager();
        if (player.hasPermission("nochance.bypass")) {
            return;
        }
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data == null) {
            return;
        }
        data.updateClickHistory();
        data.updateRotationHistory(player.getLocation().getYaw(), player.getLocation().getPitch());
        CheckResult killAuraResult = this.checks.getKillAuraCheck().check(player, event.getEntity());
        ViolationType type = killAuraResult.getViolationType();
        if (type == null) {
            type = ViolationType.KILLAURA;
        }
        this.handleMultiLayerValidation(player, killAuraResult, type);
        CheckResult reachResult = this.checks.getReachCheck().checkEntityReach(player, event.getEntity());
        this.handleMultiLayerValidation(player, reachResult, ViolationType.REACH);
        CheckResult autoClickerResult = this.checks.getAutoClickerCheck().check(player);
        this.handleMultiLayerValidation(player, autoClickerResult, ViolationType.AUTOCLICKER);
        boolean isCritical = !player.isOnGround() && player.getFallDistance() > 0.0f && !player.isSprinting() && !WaterHelper.isInWater(player) && !player.isClimbing();
        CheckResult criticalsResult = this.checks.getCriticalsCheck().check(player, event.getEntity(), isCritical);
        this.handleMultiLayerValidation(player, criticalsResult, ViolationType.CRITICALS);
        data.updateAccuracy(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDamage(EntityDamageEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (player.hasPermission("nochance.bypass")) {
            return;
        }
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data != null && (event.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK || event.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION || event.getCause() == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION)) {
            data.setLastVelocityTime(System.currentTimeMillis());
            data.setLastKnockbackVelocity(0.4);
            Vector expectedVelocity = new Vector(0.0, 0.4, 0.0);
            this.checks.getVelocityCheck().recordVelocity(player, expectedVelocity);
        }
        if (event.getCause() == EntityDamageEvent.DamageCause.FALL) {
            CheckResult noFallResult = this.checks.getNoFallCheck().checkOnLanding(player, event);
            this.handleMultiLayerValidation(player, noFallResult, ViolationType.NOFALL);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerAnimation(PlayerAnimationEvent event) {
        Player player = event.getPlayer();
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data == null) {
            return;
        }
        data.updateClickHistory();
        data.updateAccuracy(false);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (player.hasPermission("nochance.bypass")) {
            return;
        }
        CheckResult inventoryResult = this.checks.getInventoryCheck().check(player, event);
        this.handleMultiLayerValidation(player, inventoryResult, ViolationType.INVENTORY);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerVelocity(PlayerVelocityEvent event) {
        Player player = event.getPlayer();
        PlayerData data = this.playerDataMap.get(player.getUniqueId());
        if (data != null && !event.isCancelled()) {
            Vector velocity = event.getVelocity();
            double magnitude = Math.sqrt(velocity.getX() * velocity.getX() + velocity.getY() * velocity.getY() + velocity.getZ() * velocity.getZ());
            data.setLastVelocityTime(System.currentTimeMillis());
            data.setLastKnockbackVelocity(magnitude);
            this.checks.getVelocityCheck().recordVelocity(player, velocity);
            Vector actualVelocity = player.getVelocity();
            CheckResult velocityResult = this.checks.getVelocityCheck().check(player, actualVelocity);
            this.handleMultiLayerValidation(player, velocityResult, ViolationType.VELOCITY);
        }
    }

    private void handleMultiLayerValidation(Player player, CheckResult checkResult, ViolationType type) {
        MultiLayerValidator.ValidationResult validationResult;
        if (!checkResult.isFailed()) {
            return;
        }
        if (type == null) {
            type = checkResult.getViolationType();
        }
        if ((validationResult = this.multiLayerValidator.validate(player, checkResult, type)).shouldFlag()) {
            this.violationScoring.handleViolationWithAdvancedMetrics(player, validationResult.getOriginalResult(), validationResult.getScore(), validationResult.getDetectionMethod());
        }
    }
}

