/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.packetevents.api.event;

import NC.noChance.packetevents.api.event.PacketListenerCommon;
import NC.noChance.packetevents.api.event.ProtocolPacketEvent;
import NC.noChance.packetevents.api.exception.PacketProcessException;
import NC.noChance.packetevents.api.manager.server.ServerVersion;
import NC.noChance.packetevents.api.netty.buffer.ByteBufHelper;
import NC.noChance.packetevents.api.protocol.PacketSide;
import NC.noChance.packetevents.api.protocol.packettype.PacketTypeCommon;
import NC.noChance.packetevents.api.protocol.player.User;
import java.util.ArrayList;
import java.util.List;

public class PacketSendEvent
extends ProtocolPacketEvent {
    private List<Runnable> tasksAfterSend = null;

    protected PacketSendEvent(Object channel, User user, Object player, Object rawByteBuf, boolean autoProtocolTranslation) throws PacketProcessException {
        super(PacketSide.SERVER, channel, user, player, rawByteBuf, autoProtocolTranslation);
    }

    protected PacketSendEvent(int packetID, PacketTypeCommon packetType, ServerVersion serverVersion, Object channel, User user, Object player, Object byteBuf) throws PacketProcessException {
        super(packetID, packetType, serverVersion, channel, user, player, byteBuf);
    }

    @Override
    public void call(PacketListenerCommon listener) {
        listener.onPacketSend(this);
    }

    public List<Runnable> getTasksAfterSend() {
        if (this.tasksAfterSend == null) {
            this.tasksAfterSend = new ArrayList<Runnable>();
        }
        return this.tasksAfterSend;
    }

    public boolean hasTasksAfterSend() {
        return this.tasksAfterSend != null && !this.tasksAfterSend.isEmpty();
    }

    @Override
    public PacketSendEvent clone() {
        try {
            Object clonedBuffer = ByteBufHelper.retainedDuplicate(this.getByteBuf());
            return new PacketSendEvent(this.getPacketId(), this.getPacketType(), this.getServerVersion(), this.getChannel(), this.getUser(), this.getPlayer(), clonedBuffer);
        }
        catch (PacketProcessException e) {
            e.printStackTrace();
            return null;
        }
    }
}

