/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.packetevents.api.protocol.attribute;

import NC.noChance.packetevents.api.PacketEvents;
import NC.noChance.packetevents.api.protocol.mapper.MappedEntity;
import NC.noChance.packetevents.api.protocol.player.ClientVersion;
import NC.noChance.packetevents.api.resources.ResourceLocation;
import NC.noChance.packetevents.api.util.MathUtil;

public interface Attribute
extends MappedEntity {
    @Override
    default public ResourceLocation getName() {
        return this.getName(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion());
    }

    public ResourceLocation getName(ClientVersion var1);

    default public double sanitizeValue(double value) {
        return this.sanitizeValue(value, PacketEvents.getAPI().getServerManager().getVersion().toClientVersion());
    }

    default public double sanitizeValue(double value, ClientVersion version) {
        if (!Double.isNaN(value)) {
            return MathUtil.clamp(value, this.getMinValue(), this.getMaxValue());
        }
        return this.getMinValue();
    }

    public double getDefaultValue();

    public double getMinValue();

    public double getMaxValue();
}

