/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.packetevents.api.protocol.chat.clickevent;

import NC.noChance.packetevents.api.protocol.chat.clickevent.ClickEvent;
import NC.noChance.packetevents.api.protocol.chat.clickevent.ClickEventAction;
import NC.noChance.packetevents.api.protocol.chat.clickevent.ClickEventActions;
import NC.noChance.packetevents.api.protocol.nbt.NBT;
import NC.noChance.packetevents.api.protocol.nbt.NBTCompound;
import NC.noChance.packetevents.api.protocol.nbt.NBTEnd;
import NC.noChance.packetevents.api.resources.ResourceLocation;
import NC.noChance.packetevents.api.util.adventure.NbtTagHolder;
import NC.noChance.packetevents.api.wrapper.PacketWrapper;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class CustomClickEvent
implements ClickEvent {
    private final ResourceLocation id;
    private final @Nullable NBT payload;

    public CustomClickEvent(ResourceLocation id, @Nullable NBT payload) {
        this.id = id;
        this.payload = payload;
    }

    public static CustomClickEvent decode(NBTCompound compound, PacketWrapper<?> wrapper) {
        ResourceLocation id = compound.getOrThrow("id", ResourceLocation::decode, wrapper);
        NBT payload = compound.getTagOrNull("payload");
        return new CustomClickEvent(id, payload);
    }

    public static void encode(NBTCompound compound, PacketWrapper<?> wrapper, CustomClickEvent clickEvent) {
        compound.set("id", clickEvent.id, ResourceLocation::encode, wrapper);
        if (clickEvent.payload != null) {
            compound.setTag("payload", clickEvent.payload);
        }
    }

    @Override
    public ClickEventAction<?> getAction() {
        return ClickEventActions.CUSTOM;
    }

    @Override
    public net.kyori.adventure.text.event.ClickEvent asAdventure() {
        return net.kyori.adventure.text.event.ClickEvent.custom(this.id.key(), new NbtTagHolder(this.payload != null ? this.payload : NBTEnd.INSTANCE));
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public @Nullable NBT getPayload() {
        return this.payload;
    }
}

