/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.packetevents.api.protocol.color;

import NC.noChance.packetevents.api.protocol.color.Color;
import NC.noChance.packetevents.api.protocol.nbt.NBT;
import NC.noChance.packetevents.api.protocol.nbt.NBTFloat;
import NC.noChance.packetevents.api.protocol.nbt.NBTInt;
import NC.noChance.packetevents.api.protocol.nbt.NBTList;
import NC.noChance.packetevents.api.protocol.nbt.NBTNumber;
import NC.noChance.packetevents.api.protocol.nbt.NBTType;
import NC.noChance.packetevents.api.protocol.player.ClientVersion;
import NC.noChance.packetevents.api.util.MathUtil;
import org.jetbrains.annotations.Range;

public final class AlphaColor
extends Color {
    public static final AlphaColor WHITE = new AlphaColor(-1);
    private final int alpha;

    public AlphaColor(@Range(from=0L, to=255L) int red, @Range(from=0L, to=255L) int green, @Range(from=0L, to=255L) int blue) {
        this(255, red, green, blue);
    }

    public AlphaColor(@Range(from=0L, to=255L) int alpha, @Range(from=0L, to=255L) int red, @Range(from=0L, to=255L) int green, @Range(from=0L, to=255L) int blue) {
        super(red, green, blue);
        this.alpha = alpha;
    }

    public AlphaColor(@Range(from=0L, to=1L) float red, @Range(from=0L, to=1L) float green, @Range(from=0L, to=1L) float blue) {
        this(1.0f, red, green, blue);
    }

    public AlphaColor(@Range(from=0L, to=1L) float alpha, @Range(from=0L, to=1L) float red, @Range(from=0L, to=1L) float green, @Range(from=0L, to=1L) float blue) {
        super(red, green, blue);
        this.alpha = MathUtil.floor(alpha * 255.0f);
    }

    public AlphaColor(int rgb) {
        this(rgb >> 24 & 0xFF, rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
    }

    public static AlphaColor decode(NBT nbt, ClientVersion version) {
        if (nbt instanceof NBTNumber) {
            return new AlphaColor(((NBTNumber)nbt).getAsInt());
        }
        NBTList list = (NBTList)nbt;
        float red = ((NBTNumber)list.getTag(0)).getAsFloat();
        float green = ((NBTNumber)list.getTag(1)).getAsFloat();
        float blue = ((NBTNumber)list.getTag(2)).getAsFloat();
        float alpha = ((NBTNumber)list.getTag(3)).getAsFloat();
        return new AlphaColor(alpha, red, green, blue);
    }

    public static NBT encode(AlphaColor color, ClientVersion version) {
        if (version.isNewerThanOrEquals(ClientVersion.V_1_21_2)) {
            return new NBTInt(color.asRGB());
        }
        NBTList<NBTFloat> list = new NBTList<NBTFloat>(NBTType.FLOAT, 4);
        list.addTag(new NBTFloat(color.red));
        list.addTag(new NBTFloat(color.green));
        list.addTag(new NBTFloat(color.blue));
        list.addTag(new NBTFloat(color.alpha));
        return list;
    }

    public AlphaColor withAlpha(@Range(from=0L, to=255L) int alpha) {
        return new AlphaColor(alpha, this.red, this.green, this.blue);
    }

    @Override
    public AlphaColor withRed(@Range(from=0L, to=255L) int red) {
        return new AlphaColor(this.alpha, red, this.green, this.blue);
    }

    @Override
    public AlphaColor withGreen(@Range(from=0L, to=255L) int green) {
        return new AlphaColor(this.alpha, this.red, green, this.blue);
    }

    @Override
    public AlphaColor withBlue(@Range(from=0L, to=255L) int blue) {
        return new AlphaColor(this.alpha, this.red, this.green, blue);
    }

    @Override
    public int asRGB() {
        return this.alpha << 24 | this.red << 16 | this.green << 8 | this.blue;
    }

    public @Range(from=0L, to=255L) int alpha() {
        return this.alpha;
    }

    @Override
    public @Range(from=0L, to=255L) int red() {
        return this.red;
    }

    @Override
    public @Range(from=0L, to=255L) int green() {
        return this.green;
    }

    @Override
    public @Range(from=0L, to=255L) int blue() {
        return this.blue;
    }
}

