/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.packetevents.api.protocol.component.builtin.item;

import NC.noChance.packetevents.api.protocol.world.states.type.StateValue;
import NC.noChance.packetevents.api.wrapper.PacketWrapper;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class ItemBlockStateProperties {
    private Map<String, String> properties;

    public ItemBlockStateProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public static ItemBlockStateProperties read(PacketWrapper<?> wrapper) {
        Map<String, String> properties = wrapper.readMap(PacketWrapper::readString, PacketWrapper::readString);
        return new ItemBlockStateProperties(properties);
    }

    public static void write(PacketWrapper<?> wrapper, ItemBlockStateProperties props) {
        wrapper.writeMap(props.properties, PacketWrapper::writeString, PacketWrapper::writeString);
    }

    @Nullable
    public Object getProperty(StateValue stateValue) {
        String value = this.getProperty(stateValue.getName());
        if (value != null) {
            return stateValue.getParser().apply(value);
        }
        return null;
    }

    @Nullable
    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(StateValue stateValue, @Nullable Object value) {
        this.setProperty(stateValue.getName(), value == null ? null : value.toString());
    }

    public void setProperty(String key, @Nullable String value) {
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.put(key, value);
        }
    }

    public void unsetProperty(StateValue stateValue) {
        this.unsetProperty(stateValue.getName());
    }

    public void unsetProperty(String key) {
        this.setProperty(key, null);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ItemBlockStateProperties)) {
            return false;
        }
        ItemBlockStateProperties that = (ItemBlockStateProperties)obj;
        return this.properties.equals(that.properties);
    }

    public int hashCode() {
        return Objects.hashCode(this.properties);
    }
}

