/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.packetevents.api.protocol.component.predicates;

import NC.noChance.packetevents.api.protocol.component.predicates.IComponentPredicate;
import NC.noChance.packetevents.api.protocol.nbt.NBT;
import NC.noChance.packetevents.api.wrapper.PacketWrapper;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class NbtComponentPredicate
implements IComponentPredicate {
    private final NBT tag;

    public NbtComponentPredicate(NBT tag) {
        this.tag = tag;
    }

    public static NbtComponentPredicate read(PacketWrapper<?> wrapper) {
        NBT tag = wrapper.readNBTRaw();
        return new NbtComponentPredicate(tag);
    }

    public static void write(PacketWrapper<?> wrapper, NbtComponentPredicate predicate) {
        wrapper.writeNBTRaw(predicate.tag);
    }

    public NBT getTag() {
        return this.tag;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NbtComponentPredicate)) {
            return false;
        }
        NbtComponentPredicate that = (NbtComponentPredicate)obj;
        return this.tag.equals(that.tag);
    }

    public int hashCode() {
        return Objects.hashCode(this.tag);
    }
}

