/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.packetevents.api.protocol.entity.cat;

import NC.noChance.packetevents.api.protocol.entity.cat.CatVariants;
import NC.noChance.packetevents.api.protocol.entity.cat.StaticCatVariant;
import NC.noChance.packetevents.api.protocol.mapper.CopyableEntity;
import NC.noChance.packetevents.api.protocol.mapper.DeepComparableEntity;
import NC.noChance.packetevents.api.protocol.mapper.MappedEntity;
import NC.noChance.packetevents.api.protocol.nbt.NBT;
import NC.noChance.packetevents.api.protocol.nbt.NBTCompound;
import NC.noChance.packetevents.api.protocol.nbt.NBTString;
import NC.noChance.packetevents.api.protocol.player.ClientVersion;
import NC.noChance.packetevents.api.resources.ResourceLocation;
import NC.noChance.packetevents.api.util.mappings.TypesBuilderData;
import NC.noChance.packetevents.api.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public interface CatVariant
extends MappedEntity,
CopyableEntity<CatVariant>,
DeepComparableEntity {
    public ResourceLocation getAssetId();

    public static CatVariant read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntity(CatVariants.getRegistry());
    }

    public static void write(PacketWrapper<?> wrapper, CatVariant variant) {
        wrapper.writeMappedEntity(variant);
    }

    public static CatVariant decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        ResourceLocation assetId = new ResourceLocation(compound.getStringTagValueOrThrow("asset_id"));
        return new StaticCatVariant(data, assetId);
    }

    public static NBT encode(CatVariant variant, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("asset_id", new NBTString(variant.getAssetId().toString()));
        return compound;
    }
}

