/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.packetevents.api.protocol.item;

import NC.noChance.packetevents.api.protocol.component.ComponentType;
import NC.noChance.packetevents.api.protocol.component.HashedComponentPatchMap;
import NC.noChance.packetevents.api.protocol.item.ItemStack;
import NC.noChance.packetevents.api.protocol.item.type.ItemType;
import NC.noChance.packetevents.api.protocol.item.type.ItemTypes;
import NC.noChance.packetevents.api.wrapper.PacketWrapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;

public final class HashedStack {
    private final ItemType item;
    private final int count;
    private final HashedComponentPatchMap components;

    public HashedStack(ItemType item, int count, HashedComponentPatchMap components) {
        this.item = item;
        this.count = count;
        this.components = components;
    }

    public static Optional<HashedStack> read(PacketWrapper<?> wrapper) {
        if (!wrapper.readBoolean()) {
            return Optional.empty();
        }
        ItemType item = wrapper.readMappedEntity(ItemTypes.getRegistry());
        int count = wrapper.readVarInt();
        HashedComponentPatchMap components = HashedComponentPatchMap.read(wrapper);
        return Optional.of(new HashedStack(item, count, components));
    }

    public static void write(PacketWrapper<?> wrapper, Optional<HashedStack> optStack) {
        if (optStack == null || !optStack.isPresent()) {
            wrapper.writeBoolean(false);
        } else {
            wrapper.writeBoolean(true);
            HashedStack stack = optStack.get();
            wrapper.writeMappedEntity(stack.item);
            wrapper.writeVarInt(stack.count);
            HashedComponentPatchMap.write(wrapper, stack.components);
        }
    }

    public static Optional<HashedStack> fromItemStack(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return Optional.empty();
        }
        Map<ComponentType<?>, Optional<?>> patches = stack.getComponents().getPatches();
        HashMap addedComponents = new HashMap(patches.size());
        HashSet removedComponents = new HashSet(patches.size());
        for (Map.Entry<ComponentType<?>, Optional<?>> patch : patches.entrySet()) {
            if (patch.getValue().isPresent()) {
                addedComponents.put(patch.getKey(), 0);
                continue;
            }
            removedComponents.add(patch.getKey());
        }
        HashedComponentPatchMap map = new HashedComponentPatchMap(addedComponents, removedComponents);
        return Optional.of(new HashedStack(stack.getType(), stack.getAmount(), map));
    }

    public ItemStack asItemStack() {
        ItemStack stack = ItemStack.builder().type(this.item).amount(this.count).build();
        for (ComponentType<?> component : this.components.getRemovedComponents()) {
            stack.unsetComponent(component);
        }
        return stack;
    }

    public ItemType getItem() {
        return this.item;
    }

    public int getCount() {
        return this.count;
    }

    public HashedComponentPatchMap getComponents() {
        return this.components;
    }
}

