/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.packetevents.api.protocol.item.banner;

import NC.noChance.packetevents.api.protocol.item.banner.BannerPattern;
import NC.noChance.packetevents.api.protocol.mapper.AbstractMappedEntity;
import NC.noChance.packetevents.api.resources.ResourceLocation;
import NC.noChance.packetevents.api.util.mappings.TypesBuilderData;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class StaticBannerPattern
extends AbstractMappedEntity
implements BannerPattern {
    private final ResourceLocation assetId;
    private final String translationKey;

    public StaticBannerPattern(ResourceLocation assetId, String translationKey) {
        this(null, assetId, translationKey);
    }

    @ApiStatus.Internal
    public StaticBannerPattern(@Nullable TypesBuilderData data, ResourceLocation assetId, String translationKey) {
        super(data);
        this.assetId = assetId;
        this.translationKey = translationKey;
    }

    @Override
    public BannerPattern copy(@Nullable TypesBuilderData newData) {
        return new StaticBannerPattern(newData, this.assetId, this.translationKey);
    }

    @Override
    public ResourceLocation getAssetId() {
        return this.assetId;
    }

    @Override
    public String getTranslationKey() {
        return this.translationKey;
    }

    @Override
    public boolean deepEquals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StaticBannerPattern)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        StaticBannerPattern that = (StaticBannerPattern)obj;
        if (!this.assetId.equals(that.assetId)) {
            return false;
        }
        return this.translationKey.equals(that.translationKey);
    }

    @Override
    public int deepHashCode() {
        return Objects.hash(super.hashCode(), this.assetId, this.translationKey);
    }

    @Override
    public String toString() {
        return "StaticBannerPattern{assetId=" + this.assetId + ", translationKey='" + this.translationKey + '\'' + '}';
    }
}

