/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.packetevents.api.protocol.item.instrument;

import NC.noChance.packetevents.api.protocol.item.instrument.Instrument;
import NC.noChance.packetevents.api.protocol.mapper.AbstractMappedEntity;
import NC.noChance.packetevents.api.protocol.sound.Sound;
import NC.noChance.packetevents.api.util.mappings.TypesBuilderData;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class StaticInstrument
extends AbstractMappedEntity
implements Instrument {
    private final Sound sound;
    private final float useSeconds;
    private final float range;
    private final Component description;

    @Deprecated
    public StaticInstrument(Sound sound, int useDuration, float range) {
        this(sound, (float)useDuration * 20.0f, range, Component.empty());
    }

    public StaticInstrument(Sound sound, float useSeconds, float range, Component description) {
        this(null, sound, useSeconds, range, description);
    }

    @ApiStatus.Internal
    public StaticInstrument(@Nullable TypesBuilderData data, Sound sound, float useSeconds, float range, Component description) {
        super(data);
        this.sound = sound;
        this.useSeconds = useSeconds;
        this.range = range;
        this.description = description;
    }

    @Override
    public Instrument copy(@Nullable TypesBuilderData newData) {
        return new StaticInstrument(newData, this.sound, this.useSeconds, this.range, this.description);
    }

    @Override
    public Sound getSound() {
        return this.sound;
    }

    @Override
    public float getUseSeconds() {
        return this.useSeconds;
    }

    @Override
    public float getRange() {
        return this.range;
    }

    @Override
    public Component getDescription() {
        return this.description;
    }

    @Override
    public boolean deepEquals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StaticInstrument)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        StaticInstrument that = (StaticInstrument)obj;
        if (this.useSeconds != that.useSeconds) {
            return false;
        }
        if (Float.compare(that.range, this.range) != 0) {
            return false;
        }
        if (!this.sound.equals(that.sound)) {
            return false;
        }
        return this.description.equals(that.description);
    }

    @Override
    public int deepHashCode() {
        return Objects.hash(super.hashCode(), this.sound, Float.valueOf(this.useSeconds), Float.valueOf(this.range), this.description);
    }
}

