/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.packetevents.api.protocol.sound;

import NC.noChance.packetevents.api.protocol.mapper.MappedEntity;
import NC.noChance.packetevents.api.protocol.nbt.NBT;
import NC.noChance.packetevents.api.protocol.nbt.NBTCompound;
import NC.noChance.packetevents.api.protocol.nbt.NBTFloat;
import NC.noChance.packetevents.api.protocol.nbt.NBTNumber;
import NC.noChance.packetevents.api.protocol.nbt.NBTString;
import NC.noChance.packetevents.api.protocol.player.ClientVersion;
import NC.noChance.packetevents.api.protocol.sound.Sounds;
import NC.noChance.packetevents.api.protocol.sound.StaticSound;
import NC.noChance.packetevents.api.resources.ResourceLocation;
import NC.noChance.packetevents.api.wrapper.PacketWrapper;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public interface Sound
extends MappedEntity {
    public ResourceLocation getSoundId();

    @Nullable
    public Float getRange();

    public static Sound read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntityOrDirect(Sounds::getById, Sound::readDirect);
    }

    public static Sound readDirect(PacketWrapper<?> wrapper) {
        ResourceLocation soundId = wrapper.readIdentifier();
        Float range = (Float)wrapper.readOptional(PacketWrapper::readFloat);
        return new StaticSound(soundId, range);
    }

    public static void write(PacketWrapper<?> wrapper, Sound sound) {
        wrapper.writeMappedEntityOrDirect(sound, Sound::writeDirect);
    }

    public static void writeDirect(PacketWrapper<?> wrapper, Sound sound) {
        wrapper.writeIdentifier(sound.getSoundId());
        wrapper.writeOptional(sound.getRange(), PacketWrapper::writeFloat);
    }

    @Deprecated
    public static Sound decode(NBT nbt, ClientVersion version) {
        return Sound.decode(nbt, PacketWrapper.createDummyWrapper(version));
    }

    public static Sound decode(NBT nbt, PacketWrapper<?> wrapper) {
        if (nbt instanceof NBTString) {
            return Sounds.getByNameOrCreate(((NBTString)nbt).getValue());
        }
        NBTCompound compound = (NBTCompound)nbt;
        ResourceLocation soundId = new ResourceLocation(((NBTCompound)nbt).getStringTagValueOrThrow("sound_id"));
        Float range = Optional.ofNullable(compound.getNumberTagOrNull("range")).map(NBTNumber::getAsFloat).orElse(null);
        return new StaticSound(soundId, range);
    }

    @Deprecated
    public static NBT encode(Sound sound, ClientVersion version) {
        return Sound.encode(PacketWrapper.createDummyWrapper(version), sound);
    }

    public static NBT encode(PacketWrapper<?> wrapper, Sound sound) {
        if (sound.isRegistered()) {
            return new NBTString(sound.getName().toString());
        }
        NBTCompound compound = new NBTCompound();
        compound.setTag("sound_id", new NBTString(sound.getSoundId().toString()));
        if (sound.getRange() != null) {
            compound.setTag("range", new NBTFloat(sound.getRange().floatValue()));
        }
        return compound;
    }
}

