/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.packetevents.api.protocol.stream;

import NC.noChance.packetevents.api.netty.buffer.ByteBufHelper;
import NC.noChance.packetevents.api.protocol.stream.NetStreamInput;
import NC.noChance.packetevents.api.wrapper.PacketWrapper;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class NetStreamInputWrapper
extends NetStreamInput {
    private final PacketWrapper<?> wrapper;

    public NetStreamInputWrapper(PacketWrapper<?> wrapper) {
        super(null);
        this.wrapper = wrapper;
    }

    @Override
    public int read() {
        return this.wrapper.readUnsignedByte();
    }

    @Override
    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) {
        int ri = ByteBufHelper.readerIndex(this.wrapper.buffer);
        ByteBufHelper.readBytes(this.wrapper.buffer, b, off, len);
        return ByteBufHelper.readerIndex(this.wrapper.buffer) - ri;
    }

    @Override
    public long skip(long n) {
        int ri = ByteBufHelper.readerIndex(this.wrapper.buffer);
        ByteBufHelper.skipBytes(this.wrapper.buffer, (int)n);
        return ByteBufHelper.readerIndex(this.wrapper.buffer) - ri;
    }

    @Override
    public int available() {
        return ByteBufHelper.readableBytes(this.wrapper.buffer);
    }

    @Override
    public void close() {
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public PacketWrapper<?> getWrapper() {
        return this.wrapper;
    }
}

