/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.packetevents.api.protocol.world.chunk.palette;

import NC.noChance.packetevents.api.protocol.stream.NetStreamInput;
import NC.noChance.packetevents.api.protocol.stream.NetStreamOutput;
import NC.noChance.packetevents.api.protocol.world.chunk.palette.GlobalPalette;
import NC.noChance.packetevents.api.protocol.world.chunk.palette.ListPalette;
import NC.noChance.packetevents.api.protocol.world.chunk.palette.MapPalette;
import NC.noChance.packetevents.api.protocol.world.chunk.palette.Palette;
import NC.noChance.packetevents.api.protocol.world.chunk.palette.PaletteType;
import NC.noChance.packetevents.api.protocol.world.chunk.palette.SingletonPalette;
import NC.noChance.packetevents.api.protocol.world.chunk.storage.BaseStorage;
import NC.noChance.packetevents.api.protocol.world.chunk.storage.BitStorage;
import NC.noChance.packetevents.api.protocol.world.chunk.storage.LegacyFlexibleStorage;

public class DataPalette {
    public final PaletteType paletteType;
    public Palette palette;
    public BaseStorage storage;

    public DataPalette(Palette palette, BaseStorage storage, PaletteType paletteType) {
        this.palette = palette;
        this.storage = storage;
        this.paletteType = paletteType;
    }

    @Deprecated
    public static DataPalette createForChunk() {
        return PaletteType.CHUNK.create();
    }

    @Deprecated
    public static DataPalette createForBiome() {
        return PaletteType.BIOME.create();
    }

    @Deprecated
    public static DataPalette createEmpty(PaletteType paletteType) {
        return paletteType.create();
    }

    @Deprecated
    public static DataPalette read(NetStreamInput in, PaletteType paletteType) {
        return DataPalette.read(in, paletteType, true);
    }

    @Deprecated
    public static DataPalette read(NetStreamInput in, PaletteType paletteType, boolean allowSingletonPalette) {
        return DataPalette.read(in, paletteType, allowSingletonPalette, true);
    }

    @Deprecated
    public static DataPalette read(NetStreamInput in, PaletteType paletteType, boolean allowSingletonPalette, boolean lengthPrefix) {
        BitStorage storage;
        byte bitsPerEntry = in.readByte();
        Palette palette = DataPalette.readPalette(paletteType, bitsPerEntry, in, allowSingletonPalette);
        if (!(palette instanceof SingletonPalette)) {
            long[] data = lengthPrefix ? in.readLongs(in.readVarInt()) : null;
            storage = new BitStorage(bitsPerEntry, paletteType.getStorageSize(), data);
            if (!lengthPrefix) {
                in.readLongs(storage.getData());
            }
        } else {
            if (lengthPrefix) {
                in.readLongs(in.readVarInt());
            }
            storage = null;
        }
        return new DataPalette(palette, storage, paletteType);
    }

    @Deprecated
    public static void write(NetStreamOutput out, DataPalette palette) {
        DataPalette.write(out, palette, true);
    }

    @Deprecated
    public static void write(NetStreamOutput out, DataPalette palette, boolean lengthPrefix) {
        if (palette.palette instanceof SingletonPalette) {
            out.writeByte(0);
            out.writeVarInt(palette.palette.idToState(0));
            if (lengthPrefix) {
                out.writeVarInt(0);
            }
            return;
        }
        out.writeByte(palette.storage.getBitsPerEntry());
        if (!(palette.palette instanceof GlobalPalette)) {
            int paletteLength = palette.palette.size();
            out.writeVarInt(paletteLength);
            for (int i = 0; i < paletteLength; ++i) {
                out.writeVarInt(palette.palette.idToState(i));
            }
        }
        long[] data = palette.storage.getData();
        if (lengthPrefix) {
            out.writeVarInt(data.length);
        }
        out.writeLongs(data);
    }

    @Deprecated
    public static DataPalette readLegacy(NetStreamInput in) {
        int bitsPerEntry = Math.max(4, in.readByte() & 0xFF);
        Palette palette = DataPalette.readPalette(PaletteType.CHUNK, bitsPerEntry, in, false);
        LegacyFlexibleStorage storage = new LegacyFlexibleStorage(bitsPerEntry, in.readLongs(in.readVarInt()));
        return new DataPalette(palette, storage, PaletteType.CHUNK);
    }

    public int get(int x, int y, int z) {
        if (this.storage != null) {
            int id = this.storage.get(DataPalette.index(this.paletteType, x, y, z));
            return this.palette.idToState(id);
        }
        return this.palette.idToState(0);
    }

    public int set(int x, int y, int z, int state) {
        int id = this.palette.stateToId(state);
        if (id == -1) {
            this.resizeOneUp();
            id = this.palette.stateToId(state);
        }
        if (this.storage != null) {
            int index = DataPalette.index(this.paletteType, x, y, z);
            int curr = this.storage.get(index);
            this.storage.set(index, id);
            return curr;
        }
        return state;
    }

    @Deprecated
    private static Palette readPalette(PaletteType paletteType, int bitsPerEntry, NetStreamInput in, boolean allowSingletonPalette) {
        if (bitsPerEntry == 0 && allowSingletonPalette) {
            return new SingletonPalette(in);
        }
        if (bitsPerEntry <= paletteType.getMaxBitsPerEntryForList()) {
            int bits = paletteType.isForceMaxListPaletteSize() ? paletteType.getMaxBitsPerEntryForList() : bitsPerEntry;
            return new ListPalette(bits, in);
        }
        if (bitsPerEntry <= paletteType.getMaxBitsPerEntryForMap()) {
            return new MapPalette(bitsPerEntry, in);
        }
        return GlobalPalette.INSTANCE;
    }

    private void resizeOneUp() {
        Palette oldPalette = this.palette;
        BaseStorage oldData = this.storage;
        int prevBitsPerEntry = oldData != null ? oldData.getBitsPerEntry() : 0;
        this.palette = DataPalette.createPalette(prevBitsPerEntry + 1, this.paletteType);
        this.storage = new BitStorage(this.palette.getBits(), this.paletteType.getStorageSize());
        if (oldData != null) {
            int len = this.paletteType.getStorageSize();
            for (int i = 0; i < len; ++i) {
                this.storage.set(i, this.palette.stateToId(oldPalette.idToState(oldData.get(i))));
            }
        } else {
            this.palette.stateToId(oldPalette.idToState(0));
        }
    }

    private static Palette createPalette(int bitsPerEntry, PaletteType paletteType) {
        if (bitsPerEntry <= paletteType.getMaxBitsPerEntryForList()) {
            int bits = paletteType.isForceMaxListPaletteSize() ? paletteType.getMaxBitsPerEntryForList() : bitsPerEntry;
            return new ListPalette(bits);
        }
        if (bitsPerEntry <= paletteType.getMaxBitsPerEntryForMap()) {
            return new MapPalette(bitsPerEntry);
        }
        return GlobalPalette.INSTANCE;
    }

    private static int index(PaletteType paletteType, int x, int y, int z) {
        return (y << paletteType.getBitShift() | z) << paletteType.getBitShift() | x;
    }
}

