/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.packetevents.api.util;

import NC.noChance.packetevents.api.PacketEvents;
import java.util.logging.Level;
import java.util.regex.Pattern;
import net.kyori.adventure.text.format.NamedTextColor;
import org.jetbrains.annotations.Nullable;

public class LogManager {
    protected static final Pattern STRIP_COLOR_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-FK-ORX]");

    protected void log(Level level, @Nullable NamedTextColor color, String message) {
        message = STRIP_COLOR_PATTERN.matcher(message).replaceAll("");
        PacketEvents.getAPI().getLogger().log(level, color != null ? color.toString() : "" + message);
    }

    public void info(String message) {
        this.log(Level.INFO, null, message);
    }

    public void warn(String message) {
        this.log(Level.WARNING, null, message);
    }

    public void severe(String message) {
        this.log(Level.SEVERE, null, message);
    }

    public void debug(String message) {
        if (this.isDebug()) {
            this.log(Level.FINE, null, message);
        }
    }

    public boolean isDebug() {
        return PacketEvents.getAPI().getSettings().isDebugEnabled();
    }
}

