/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.packetevents.api.util.adventure;

import NC.noChance.packetevents.api.PacketEvents;
import NC.noChance.packetevents.api.protocol.nbt.NBT;
import NC.noChance.packetevents.api.protocol.player.ClientVersion;
import NC.noChance.packetevents.api.protocol.stats.Statistics;
import NC.noChance.packetevents.api.protocol.util.NbtDecoder;
import NC.noChance.packetevents.api.protocol.util.NbtEncoder;
import NC.noChance.packetevents.api.util.adventure.AdventureNBTSerializer;
import NC.noChance.packetevents.api.wrapper.PacketWrapper;
import NC.noChance.packetevents.impl.adventure.serializer.gson.GsonComponentSerializer;
import NC.noChance.packetevents.impl.adventure.serializer.json.JSONOptions;
import NC.noChance.packetevents.impl.adventure.serializer.json.legacyimpl.NBTLegacyHoverEventSerializer;
import NC.noChance.packetevents.impl.adventure.serializer.legacy.LegacyComponentSerializer;
import com.google.gson.JsonElement;
import java.util.EnumMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.jspecify.annotations.NullMarked;

@NullMarked
public final class AdventureSerializer
implements NbtEncoder<Component>,
NbtDecoder<Component> {
    private static final Map<ClientVersion, AdventureSerializer> SERIALIZERS = new EnumMap<ClientVersion, AdventureSerializer>(ClientVersion.class);
    private final ClientVersion version;
    @Nullable
    private GsonComponentSerializer gson;
    @Nullable
    private LegacyComponentSerializer legacy;
    @Nullable
    private AdventureNBTSerializer nbt;

    private AdventureSerializer(ClientVersion version) {
        this.version = version;
    }

    public static AdventureSerializer serializer(PacketWrapper<?> wrapper) {
        return AdventureSerializer.serializer(wrapper.getServerVersion().toClientVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AdventureSerializer serializer(ClientVersion version) {
        AdventureSerializer holder = SERIALIZERS.get((Object)version);
        if (holder != null) {
            return holder;
        }
        Map<ClientVersion, AdventureSerializer> map = SERIALIZERS;
        synchronized (map) {
            return SERIALIZERS.computeIfAbsent(version, AdventureSerializer::new);
        }
    }

    public static AdventureSerializer serializer() {
        return AdventureSerializer.serializer(PacketEvents.getAPI().getServerManager().getVersion().toClientVersion());
    }

    @Deprecated
    public static GsonComponentSerializer getGsonSerializer() {
        return AdventureSerializer.serializer().gson();
    }

    @Deprecated
    public static LegacyComponentSerializer getLegacyGsonSerializer() {
        return AdventureSerializer.serializer().legacy();
    }

    @Deprecated
    public static LegacyComponentSerializer getLegacySerializer() {
        return AdventureSerializer.serializer().legacy();
    }

    @Deprecated
    public static AdventureNBTSerializer getNBTSerializer() {
        return AdventureSerializer.serializer().nbt();
    }

    @Deprecated
    public static String asVanilla(Component component) {
        return AdventureSerializer.serializer().asLegacy(component);
    }

    @Deprecated
    public static Component fromLegacyFormat(String legacyMessage) {
        return AdventureSerializer.serializer().fromLegacy(legacyMessage);
    }

    @Deprecated
    public static String toLegacyFormat(Component component) {
        return AdventureSerializer.serializer().asLegacy(component);
    }

    @Deprecated
    public static Component parseComponent(String json) {
        return AdventureSerializer.serializer().fromJson(json);
    }

    @Deprecated
    public static Component parseJsonTree(JsonElement json) {
        return AdventureSerializer.serializer().fromJsonTree(json);
    }

    @Deprecated
    public static String toJson(Component component) {
        return AdventureSerializer.serializer().asJson(component);
    }

    @Deprecated
    public static JsonElement toJsonTree(Component component) {
        return AdventureSerializer.serializer().asJsonTree(component);
    }

    @Deprecated
    public static Component fromNbt(NBT tag) {
        return AdventureSerializer.serializer().fromNbtTag(tag);
    }

    @Deprecated
    public static NBT toNbt(Component component) {
        return AdventureSerializer.serializer().asNbtTag(component);
    }

    public Component fromLegacy(String legacy) {
        return this.legacy().deserializeOrNull(legacy);
    }

    public String asLegacy(Component component) {
        return (String)this.legacy().serializeOrNull(component);
    }

    public Component fromJson(String json) {
        return this.gson().deserializeOrNull(json);
    }

    public String asJson(Component component) {
        return (String)this.gson().serializeOrNull(component);
    }

    @Contract(value="!null -> !null")
    @Nullable
    public Component fromJsonTree(@Nullable JsonElement json) {
        return json != null ? this.gson().deserializeFromTree(json) : null;
    }

    @Contract(value="!null -> !null")
    @Nullable
    public JsonElement asJsonTree(@Nullable Component component) {
        return component != null ? this.gson().serializeToTree(component) : null;
    }

    @Deprecated
    public Component fromNbtTag(NBT tag) {
        return this.fromNbtTag(tag, PacketWrapper.createDummyWrapper(this.version));
    }

    public Component fromNbtTag(NBT tag, PacketWrapper<?> wrapper) {
        return this.nbt().deserializeOrNull(tag, wrapper);
    }

    @Deprecated
    public NBT asNbtTag(Component component) {
        return this.asNbtTag(component, PacketWrapper.createDummyWrapper(this.version));
    }

    public NBT asNbtTag(Component component, PacketWrapper<?> wrapper) {
        return this.nbt().serializeOrNull(component, wrapper);
    }

    public GsonComponentSerializer gson() {
        if (this.gson == null) {
            this.gson = GsonComponentSerializer.builder().editOptions(builder -> {
                builder.values(JSONOptions.byDataVersion().at(0)).value(JSONOptions.EMIT_HOVER_EVENT_TYPE, JSONOptions.HoverEventValueMode.BOTH).value(JSONOptions.SHOW_ITEM_HOVER_DATA_MODE, JSONOptions.ShowItemHoverDataMode.EMIT_EITHER);
                if (this.version.isNewerThanOrEquals(ClientVersion.V_1_16) && !PacketEvents.getAPI().getSettings().shouldDownsampleColors()) {
                    builder.value(JSONOptions.EMIT_RGB, true);
                }
                if (this.version.isNewerThanOrEquals(ClientVersion.V_1_20_3)) {
                    builder.value(JSONOptions.EMIT_HOVER_SHOW_ENTITY_ID_AS_INT_ARRAY, true);
                    builder.value(JSONOptions.VALIDATE_STRICT_EVENTS, true);
                }
                if (this.version.isNewerThanOrEquals(ClientVersion.V_1_20_5)) {
                    builder.value(JSONOptions.EMIT_DEFAULT_ITEM_HOVER_QUANTITY, true);
                }
                if (this.version.isNewerThanOrEquals(ClientVersion.V_1_21_4)) {
                    builder.value(JSONOptions.SHADOW_COLOR_MODE, JSONOptions.ShadowColorEmitMode.EMIT_INTEGER);
                }
            }).legacyHoverEventSerializer(NBTLegacyHoverEventSerializer.get()).showAchievementToComponent(input -> Statistics.getById(input).display()).build();
        }
        return this.gson;
    }

    public LegacyComponentSerializer legacy() {
        if (this.legacy == null) {
            LegacyComponentSerializer.Builder builder = LegacyComponentSerializer.builder();
            if (this.version.isNewerThanOrEquals(ClientVersion.V_1_16)) {
                builder.hexColors();
            }
            this.legacy = builder.build();
        }
        return this.legacy;
    }

    public AdventureNBTSerializer nbt() {
        if (this.nbt == null) {
            boolean downsample = this.version.isOlderThan(ClientVersion.V_1_16) || PacketEvents.getAPI().getSettings().shouldDownsampleColors();
            this.nbt = new AdventureNBTSerializer(this.version, downsample);
        }
        return this.nbt;
    }

    @Override
    public Component decode(NBT nbt, PacketWrapper<?> wrapper) {
        return this.nbt().deserialize(nbt, wrapper);
    }

    @Override
    public NBT encode(PacketWrapper<?> wrapper, Component value) {
        return this.nbt().serialize(value, wrapper);
    }
}

