/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.packetevents.api.util.mappings;

import NC.noChance.packetevents.api.PacketEvents;
import NC.noChance.packetevents.api.protocol.chat.ChatType;
import NC.noChance.packetevents.api.protocol.chat.ChatTypes;
import NC.noChance.packetevents.api.protocol.dialog.Dialog;
import NC.noChance.packetevents.api.protocol.dialog.Dialogs;
import NC.noChance.packetevents.api.protocol.entity.cat.CatVariant;
import NC.noChance.packetevents.api.protocol.entity.cat.CatVariants;
import NC.noChance.packetevents.api.protocol.entity.chicken.ChickenVariant;
import NC.noChance.packetevents.api.protocol.entity.chicken.ChickenVariants;
import NC.noChance.packetevents.api.protocol.entity.cow.CowVariant;
import NC.noChance.packetevents.api.protocol.entity.cow.CowVariants;
import NC.noChance.packetevents.api.protocol.entity.frog.FrogVariant;
import NC.noChance.packetevents.api.protocol.entity.frog.FrogVariants;
import NC.noChance.packetevents.api.protocol.entity.pig.PigVariant;
import NC.noChance.packetevents.api.protocol.entity.pig.PigVariants;
import NC.noChance.packetevents.api.protocol.entity.wolfvariant.WolfSoundVariant;
import NC.noChance.packetevents.api.protocol.entity.wolfvariant.WolfSoundVariants;
import NC.noChance.packetevents.api.protocol.entity.wolfvariant.WolfVariant;
import NC.noChance.packetevents.api.protocol.entity.wolfvariant.WolfVariants;
import NC.noChance.packetevents.api.protocol.item.banner.BannerPattern;
import NC.noChance.packetevents.api.protocol.item.banner.BannerPatterns;
import NC.noChance.packetevents.api.protocol.item.enchantment.type.EnchantmentType;
import NC.noChance.packetevents.api.protocol.item.enchantment.type.EnchantmentTypes;
import NC.noChance.packetevents.api.protocol.item.instrument.Instrument;
import NC.noChance.packetevents.api.protocol.item.instrument.Instruments;
import NC.noChance.packetevents.api.protocol.item.jukebox.IJukeboxSong;
import NC.noChance.packetevents.api.protocol.item.jukebox.JukeboxSongs;
import NC.noChance.packetevents.api.protocol.item.trimmaterial.TrimMaterial;
import NC.noChance.packetevents.api.protocol.item.trimmaterial.TrimMaterials;
import NC.noChance.packetevents.api.protocol.item.trimpattern.TrimPattern;
import NC.noChance.packetevents.api.protocol.item.trimpattern.TrimPatterns;
import NC.noChance.packetevents.api.protocol.mapper.CopyableEntity;
import NC.noChance.packetevents.api.protocol.mapper.DeepComparableEntity;
import NC.noChance.packetevents.api.protocol.mapper.MappedEntity;
import NC.noChance.packetevents.api.protocol.mapper.ResolvableEntity;
import NC.noChance.packetevents.api.protocol.nbt.NBT;
import NC.noChance.packetevents.api.protocol.nbt.NBTCompound;
import NC.noChance.packetevents.api.protocol.nbt.NBTList;
import NC.noChance.packetevents.api.protocol.player.ClientVersion;
import NC.noChance.packetevents.api.protocol.player.User;
import NC.noChance.packetevents.api.protocol.world.biome.Biome;
import NC.noChance.packetevents.api.protocol.world.biome.Biomes;
import NC.noChance.packetevents.api.protocol.world.damagetype.DamageType;
import NC.noChance.packetevents.api.protocol.world.damagetype.DamageTypes;
import NC.noChance.packetevents.api.protocol.world.dimension.DimensionType;
import NC.noChance.packetevents.api.protocol.world.dimension.DimensionTypes;
import NC.noChance.packetevents.api.protocol.world.painting.PaintingVariant;
import NC.noChance.packetevents.api.protocol.world.painting.PaintingVariants;
import NC.noChance.packetevents.api.resources.ResourceLocation;
import NC.noChance.packetevents.api.util.mappings.IRegistry;
import NC.noChance.packetevents.api.util.mappings.SimpleRegistry;
import NC.noChance.packetevents.api.util.mappings.SimpleTypesBuilderData;
import NC.noChance.packetevents.api.util.mappings.TypesBuilderData;
import NC.noChance.packetevents.api.wrapper.PacketWrapper;
import NC.noChance.packetevents.api.wrapper.configuration.server.WrapperConfigServerRegistryData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SynchronizedRegistriesHandler {
    private static final boolean FORCE_PER_USER_REGISTRIES = Boolean.getBoolean("packetevents.force-per-user-registries");
    private static final Map<ResourceLocation, RegistryEntry<?>> REGISTRY_KEYS = new HashMap();

    private SynchronizedRegistriesHandler() {
    }

    @Nullable
    public static RegistryEntry<?> getRegistryEntry(ResourceLocation registryKey) {
        return REGISTRY_KEYS.get(registryKey);
    }

    public static void handleRegistry(User user, PacketWrapper<?> wrapper, ResourceLocation registryName, List<WrapperConfigServerRegistryData.RegistryElement> elements) {
        Object cacheKey = PacketEvents.getAPI().getServerManager().getRegistryCacheKey(user, wrapper.getServerVersion().toClientVersion());
        SynchronizedRegistriesHandler.handleRegistry(user, wrapper, registryName, elements, cacheKey);
    }

    public static void handleRegistry(User user, PacketWrapper<?> wrapper, ResourceLocation registryName, List<WrapperConfigServerRegistryData.RegistryElement> elements, Object cacheKey) {
        RegistryEntry<?> registryData = REGISTRY_KEYS.get(registryName);
        if (registryData == null) {
            return;
        }
        SimpleRegistry<?> syncedRegistry = FORCE_PER_USER_REGISTRIES || cacheKey == null ? registryData.createFromElements(elements, wrapper) : registryData.computeSyncedRegistry(cacheKey, () -> registryData.createFromElements(elements, wrapper));
        user.putRegistry(syncedRegistry);
        for (MappedEntity entry : syncedRegistry.getEntries()) {
            if (!(entry instanceof ResolvableEntity)) continue;
            ((ResolvableEntity)((Object)entry)).doResolve(wrapper);
        }
    }

    public static void handleLegacyRegistries(User user, PacketWrapper<?> wrapper, NBTCompound registryData) {
        Object cacheKey = PacketEvents.getAPI().getServerManager().getRegistryCacheKey(user, wrapper.getServerVersion().toClientVersion());
        for (NBT tag : registryData.getTags().values()) {
            if (tag instanceof NBTList) {
                NBTList list = (NBTList)tag;
                SynchronizedRegistriesHandler.handleRegistry(user, wrapper, DimensionTypes.getRegistry().getRegistryKey(), WrapperConfigServerRegistryData.RegistryElement.convertNbt(list), cacheKey);
                continue;
            }
            NBTCompound compound = (NBTCompound)tag;
            ResourceLocation registryName = new ResourceLocation(compound.getStringTagValueOrThrow("type"));
            NBTList<NBTCompound> nbtElements = compound.getCompoundListTagOrNull("value");
            if (nbtElements == null) continue;
            SynchronizedRegistriesHandler.handleRegistry(user, wrapper, registryName, WrapperConfigServerRegistryData.RegistryElement.convertNbt(nbtElements), cacheKey);
        }
    }

    static {
        Stream.of(new RegistryEntry<Biome>(Biomes.getRegistry(), Biome::decode), new RegistryEntry<ChatType>(ChatTypes.getRegistry(), ChatType::decode), new RegistryEntry<TrimPattern>(TrimPatterns.getRegistry(), TrimPattern::decode), new RegistryEntry<TrimMaterial>(TrimMaterials.getRegistry(), TrimMaterial::decode), new RegistryEntry<WolfVariant>(WolfVariants.getRegistry(), WolfVariant::decode), new RegistryEntry<WolfSoundVariant>(WolfSoundVariants.getRegistry(), WolfSoundVariant::decode), new RegistryEntry<PigVariant>(PigVariants.getRegistry(), PigVariant::decode), new RegistryEntry<FrogVariant>(FrogVariants.getRegistry(), FrogVariant::decode), new RegistryEntry<CatVariant>(CatVariants.getRegistry(), CatVariant::decode), new RegistryEntry<CowVariant>(CowVariants.getRegistry(), CowVariant::decode), new RegistryEntry<ChickenVariant>(ChickenVariants.getRegistry(), ChickenVariant::decode), new RegistryEntry<PaintingVariant>(PaintingVariants.getRegistry(), PaintingVariant::decode), new RegistryEntry<DimensionType>(DimensionTypes.getRegistry(), DimensionType::decode), new RegistryEntry<DamageType>(DamageTypes.getRegistry(), DamageType::decode), new RegistryEntry<BannerPattern>(BannerPatterns.getRegistry(), BannerPattern::decode), new RegistryEntry<EnchantmentType>(EnchantmentTypes.getRegistry(), EnchantmentType::decode), new RegistryEntry<IJukeboxSong>(JukeboxSongs.getRegistry(), IJukeboxSong::decode), new RegistryEntry<Instrument>(Instruments.getRegistry(), Instrument::decode), new RegistryEntry<Dialog>(Dialogs.getRegistry(), Dialog::decodeDirect)).forEach(entry -> REGISTRY_KEYS.put(entry.getRegistryKey(), (RegistryEntry<?>)entry));
    }

    @ApiStatus.Internal
    public static final class RegistryEntry<T extends MappedEntity & CopyableEntity<T>> {
        private final IRegistry<T> baseRegistry;
        private final NbtEntryDecoder<T> decoder;
        private final Map<Object, SimpleRegistry<T>> syncedRegistries = new ConcurrentHashMap<Object, SimpleRegistry<T>>(2);

        public RegistryEntry(IRegistry<T> baseRegistry, LegacyNbtEntryDecoder<T> decoder) {
            this(baseRegistry, decoder.upgrade());
        }

        public RegistryEntry(IRegistry<T> baseRegistry, NbtEntryDecoder<T> decoder) {
            this.baseRegistry = baseRegistry;
            this.decoder = decoder;
        }

        @Nullable
        public SimpleRegistry<T> getSyncedRegistry(Object key) {
            return this.syncedRegistries.get(key);
        }

        public SimpleRegistry<T> computeSyncedRegistry(Object key, Supplier<SimpleRegistry<?>> registry) {
            return this.syncedRegistries.computeIfAbsent(key, $ -> (SimpleRegistry)registry.get());
        }

        private void handleElement(SimpleRegistry<T> registry, WrapperConfigServerRegistryData.RegistryElement element, int id, PacketWrapper<?> wrapper) {
            MappedEntity value;
            Object copiedBaseEntry;
            ResourceLocation elementName = element.getId();
            T baseEntry = this.baseRegistry.getByName(elementName);
            SimpleTypesBuilderData data = new SimpleTypesBuilderData(elementName, id);
            Object z = copiedBaseEntry = baseEntry == null ? null : (Object)((CopyableEntity)baseEntry).copy(data);
            if (element.getData() != null && !((DeepComparableEntity)((Object)(value = (MappedEntity)this.decoder.decode(element.getData(), wrapper, data)))).deepEquals(copiedBaseEntry)) {
                registry.define(elementName, id, value);
                return;
            }
            if (copiedBaseEntry != null) {
                registry.define(elementName, id, copiedBaseEntry);
                return;
            }
            PacketEvents.getAPI().getLogger().warning("Unknown registry entry " + elementName + " for " + this.getRegistryKey());
        }

        public SimpleRegistry<T> createFromElements(List<WrapperConfigServerRegistryData.RegistryElement> elements, PacketWrapper<?> wrapper) {
            SimpleRegistry registry = new SimpleRegistry(this.getRegistryKey());
            for (int id = 0; id < elements.size(); ++id) {
                WrapperConfigServerRegistryData.RegistryElement element = elements.get(id);
                this.handleElement(registry, element, id, wrapper);
            }
            return registry;
        }

        public ResourceLocation getRegistryKey() {
            return this.baseRegistry.getRegistryKey();
        }
    }

    @FunctionalInterface
    @ApiStatus.Internal
    public static interface LegacyNbtEntryDecoder<T> {
        public T decode(NBT var1, ClientVersion var2, @Nullable TypesBuilderData var3);

        default public NbtEntryDecoder<T> upgrade() {
            return (nbt, wrapper, data) -> this.decode(nbt, wrapper.getServerVersion().toClientVersion(), data);
        }
    }

    @FunctionalInterface
    @ApiStatus.Internal
    public static interface NbtEntryDecoder<T> {
        public T decode(NBT var1, PacketWrapper<?> var2, @Nullable TypesBuilderData var3);
    }
}

