/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.packetevents.api.util.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class Reflection {
    public static Field[] getFields(Class<?> cls) {
        Field[] declaredFields;
        if (cls == null) {
            return new Field[0];
        }
        for (Field f : declaredFields = cls.getDeclaredFields()) {
            try {
                f.setAccessible(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return declaredFields;
    }

    public static Field getField(Class<?> cls, String name) {
        if (cls == null) {
            return null;
        }
        try {
            Field field = cls.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            if (cls.getSuperclass() != null) {
                return Reflection.getField(cls.getSuperclass(), name);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static Field getField(Class<?> cls, Class<?> dataType, int index) {
        if (dataType == null || cls == null) {
            return null;
        }
        int currentIndex = 0;
        for (Field f : Reflection.getFields(cls)) {
            if (!dataType.isAssignableFrom(f.getType()) || currentIndex++ != index) continue;
            return f;
        }
        if (cls.getSuperclass() != null) {
            return Reflection.getField(cls.getSuperclass(), dataType, index);
        }
        return null;
    }

    public static Field getField(Class<?> cls, Class<?> dataType, int index, boolean ignoreStatic) {
        if (dataType == null || cls == null) {
            return null;
        }
        int currentIndex = 0;
        for (Field f : Reflection.getFields(cls)) {
            if (!dataType.isAssignableFrom(f.getType()) || ignoreStatic && Modifier.isStatic(f.getModifiers()) || currentIndex++ != index) continue;
            return f;
        }
        if (cls.getSuperclass() != null) {
            return Reflection.getField(cls.getSuperclass(), dataType, index);
        }
        return null;
    }

    public static Field getField(Class<?> cls, int index) {
        if (cls == null) {
            return null;
        }
        try {
            return Reflection.getFields(cls)[index];
        }
        catch (Exception ex) {
            if (cls.getSuperclass() != null) {
                return Reflection.getFields(cls.getSuperclass())[index];
            }
            return null;
        }
    }

    public static Method getMethod(Class<?> cls, String name, Class<?> ... params) {
        if (cls == null) {
            return null;
        }
        try {
            Method m = cls.getDeclaredMethod(name, params);
            m.setAccessible(true);
            return m;
        }
        catch (NoSuchMethodException e) {
            try {
                Method m = cls.getMethod(name, params);
                m.setAccessible(true);
                return m;
            }
            catch (NoSuchMethodException e1) {
                if (cls.getSuperclass() != null) {
                    return Reflection.getMethod(cls.getSuperclass(), name, params);
                }
                return null;
            }
        }
    }

    public static Method getMethod(Class<?> cls, int index, Class<?> ... params) {
        if (cls == null) {
            return null;
        }
        int currentIndex = 0;
        for (Method m : cls.getDeclaredMethods()) {
            if (params != null && !Arrays.equals(m.getParameterTypes(), params) || index != currentIndex++) continue;
            m.setAccessible(true);
            return m;
        }
        if (cls.getSuperclass() != null) {
            return Reflection.getMethod(cls.getSuperclass(), index, params);
        }
        return null;
    }

    public static Method getMethod(Class<?> cls, Class<?> returning, int index, Class<?> ... params) {
        if (cls == null) {
            return null;
        }
        int currentIndex = 0;
        for (Method m : cls.getDeclaredMethods()) {
            if (!Arrays.equals(m.getParameterTypes(), params) || returning != null && !m.getReturnType().equals(returning) || index != currentIndex++) continue;
            m.setAccessible(true);
            return m;
        }
        if (cls.getSuperclass() != null) {
            return Reflection.getMethod(cls.getSuperclass(), null, index, params);
        }
        return null;
    }

    public static Method getMethodExact(Class<?> cls, String name, Class<?> returning, Class<?> ... params) {
        if (cls == null) {
            return null;
        }
        for (Method m : cls.getDeclaredMethods()) {
            if (!m.getName().equals(name) || !Arrays.equals(m.getParameterTypes(), params) || returning != null && !m.getReturnType().equals(returning)) continue;
            m.setAccessible(true);
            return m;
        }
        if (cls.getSuperclass() != null) {
            return Reflection.getMethodExact(cls.getSuperclass(), name, null, params);
        }
        return null;
    }

    public static Method getMethod(Class<?> cls, String name, int index) {
        if (cls == null) {
            return null;
        }
        int currentIndex = 0;
        for (Method m : cls.getDeclaredMethods()) {
            if (!m.getName().equals(name) || index != currentIndex++) continue;
            m.setAccessible(true);
            return m;
        }
        if (cls.getSuperclass() != null) {
            return Reflection.getMethod(cls.getSuperclass(), name, index);
        }
        return null;
    }

    public static Method getMethod(Class<?> cls, Class<?> returning, int index) {
        if (cls == null) {
            return null;
        }
        int currentIndex = 0;
        for (Method m : cls.getDeclaredMethods()) {
            if (returning != null && !m.getReturnType().equals(returning) || index != currentIndex++) continue;
            m.setAccessible(true);
            return m;
        }
        if (cls.getSuperclass() != null) {
            return Reflection.getMethod(cls.getSuperclass(), returning, index);
        }
        return null;
    }

    public static Method getMethodCheckContainsString(Class<?> cls, String nameContainsThisStr, Class<?> returning) {
        if (cls == null) {
            return null;
        }
        for (Method m : cls.getDeclaredMethods()) {
            if (!m.getName().contains(nameContainsThisStr) || returning != null && !m.getReturnType().equals(returning)) continue;
            m.setAccessible(true);
            return m;
        }
        if (cls.getSuperclass() != null) {
            return Reflection.getMethodCheckContainsString(cls.getSuperclass(), nameContainsThisStr, returning);
        }
        return null;
    }

    public static List<Method> getMethods(Class<?> cls, String name, Class<?> returning) {
        if (cls == null) {
            return null;
        }
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method m : cls.getDeclaredMethods()) {
            if (!m.getName().equals(name) || returning != null && !m.getReturnType().equals(returning)) continue;
            m.setAccessible(true);
            methods.add(m);
        }
        if (cls.getSuperclass() != null) {
            methods.addAll(Reflection.getMethods(cls.getSuperclass(), name, returning));
        }
        return methods;
    }

    @Nullable
    public static Class<?> getClassByNameWithoutException(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Constructor<?> getConstructor(Class<?> cls, int index) {
        if (cls == null) {
            return null;
        }
        Constructor<?> constructor = cls.getDeclaredConstructors()[index];
        constructor.setAccessible(true);
        return constructor;
    }

    public static Constructor<?> getConstructor(Class<?> cls, Class<?> ... params) {
        if (cls == null) {
            return null;
        }
        try {
            Constructor<?> c = cls.getDeclaredConstructor(params);
            c.setAccessible(true);
            return c;
        }
        catch (NoSuchMethodException e) {
            try {
                Constructor<?> c = cls.getConstructor(params);
                c.setAccessible(true);
                return c;
            }
            catch (NoSuchMethodException e1) {
                return null;
            }
        }
    }
}

