/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.packetevents.api.wrapper.common.client;

import NC.noChance.packetevents.api.event.PacketReceiveEvent;
import NC.noChance.packetevents.api.manager.server.ServerVersion;
import NC.noChance.packetevents.api.protocol.packettype.PacketTypeCommon;
import NC.noChance.packetevents.api.protocol.player.HumanoidArm;
import NC.noChance.packetevents.api.protocol.player.SkinSection;
import NC.noChance.packetevents.api.wrapper.PacketWrapper;
import org.jetbrains.annotations.ApiStatus;

public class WrapperCommonClientSettings<T extends WrapperCommonClientSettings<T>>
extends PacketWrapper<T> {
    private String locale;
    private int viewDistance;
    private ChatVisibility chatVisibility;
    private boolean chatColors;
    private byte skinMask;
    private HumanoidArm mainHand;
    private boolean textFilteringEnabled;
    private boolean allowServerListings;
    private ParticleStatus particleStatus;
    @ApiStatus.Obsolete
    private byte ignoredDifficulty;

    public WrapperCommonClientSettings(PacketReceiveEvent event) {
        super(event);
    }

    public WrapperCommonClientSettings(PacketTypeCommon packetType, String locale, int viewDistance, ChatVisibility chatVisibility, boolean chatColors, byte skinMask, HumanoidArm mainHand, boolean textFilteringEnabled, boolean allowServerListings, ParticleStatus particleStatus, byte ignoredDifficulty) {
        super(packetType);
        this.locale = locale;
        this.viewDistance = viewDistance;
        this.chatVisibility = chatVisibility;
        this.chatColors = chatColors;
        this.skinMask = skinMask;
        this.mainHand = mainHand;
        this.textFilteringEnabled = textFilteringEnabled;
        this.allowServerListings = allowServerListings;
        this.particleStatus = particleStatus;
        this.ignoredDifficulty = ignoredDifficulty;
    }

    @Override
    public void read() {
        this.locale = this.readString(this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_12) ? 16 : 7);
        this.viewDistance = this.readByte();
        this.chatVisibility = (ChatVisibility)this.readEnum(ChatVisibility.values());
        this.chatColors = this.readBoolean();
        if (this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_7_10)) {
            this.ignoredDifficulty = this.readByte();
            if (this.readBoolean()) {
                this.skinMask = SkinSection.CAPE.getMask();
            }
        } else {
            this.skinMask = (byte)this.readUnsignedByte();
        }
        this.mainHand = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9) ? (HumanoidArm)this.readEnum(HumanoidArm.values()) : HumanoidArm.RIGHT;
        this.textFilteringEnabled = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17) && this.readBoolean();
        this.allowServerListings = this.serverVersion.isOlderThan(ServerVersion.V_1_18) || this.readBoolean();
        this.particleStatus = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_2) ? (ParticleStatus)this.readEnum(ParticleStatus.values()) : ParticleStatus.ALL;
    }

    @Override
    public void write() {
        this.writeString(this.locale, this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_12) ? 16 : 7);
        this.writeByte(this.viewDistance);
        this.writeEnum(this.chatVisibility);
        this.writeBoolean(this.chatColors);
        if (this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_7_10)) {
            this.writeByte(this.ignoredDifficulty);
            this.writeBoolean(SkinSection.CAPE.isSet(this.skinMask));
        } else {
            this.writeByte(this.skinMask);
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9)) {
            this.writeEnum(this.mainHand);
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17)) {
            this.writeBoolean(this.textFilteringEnabled);
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_18)) {
            this.writeBoolean(this.allowServerListings);
        }
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_2)) {
            this.writeEnum(this.particleStatus);
        }
    }

    @Override
    public void copy(T wrapper) {
        this.locale = ((WrapperCommonClientSettings)wrapper).getLocale();
        this.viewDistance = ((WrapperCommonClientSettings)wrapper).getViewDistance();
        this.chatVisibility = ((WrapperCommonClientSettings)wrapper).getChatVisibility();
        this.chatColors = ((WrapperCommonClientSettings)wrapper).isChatColors();
        this.skinMask = ((WrapperCommonClientSettings)wrapper).getSkinMask();
        this.mainHand = ((WrapperCommonClientSettings)wrapper).getMainHand();
        this.textFilteringEnabled = ((WrapperCommonClientSettings)wrapper).isTextFilteringEnabled();
        this.allowServerListings = ((WrapperCommonClientSettings)wrapper).isServerListingAllowed();
        this.particleStatus = ((WrapperCommonClientSettings)wrapper).getParticleStatus();
        this.ignoredDifficulty = ((WrapperCommonClientSettings)wrapper).getIgnoredDifficulty();
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public int getViewDistance() {
        return this.viewDistance;
    }

    public void setViewDistance(int viewDistance) {
        this.viewDistance = viewDistance;
    }

    public ChatVisibility getChatVisibility() {
        return this.chatVisibility;
    }

    public void setChatVisibility(ChatVisibility chatVisibility) {
        this.chatVisibility = chatVisibility;
    }

    public boolean isChatColors() {
        return this.chatColors;
    }

    public void setChatColors(boolean chatColors) {
        this.chatColors = chatColors;
    }

    public byte getSkinMask() {
        return this.skinMask;
    }

    public void setSkinMask(byte skinMask) {
        this.skinMask = skinMask;
    }

    public SkinSection getVisibleSkinSection() {
        return new SkinSection(this.skinMask);
    }

    public void setVisibleSkinSections(SkinSection visibleSkinSection) {
        this.skinMask = visibleSkinSection.getMask();
    }

    public boolean isSkinSectionVisible(SkinSection section) {
        return section.isSet(this.skinMask);
    }

    public void setSkinSectionVisible(SkinSection section, boolean visible) {
        this.skinMask = section.set(this.skinMask, visible);
    }

    public HumanoidArm getMainHand() {
        return this.mainHand;
    }

    public void setMainHand(HumanoidArm mainHand) {
        this.mainHand = mainHand;
    }

    public boolean isTextFilteringEnabled() {
        return this.textFilteringEnabled;
    }

    public void setTextFilteringEnabled(boolean textFilteringEnabled) {
        this.textFilteringEnabled = textFilteringEnabled;
    }

    public boolean isServerListingAllowed() {
        return this.allowServerListings;
    }

    public void setServerListingAllowed(boolean allowServerListings) {
        this.allowServerListings = allowServerListings;
    }

    public ParticleStatus getParticleStatus() {
        return this.particleStatus;
    }

    public void setParticleStatus(ParticleStatus particleStatus) {
        this.particleStatus = particleStatus;
    }

    @ApiStatus.Obsolete
    public byte getIgnoredDifficulty() {
        return this.ignoredDifficulty;
    }

    @ApiStatus.Obsolete
    public void setIgnoredDifficulty(byte ignoredDifficulty) {
        this.ignoredDifficulty = ignoredDifficulty;
    }

    public static enum ChatVisibility {
        FULL,
        SYSTEM,
        HIDDEN;

    }

    public static enum ParticleStatus {
        ALL,
        DECREASED,
        MINIMAL;

    }
}

