/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.packetevents.api.wrapper.play.client;

import NC.noChance.packetevents.api.event.PacketReceiveEvent;
import NC.noChance.packetevents.api.manager.server.ServerVersion;
import NC.noChance.packetevents.api.protocol.item.HashedStack;
import NC.noChance.packetevents.api.protocol.item.ItemStack;
import NC.noChance.packetevents.api.protocol.packettype.PacketType;
import NC.noChance.packetevents.api.wrapper.PacketWrapper;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class WrapperPlayClientClickWindow
extends PacketWrapper<WrapperPlayClientClickWindow> {
    private static final int MAX_SLOT_COUNT = 128;
    private int windowID;
    @Nullable
    private Integer stateID;
    private int slot;
    private int button;
    @Nullable
    private Integer actionNumber;
    private WindowClickType windowClickType;
    @Nullable
    private Map<Integer, ItemStack> slots;
    @Nullable
    private Map<Integer, Optional<HashedStack>> hashedSlots;
    @Nullable
    private ItemStack carriedItemStack;
    @Nullable
    private Optional<HashedStack> carriedHashedStack;

    public WrapperPlayClientClickWindow(PacketReceiveEvent event) {
        super(event);
    }

    @ApiStatus.Obsolete
    public WrapperPlayClientClickWindow(int windowID, Optional<Integer> stateID, int slot, int button, Optional<Integer> actionNumber, WindowClickType windowClickType, Optional<Map<Integer, ItemStack>> slots, ItemStack carriedItemStack) {
        super(PacketType.Play.Client.CLICK_WINDOW);
        this.windowID = windowID;
        this.stateID = stateID.orElse(null);
        this.slot = slot;
        this.button = button;
        this.actionNumber = actionNumber.orElse(null);
        this.windowClickType = windowClickType;
        this.slots = slots.orElse(null);
        this.carriedItemStack = carriedItemStack;
    }

    public WrapperPlayClientClickWindow(int windowID, @Nullable Integer stateID, int slot, int button, WindowClickType windowClickType, @Nullable Map<Integer, Optional<HashedStack>> hashedSlots, @Nullable Optional<HashedStack> carriedHashedStack) {
        super(PacketType.Play.Client.CLICK_WINDOW);
        this.windowID = windowID;
        this.stateID = stateID;
        this.slot = slot;
        this.button = button;
        this.windowClickType = windowClickType;
        this.hashedSlots = hashedSlots;
        this.carriedHashedStack = carriedHashedStack;
    }

    @Override
    public void read() {
        boolean v1_17 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17);
        this.windowID = this.readContainerId();
        this.stateID = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17_1) ? Integer.valueOf(this.readVarInt()) : null;
        this.slot = this.readShort();
        this.button = this.readByte();
        this.actionNumber = v1_17 ? null : Integer.valueOf(this.readShort());
        this.windowClickType = WindowClickType.getById(this.readVarInt());
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_5)) {
            this.hashedSlots = this.readMap(ew -> Math.toIntExact(ew.readShort()), HashedStack::read, 128);
            this.carriedHashedStack = HashedStack.read(this);
        } else {
            if (v1_17) {
                this.slots = this.readMap(packetWrapper -> Math.toIntExact(packetWrapper.readShort()), PacketWrapper::readItemStack);
            }
            this.carriedItemStack = this.readItemStack();
        }
    }

    @Override
    public void copy(WrapperPlayClientClickWindow wrapper) {
        this.windowID = wrapper.windowID;
        this.stateID = wrapper.stateID;
        this.slot = wrapper.slot;
        this.button = wrapper.button;
        this.actionNumber = wrapper.actionNumber;
        this.windowClickType = wrapper.windowClickType;
        this.slots = wrapper.slots;
        this.hashedSlots = wrapper.hashedSlots;
        this.carriedItemStack = wrapper.carriedItemStack;
        this.carriedHashedStack = wrapper.carriedHashedStack;
    }

    @Override
    public void write() {
        boolean v1_17 = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17);
        this.writeContainerId(this.windowID);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_17_1)) {
            this.writeVarInt(this.stateID != null ? this.stateID : -1);
        }
        this.writeShort(this.slot);
        this.writeByte(this.button);
        if (!v1_17) {
            this.writeShort(this.actionNumber != null ? this.actionNumber : -1);
        }
        this.writeVarInt(this.windowClickType.ordinal());
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_5)) {
            this.writeMap(this.hashedSlots != null ? this.hashedSlots : Collections.emptyMap(), PacketWrapper::writeShort, HashedStack::write);
            HashedStack.write(this, this.carriedHashedStack);
        } else {
            if (v1_17) {
                this.writeMap(this.slots != null ? this.slots : Collections.emptyMap(), PacketWrapper::writeShort, PacketWrapper::writeItemStack);
            }
            this.writeItemStack(this.carriedItemStack);
        }
    }

    public int getWindowId() {
        return this.windowID;
    }

    public void setWindowId(int windowID) {
        this.windowID = windowID;
    }

    public Optional<Integer> getStateId() {
        return Optional.ofNullable(this.stateID);
    }

    public void setStateID(Optional<Integer> stateID) {
        this.stateID = stateID.orElse(null);
    }

    public int getSlot() {
        return this.slot;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    public int getButton() {
        return this.button;
    }

    public void setButton(int button) {
        this.button = button;
    }

    @ApiStatus.Obsolete
    public Optional<Integer> getActionNumber() {
        return Optional.ofNullable(this.actionNumber);
    }

    @ApiStatus.Obsolete
    public void setActionNumber(int button) {
        this.actionNumber = button;
    }

    public WindowClickType getWindowClickType() {
        return this.windowClickType;
    }

    public void setWindowClickType(WindowClickType windowClickType) {
        this.windowClickType = windowClickType;
    }

    public Optional<Map<Integer, ItemStack>> getSlots() {
        return Optional.ofNullable(this.slots);
    }

    public void setSlots(Optional<Map<Integer, ItemStack>> slots) {
        this.slots = slots.orElse(null);
    }

    public Map<Integer, Optional<HashedStack>> getHashedSlots() {
        return this.hashedSlots;
    }

    public void setHashedSlots(Map<Integer, Optional<HashedStack>> hashedSlots) {
        this.hashedSlots = hashedSlots;
    }

    public ItemStack getCarriedItemStack() {
        if (this.carriedItemStack == null && this.carriedHashedStack != null) {
            return this.carriedHashedStack.map(HashedStack::asItemStack).orElse(ItemStack.EMPTY);
        }
        return this.carriedItemStack;
    }

    public void setCarriedItemStack(ItemStack carriedItemStack) {
        this.carriedItemStack = carriedItemStack;
        this.carriedHashedStack = HashedStack.fromItemStack(carriedItemStack);
    }

    public Optional<HashedStack> getCarriedHashedStack() {
        return this.carriedHashedStack;
    }

    public void setCarriedHashedStack(Optional<HashedStack> carriedHashedStack) {
        this.carriedHashedStack = carriedHashedStack;
    }

    public static enum WindowClickType {
        PICKUP,
        QUICK_MOVE,
        SWAP,
        CLONE,
        THROW,
        QUICK_CRAFT,
        PICKUP_ALL,
        UNKNOWN;

        public static final WindowClickType[] VALUES;

        public static WindowClickType getById(int id) {
            if (id < 0 || id >= VALUES.length - 1) {
                return UNKNOWN;
            }
            return VALUES[id];
        }

        static {
            VALUES = WindowClickType.values();
        }
    }
}

