/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.packetevents.api.wrapper.play.server;

import NC.noChance.packetevents.api.event.PacketSendEvent;
import NC.noChance.packetevents.api.manager.server.ServerVersion;
import NC.noChance.packetevents.api.protocol.packettype.PacketType;
import NC.noChance.packetevents.api.wrapper.PacketWrapper;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class WrapperPlayServerEndCombatEvent
extends PacketWrapper<WrapperPlayServerEndCombatEvent> {
    private int duration;
    private Integer entityId;

    public WrapperPlayServerEndCombatEvent(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerEndCombatEvent(int duration, @Nullable Integer entityId) {
        super(PacketType.Play.Server.END_COMBAT_EVENT);
        this.duration = duration;
        this.entityId = entityId;
    }

    @Override
    public void read() {
        this.duration = this.readVarInt();
        if (this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_19_4)) {
            this.entityId = this.readInt();
        }
    }

    @Override
    public void write() {
        this.writeVarInt(this.duration);
        if (this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_19_4)) {
            int id = this.entityId != null ? this.entityId : 0;
            this.writeInt(id);
        }
    }

    @Override
    public void copy(WrapperPlayServerEndCombatEvent wrapper) {
        this.duration = wrapper.duration;
        this.entityId = wrapper.entityId;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public Optional<Integer> getEntityId() {
        return Optional.ofNullable(this.entityId);
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }
}

