/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.packetevents.impl.injector.handlers;

import NC.noChance.packetevents.api.PacketEvents;
import NC.noChance.packetevents.api.exception.PacketProcessException;
import NC.noChance.packetevents.api.netty.buffer.ByteBufHelper;
import NC.noChance.packetevents.api.protocol.ConnectionState;
import NC.noChance.packetevents.api.protocol.player.User;
import NC.noChance.packetevents.api.util.ExceptionUtil;
import NC.noChance.packetevents.api.util.PacketEventsImplHelper;
import NC.noChance.packetevents.api.wrapper.play.server.WrapperPlayServerDisconnect;
import NC.noChance.packetevents.impl.injector.connection.ServerConnectionInitializer;
import NC.noChance.packetevents.impl.injector.handlers.PacketEventsEncoder;
import NC.noChance.packetevents.impl.util.SpigotReflectionUtil;
import NC.noChance.packetevents.impl.util.folia.FoliaScheduler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PacketEventsDecoder
extends MessageToMessageDecoder<ByteBuf> {
    public User user;
    public Player player;
    public boolean hasBeenRelocated;

    public PacketEventsDecoder(User user) {
        this.user = user;
    }

    public PacketEventsDecoder(PacketEventsDecoder decoder) {
        this.user = decoder.user;
        this.player = decoder.player;
        this.hasBeenRelocated = decoder.hasBeenRelocated;
    }

    public void read(ChannelHandlerContext ctx, ByteBuf input, List<Object> out) throws Exception {
        try {
            PacketEventsImplHelper.handleServerBoundPacket(ctx.channel(), this.user, this.player, input, true);
            out.add(ByteBufHelper.retain(input));
        }
        catch (Throwable e) {
            if (ExceptionUtil.isException(e, PacketProcessException.class)) {
                throw e;
            }
            throw new PacketProcessException(e);
        }
    }

    public void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        if (buffer.isReadable()) {
            this.read(ctx, buffer, out);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        boolean debug;
        if (!ExceptionUtil.isException(cause, PacketProcessException.class)) {
            super.exceptionCaught(ctx, cause);
            return;
        }
        boolean bl = debug = PacketEvents.getAPI().getSettings().isDebugEnabled() || SpigotReflectionUtil.isMinecraftServerInstanceDebugging();
        if (debug || this.user != null && this.user.getDecoderState() != ConnectionState.HANDSHAKING) {
            if (PacketEvents.getAPI().getSettings().isFullStackTraceEnabled()) {
                String state = this.user != null ? this.user.getDecoderState().name() : "null";
                String clientVersion = this.user != null ? this.user.getClientVersion().getReleaseName() : "null";
                PacketEvents.getAPI().getLogger().log(Level.WARNING, cause, () -> "An error occurred while processing a packet from " + this.user.getProfile().getName() + " (state: " + state + ", clientVersion: " + clientVersion + ", serverVersion: " + PacketEvents.getAPI().getServerManager().getVersion().getReleaseName() + ")");
            } else {
                PacketEvents.getAPI().getLogManager().warn(cause.getMessage());
            }
        }
        if (PacketEvents.getAPI().getSettings().isKickOnPacketExceptionEnabled()) {
            try {
                if (this.user != null) {
                    this.user.sendPacket(new WrapperPlayServerDisconnect(Component.text("Invalid packet")));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ctx.channel().close();
            if (this.player != null) {
                FoliaScheduler.getEntityScheduler().runDelayed((Entity)this.player, (Plugin)PacketEvents.getAPI().getPlugin(), o -> this.player.kickPlayer("Invalid packet"), null, 1L);
            }
            if (this.user != null && this.user.getProfile().getName() != null) {
                PacketEvents.getAPI().getLogManager().warn("Disconnected " + this.user.getProfile().getName() + " due to an invalid packet!");
            }
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object event) throws Exception {
        if (PacketEventsEncoder.COMPRESSION_ENABLED_EVENT == null || event != PacketEventsEncoder.COMPRESSION_ENABLED_EVENT) {
            super.userEventTriggered(ctx, event);
            return;
        }
        ServerConnectionInitializer.relocateHandlers(ctx.channel(), this, this.user);
        super.userEventTriggered(ctx, event);
    }
}

