/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.packets;

import NC.noChance.core.ACConfig;
import NC.noChance.core.ViolationType;
import NC.noChance.packetevents.api.event.PacketReceiveEvent;
import NC.noChance.packetevents.api.protocol.packettype.PacketType;
import NC.noChance.packetevents.api.wrapper.PacketWrapper;
import NC.noChance.packetevents.api.wrapper.play.client.WrapperPlayClientPlayerBlockPlacement;
import NC.noChance.packetevents.api.wrapper.play.client.WrapperPlayClientPlayerDigging;
import NC.noChance.packets.PacketAnalyzer;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class BlockPacketAnalyzer {
    private final ACConfig config;
    private static final int MAX_BLOCKS_PER_SECOND = 20;
    private static final double MAX_BLOCK_REACH = 6.0;

    public BlockPacketAnalyzer(ACConfig config) {
        this.config = config;
    }

    public void analyzeBlockPacket(PacketReceiveEvent event, Player player, PacketAnalyzer.PacketData data) {
        data.recordPacket(PacketAnalyzer.PacketCategory.BLOCK);
        try {
            double distance;
            Location blockLoc;
            PacketWrapper wrapper2;
            if (event.getPacketType() == PacketType.Play.Client.PLAYER_BLOCK_PLACEMENT) {
                try {
                    wrapper2 = new WrapperPlayClientPlayerBlockPlacement(event);
                    data.setMetadata("lastPlaceX", ((WrapperPlayClientPlayerBlockPlacement)wrapper2).getBlockPosition().getX());
                    data.setMetadata("lastPlaceY", ((WrapperPlayClientPlayerBlockPlacement)wrapper2).getBlockPosition().getY());
                    data.setMetadata("lastPlaceZ", ((WrapperPlayClientPlayerBlockPlacement)wrapper2).getBlockPosition().getZ());
                    data.setMetadata("lastPlaceTime", System.currentTimeMillis());
                    blockLoc = new Location(player.getWorld(), (double)((WrapperPlayClientPlayerBlockPlacement)wrapper2).getBlockPosition().getX(), (double)((WrapperPlayClientPlayerBlockPlacement)wrapper2).getBlockPosition().getY(), (double)((WrapperPlayClientPlayerBlockPlacement)wrapper2).getBlockPosition().getZ());
                    distance = player.getLocation().distance(blockLoc);
                    data.setMetadata("lastPlaceDistance", distance);
                }
                catch (Exception wrapper2) {
                    // empty catch block
                }
            }
            if (event.getPacketType() == PacketType.Play.Client.PLAYER_DIGGING) {
                try {
                    wrapper2 = new WrapperPlayClientPlayerDigging(event);
                    data.setMetadata("lastDigX", ((WrapperPlayClientPlayerDigging)wrapper2).getBlockPosition().getX());
                    data.setMetadata("lastDigY", ((WrapperPlayClientPlayerDigging)wrapper2).getBlockPosition().getY());
                    data.setMetadata("lastDigZ", ((WrapperPlayClientPlayerDigging)wrapper2).getBlockPosition().getZ());
                    data.setMetadata("lastDigTime", System.currentTimeMillis());
                    blockLoc = new Location(player.getWorld(), (double)((WrapperPlayClientPlayerDigging)wrapper2).getBlockPosition().getX(), (double)((WrapperPlayClientPlayerDigging)wrapper2).getBlockPosition().getY(), (double)((WrapperPlayClientPlayerDigging)wrapper2).getBlockPosition().getZ());
                    distance = player.getLocation().distance(blockLoc);
                    data.setMetadata("lastDigDistance", distance);
                }
                catch (Exception wrapper3) {}
            }
        }
        catch (Exception e) {
            return;
        }
    }

    public PacketAnalyzer.PacketViolationResult checkBlockViolation(Player player, PacketAnalyzer.PacketData data, ViolationType type) {
        Deque<Long> packetTimes = data.getBlockPacketTimes();
        if (packetTimes.size() < 3) {
            return new PacketAnalyzer.PacketViolationResult(false, 0.0, "Insufficient data");
        }
        switch (type) {
            case SCAFFOLD: 
            case FASTPLACE: {
                return this.checkFastPlacePackets(player, data);
            }
            case FASTBREAK: 
            case NUKER: {
                return this.checkFastBreakPackets(player, data);
            }
        }
        return new PacketAnalyzer.PacketViolationResult(false, 0.0, "Unknown type");
    }

    private PacketAnalyzer.PacketViolationResult checkFastPlacePackets(Player player, PacketAnalyzer.PacketData data) {
        double variance;
        double distance;
        Deque<Long> times = data.getBlockPacketTimes();
        long now = System.currentTimeMillis();
        long recentBlocks = times.stream().filter(t -> now - t < 1000L).count();
        if (recentBlocks > (long)this.config.getInventoryMaxClicksPerSecond()) {
            double severity = Math.min(1.0, (double)recentBlocks / (double)this.config.getInventoryMaxClicksPerSecond());
            return new PacketAnalyzer.PacketViolationResult(true, severity, "Packet place rate: " + recentBlocks + "/sec");
        }
        Object distObj = data.getMetadata("lastPlaceDistance");
        if (distObj != null && (distance = ((Double)distObj).doubleValue()) > 6.0) {
            double severity = Math.min(1.0, (distance - 6.0) / 6.0);
            return new PacketAnalyzer.PacketViolationResult(true, severity, "Packet place reach: " + String.format("%.2f", distance));
        }
        ArrayList<Long> intervals = new ArrayList<Long>();
        Long prev = null;
        for (Long time : times) {
            if (now - time > 2000L) continue;
            if (prev != null) {
                intervals.add(time - prev);
            }
            prev = time;
        }
        if (intervals.size() >= 5 && (variance = this.calculateVariance(intervals)) < 10.0) {
            return new PacketAnalyzer.PacketViolationResult(true, 0.85, "Perfect place timing: " + String.format("%.2f", variance));
        }
        return new PacketAnalyzer.PacketViolationResult(false, 0.0, "Clean");
    }

    private PacketAnalyzer.PacketViolationResult checkFastBreakPackets(Player player, PacketAnalyzer.PacketData data) {
        double distance;
        Object distObj;
        PotionEffect haste;
        Deque<Long> times = data.getBlockPacketTimes();
        long now = System.currentTimeMillis();
        ItemStack tool = player.getInventory().getItemInMainHand();
        String toolType = tool != null && tool.getType() != Material.AIR ? tool.getType().name() : "HAND";
        int efficiencyLevel = 0;
        if (tool != null && tool.getType() != Material.AIR) {
            Enchantment effEnch = Enchantment.getByName((String)"EFFICIENCY");
            if (effEnch == null) {
                effEnch = Enchantment.getByName((String)"DIG_SPEED");
            }
            if (effEnch != null) {
                efficiencyLevel = tool.getEnchantmentLevel(effEnch);
            }
        }
        boolean isShovel = toolType.contains("SHOVEL") || toolType.contains("SPADE");
        boolean isAxe = toolType.contains("AXE") && !toolType.contains("PICKAXE");
        boolean isPickaxe = toolType.contains("PICKAXE");
        boolean isGoldenTool = toolType.contains("GOLDEN");
        boolean hasHighEfficiency = efficiencyLevel >= 4;
        PotionEffectType hasteType = PotionEffectType.getByName((String)"HASTE");
        if (hasteType == null) {
            hasteType = PotionEffectType.getByName((String)"FAST_DIGGING");
        }
        int hasteLevel = 0;
        if (hasteType != null && (haste = player.getPotionEffect(hasteType)) != null) {
            hasteLevel = haste.getAmplifier() + 1;
        }
        long recentBlocks = times.stream().filter(t -> now - t < 1000L).count();
        int maxBlocksPerSecond = 20;
        if ((isShovel || isAxe) && hasHighEfficiency) {
            maxBlocksPerSecond = 35;
        } else if (isGoldenTool && hasHighEfficiency) {
            maxBlocksPerSecond = 40;
        } else if (hasHighEfficiency && hasteLevel >= 2) {
            maxBlocksPerSecond = 30;
        } else if (hasHighEfficiency || hasteLevel >= 1) {
            maxBlocksPerSecond = 25;
        }
        if (recentBlocks > (long)maxBlocksPerSecond) {
            double severity = Math.min(1.0, (double)recentBlocks / (double)maxBlocksPerSecond);
            return new PacketAnalyzer.PacketViolationResult(true, severity, "Packet break rate: " + recentBlocks + "/sec");
        }
        ArrayList<Long> intervals = new ArrayList<Long>();
        Long prev = null;
        for (Long time : times) {
            if (now - time > 1500L) continue;
            if (prev != null) {
                intervals.add(time - prev);
            }
            prev = time;
        }
        if (intervals.size() >= 4) {
            int meanThreshold;
            int varianceThreshold;
            int requiredFast;
            int requiredVeryFast;
            int fastThreshold;
            int veryFastThreshold;
            if (isShovel && efficiencyLevel >= 5) {
                veryFastThreshold = 20;
                fastThreshold = 40;
                requiredVeryFast = 10;
                requiredFast = 15;
            } else if (isAxe && efficiencyLevel >= 5) {
                veryFastThreshold = 30;
                fastThreshold = 50;
                requiredVeryFast = 8;
                requiredFast = 12;
            } else if (isGoldenTool && efficiencyLevel >= 4) {
                veryFastThreshold = 25;
                fastThreshold = 45;
                requiredVeryFast = 9;
                requiredFast = 13;
            } else if (hasHighEfficiency && hasteLevel >= 2) {
                veryFastThreshold = 30;
                fastThreshold = 55;
                requiredVeryFast = 7;
                requiredFast = 10;
            } else if (hasHighEfficiency || hasteLevel >= 1) {
                veryFastThreshold = 35;
                fastThreshold = 70;
                requiredVeryFast = 6;
                requiredFast = 8;
            } else {
                veryFastThreshold = 50;
                fastThreshold = 100;
                requiredVeryFast = 3;
                requiredFast = 4;
            }
            long veryFastBreaks = intervals.stream().filter(i -> i < (long)veryFastThreshold).count();
            if (veryFastBreaks >= (long)requiredVeryFast) {
                String details = String.format("Packet: %d breaks <%dms (tool:%s eff:%d haste:%d req:%d)", veryFastBreaks, veryFastThreshold, toolType, efficiencyLevel, hasteLevel, requiredVeryFast);
                return new PacketAnalyzer.PacketViolationResult(true, 0.92, details);
            }
            long fastBreaks = intervals.stream().filter(i -> i < (long)fastThreshold).count();
            if (fastBreaks >= (long)requiredFast) {
                String details = String.format("Packet: %d breaks <%dms (tool:%s eff:%d haste:%d req:%d)", fastBreaks, fastThreshold, toolType, efficiencyLevel, hasteLevel, requiredFast);
                return new PacketAnalyzer.PacketViolationResult(true, 0.82, details);
            }
            double variance = this.calculateVariance(intervals);
            double mean = intervals.stream().mapToLong(Long::longValue).average().orElse(0.0);
            if (isShovel && efficiencyLevel >= 5) {
                varianceThreshold = 1;
                meanThreshold = 40;
            } else if (isAxe && efficiencyLevel >= 5) {
                varianceThreshold = 3;
                meanThreshold = 50;
            } else if ((isShovel || isAxe) && hasHighEfficiency) {
                varianceThreshold = 5;
                meanThreshold = 60;
            } else if (isGoldenTool) {
                varianceThreshold = 8;
                meanThreshold = 80;
            } else {
                varianceThreshold = 15;
                meanThreshold = 150;
            }
            if (variance < (double)varianceThreshold && mean < (double)meanThreshold) {
                return new PacketAnalyzer.PacketViolationResult(true, 0.88, "Packet: Perfect timing var=" + String.format("%.1f", variance) + " mean=" + String.format("%.1f", mean));
            }
        }
        if ((distObj = data.getMetadata("lastDigDistance")) != null && (distance = ((Double)distObj).doubleValue()) > 6.0) {
            double severity = Math.min(1.0, (distance - 6.0) / 6.0);
            return new PacketAnalyzer.PacketViolationResult(true, severity, "Packet break reach: " + String.format("%.2f", distance));
        }
        return new PacketAnalyzer.PacketViolationResult(false, 0.0, "Clean");
    }

    private double calculateVariance(List<Long> values) {
        if (values.isEmpty()) {
            return 0.0;
        }
        double mean = values.stream().mapToLong(Long::longValue).average().orElse(0.0);
        double variance = 0.0;
        for (Long value : values) {
            variance += Math.pow((double)value.longValue() - mean, 2.0);
        }
        return variance / (double)values.size();
    }
}

