/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.packets;

import NC.noChance.core.ACConfig;
import NC.noChance.core.ViolationType;
import NC.noChance.packetevents.api.event.PacketReceiveEvent;
import NC.noChance.packetevents.api.protocol.packettype.PacketType;
import NC.noChance.packetevents.api.wrapper.play.client.WrapperPlayClientInteractEntity;
import NC.noChance.packets.PacketAnalyzer;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class CombatPacketAnalyzer {
    private final ACConfig config;
    private final Plugin plugin;
    private static final int MAX_CPS_PACKETS = 30;
    private static final long AUTOCLICKER_VARIANCE_THRESHOLD = 5L;

    public CombatPacketAnalyzer(ACConfig config, Plugin plugin) {
        this.config = config;
        this.plugin = plugin;
    }

    public void analyzeCombatPacket(PacketReceiveEvent event, Player player, PacketAnalyzer.PacketData data) {
        data.recordPacket(PacketAnalyzer.PacketCategory.COMBAT);
        if (event.getPacketType() == PacketType.Play.Client.INTERACT_ENTITY) {
            try {
                WrapperPlayClientInteractEntity wrapper = new WrapperPlayClientInteractEntity(event);
                data.setMetadata("lastAttackTime", System.currentTimeMillis());
                data.setMetadata("lastAttackedEntity", wrapper.getEntityId());
                if (wrapper.getAction() == WrapperPlayClientInteractEntity.InteractAction.ATTACK) {
                    int entityId = wrapper.getEntityId();
                    Bukkit.getScheduler().runTask(this.plugin, () -> {
                        Entity target = null;
                        for (Entity e : player.getWorld().getEntities()) {
                            if (e.getEntityId() != entityId) continue;
                            target = e;
                            break;
                        }
                        if (target != null) {
                            double distance = player.getLocation().distance(target.getLocation());
                            data.setMetadata("lastAttackDistance", distance);
                            Vector toTarget = target.getLocation().toVector().subtract(player.getLocation().toVector());
                            Vector lookDir = player.getLocation().getDirection();
                            double angle = Math.toDegrees(Math.acos(toTarget.normalize().dot(lookDir.normalize())));
                            data.setMetadata("lastAttackAngle", angle);
                        }
                    });
                }
            }
            catch (Exception e) {
                return;
            }
        }
        if (event.getPacketType() == PacketType.Play.Client.ANIMATION) {
            data.setMetadata("lastSwingTime", System.currentTimeMillis());
        }
    }

    public PacketAnalyzer.PacketViolationResult checkCombatViolation(Player player, PacketAnalyzer.PacketData data, ViolationType type) {
        Deque<Long> packetTimes = data.getCombatPacketTimes();
        if (packetTimes.size() < 5) {
            return new PacketAnalyzer.PacketViolationResult(false, 0.0, "Insufficient data");
        }
        switch (type) {
            case KILLAURA: 
            case KILLAURA_ANGLE: 
            case KILLAURA_ROTATION: 
            case KILLAURA_PATTERN: {
                return this.checkKillAuraPackets(player, data);
            }
            case AUTOCLICKER: {
                return this.checkAutoClickerPackets(player, data);
            }
            case REACH: {
                return this.checkReachPackets(player, data);
            }
        }
        return new PacketAnalyzer.PacketViolationResult(false, 0.0, "Unknown type");
    }

    private PacketAnalyzer.PacketViolationResult checkKillAuraPackets(Player player, PacketAnalyzer.PacketData data) {
        double variance;
        double distance;
        double angle;
        Object angleObj = data.getMetadata("lastAttackAngle");
        if (angleObj != null && (angle = ((Double)angleObj).doubleValue()) > this.config.getKillAuraMaxAngle()) {
            double severity = Math.min(1.0, angle / this.config.getKillAuraMaxAngle());
            return new PacketAnalyzer.PacketViolationResult(true, severity, "Packet attack angle: " + String.format("%.1f", angle));
        }
        Object distObj = data.getMetadata("lastAttackDistance");
        if (distObj != null && (distance = ((Double)distObj).doubleValue()) > this.config.getKillAuraMaxReach()) {
            double severity = Math.min(1.0, (distance - this.config.getKillAuraMaxReach()) / this.config.getKillAuraMaxReach());
            return new PacketAnalyzer.PacketViolationResult(true, severity, "Packet reach: " + String.format("%.2f", distance));
        }
        Deque<Long> times = data.getCombatPacketTimes();
        long now = System.currentTimeMillis();
        ArrayList<Long> recentIntervals = new ArrayList<Long>();
        Long prev = null;
        for (Long time : times) {
            if (now - time > 2000L) continue;
            if (prev != null) {
                recentIntervals.add(time - prev);
            }
            prev = time;
        }
        if (recentIntervals.size() >= 7 && (variance = this.calculateVariance(recentIntervals)) < this.config.getKillAuraPacketVarianceThreshold()) {
            double severity = 0.9;
            if (variance < this.config.getKillAuraPacketVarianceStrict()) {
                severity = 0.94;
            }
            return new PacketAnalyzer.PacketViolationResult(true, severity, "Perfect timing variance: " + String.format("%.2f", variance));
        }
        long recentAttacks = times.stream().filter(t -> now - t < 1000L).count();
        if (recentAttacks > (long)this.config.getKillAuraPacketAttackRateLimit()) {
            double severity = Math.min(0.93, 0.73 + (double)(recentAttacks - (long)this.config.getKillAuraPacketAttackRateLimit()) / 32.0);
            return new PacketAnalyzer.PacketViolationResult(true, severity, "Packet attack rate: " + recentAttacks + "/s");
        }
        return new PacketAnalyzer.PacketViolationResult(false, 0.0, "Clean");
    }

    private PacketAnalyzer.PacketViolationResult checkAutoClickerPackets(Player player, PacketAnalyzer.PacketData data) {
        double variance;
        Deque<Long> times = data.getCombatPacketTimes();
        long now = System.currentTimeMillis();
        long recentClicks = times.stream().filter(t -> now - t < 1000L).count();
        if ((double)recentClicks > (double)this.config.getAutoClickerMaxCPS() * 1.15) {
            double severity = Math.min(1.0, (double)recentClicks / ((double)this.config.getAutoClickerMaxCPS() * 1.1));
            return new PacketAnalyzer.PacketViolationResult(true, severity, "Packet CPS: " + recentClicks);
        }
        ArrayList<Long> intervals = new ArrayList<Long>();
        Long prev = null;
        for (Long time : times) {
            if (now - time > 1000L) continue;
            if (prev != null) {
                intervals.add(time - prev);
            }
            prev = time;
        }
        if (intervals.size() >= 10 && (variance = this.calculateVariance(intervals)) < 5.0) {
            return new PacketAnalyzer.PacketViolationResult(true, 0.95, "Perfect click intervals: " + String.format("%.2f", variance));
        }
        return new PacketAnalyzer.PacketViolationResult(false, 0.0, "Clean");
    }

    private PacketAnalyzer.PacketViolationResult checkReachPackets(Player player, PacketAnalyzer.PacketData data) {
        double maxReach;
        Object distObj = data.getMetadata("lastAttackDistance");
        if (distObj == null) {
            return new PacketAnalyzer.PacketViolationResult(false, 0.0, "No distance data");
        }
        double distance = (Double)distObj;
        if (distance > (maxReach = this.config.getReachMaxEntityReach())) {
            double severity = Math.min(1.0, (distance - maxReach) / maxReach);
            return new PacketAnalyzer.PacketViolationResult(true, severity, "Packet reach: " + String.format("%.2f", distance));
        }
        return new PacketAnalyzer.PacketViolationResult(false, 0.0, "Clean");
    }

    private double calculateVariance(List<Long> values) {
        if (values.isEmpty()) {
            return 0.0;
        }
        double mean = values.stream().mapToLong(Long::longValue).average().orElse(0.0);
        double variance = 0.0;
        for (Long value : values) {
            variance += Math.pow((double)value.longValue() - mean, 2.0);
        }
        return variance / (double)values.size();
    }
}

