/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.packets;

import NC.noChance.core.ACConfig;
import NC.noChance.core.ViolationType;
import NC.noChance.packetevents.api.event.PacketReceiveEvent;
import NC.noChance.packetevents.api.protocol.packettype.PacketType;
import NC.noChance.packetevents.api.wrapper.play.client.WrapperPlayClientPlayerPosition;
import NC.noChance.packetevents.api.wrapper.play.client.WrapperPlayClientPlayerPositionAndRotation;
import NC.noChance.packets.PacketAnalyzer;
import java.util.Deque;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;

public class MovementPacketAnalyzer {
    private final ACConfig config;
    private static final double GRAVITY = 0.08;
    private static final double MAX_LEGIT_SPEED = 0.6;
    private static final int PACKET_RATE_THRESHOLD = 25;

    public MovementPacketAnalyzer(ACConfig config) {
        this.config = config;
    }

    public void analyzeMovementPacket(PacketReceiveEvent event, Player player, PacketAnalyzer.PacketData data) {
        data.recordPacket(PacketAnalyzer.PacketCategory.MOVEMENT);
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        boolean hasPosition = false;
        try {
            if (event.getPacketType() == PacketType.Play.Client.PLAYER_POSITION) {
                wrapper = new WrapperPlayClientPlayerPosition(event);
                x = wrapper.getLocation().getX();
                y = wrapper.getLocation().getY();
                z = wrapper.getLocation().getZ();
                hasPosition = true;
            } else if (event.getPacketType() == PacketType.Play.Client.PLAYER_POSITION_AND_ROTATION) {
                wrapper = new WrapperPlayClientPlayerPositionAndRotation(event);
                x = wrapper.getLocation().getX();
                y = wrapper.getLocation().getY();
                z = wrapper.getLocation().getZ();
                hasPosition = true;
            }
        }
        catch (Exception e) {
            return;
        }
        if (hasPosition) {
            data.setMetadata("lastPacketX", x);
            data.setMetadata("lastPacketY", y);
            data.setMetadata("lastPacketZ", z);
            data.setMetadata("lastPacketTime", System.currentTimeMillis());
            Object prevX = data.getMetadata("prevPacketX");
            Object prevY = data.getMetadata("prevPacketY");
            Object prevZ = data.getMetadata("prevPacketZ");
            if (prevX != null && prevY != null && prevZ != null) {
                double dx = x - (Double)prevX;
                double dy = y - (Double)prevY;
                double dz = z - (Double)prevZ;
                double horizontalDist = Math.sqrt(dx * dx + dz * dz);
                data.setMetadata("lastHorizontalSpeed", horizontalDist);
                data.setMetadata("lastVerticalSpeed", dy);
            }
            data.setMetadata("prevPacketX", x);
            data.setMetadata("prevPacketY", y);
            data.setMetadata("prevPacketZ", z);
        }
    }

    public PacketAnalyzer.PacketViolationResult checkMovementViolation(Player player, PacketAnalyzer.PacketData data, ViolationType type) {
        Deque<Long> packetTimes = data.getMovementPacketTimes();
        if (packetTimes.size() < 10) {
            return new PacketAnalyzer.PacketViolationResult(false, 0.0, "Insufficient data");
        }
        if (type == ViolationType.SPEED) {
            return this.checkSpeedPackets(player, data);
        }
        if (type == ViolationType.FLY) {
            return this.checkFlyPackets(player, data);
        }
        if (type == ViolationType.NOCLIP) {
            return this.checkNoClipPackets(player, data);
        }
        return new PacketAnalyzer.PacketViolationResult(false, 0.0, "Unknown type");
    }

    private PacketAnalyzer.PacketViolationResult checkSpeedPackets(Player player, PacketAnalyzer.PacketData data) {
        Object speedObj = data.getMetadata("lastHorizontalSpeed");
        if (speedObj == null) {
            return new PacketAnalyzer.PacketViolationResult(false, 0.0, "No speed data");
        }
        double speed = (Double)speedObj;
        double maxSpeed = this.config.getMaxSpeed() * this.config.getSprintMultiplier();
        if (player.hasPotionEffect(PotionEffectType.SPEED)) {
            int level = player.getPotionEffect(PotionEffectType.SPEED).getAmplifier() + 1;
            maxSpeed *= this.config.getSpeedPotionMultiplier(level);
        }
        if (player.isGliding() || player.isRiptiding() || player.getVehicle() != null) {
            return new PacketAnalyzer.PacketViolationResult(false, 0.0, "Legitimate movement");
        }
        if (player.hasPotionEffect(PotionEffectType.DOLPHINS_GRACE)) {
            maxSpeed *= 1.5;
        }
        if (speed > maxSpeed * 1.8) {
            double severity = Math.min(1.0, (speed - maxSpeed * 1.3) / maxSpeed);
            return new PacketAnalyzer.PacketViolationResult(true, severity, "Packet speed: " + String.format("%.3f", speed));
        }
        Deque<Long> times = data.getMovementPacketTimes();
        long now = System.currentTimeMillis();
        long count = times.stream().filter(t -> now - t < 1000L).count();
        if ((double)count > 30.0) {
            return new PacketAnalyzer.PacketViolationResult(true, 0.75, "Packet flood: " + count + " packets/sec");
        }
        return new PacketAnalyzer.PacketViolationResult(false, 0.0, "Clean");
    }

    private PacketAnalyzer.PacketViolationResult checkFlyPackets(Player player, PacketAnalyzer.PacketData data) {
        double prev;
        Object verticalSpeedObj = data.getMetadata("lastVerticalSpeed");
        if (verticalSpeedObj == null) {
            return new PacketAnalyzer.PacketViolationResult(false, 0.0, "No vertical data");
        }
        double vSpeed = (Double)verticalSpeedObj;
        if (player.isFlying() || player.isGliding() || player.getAllowFlight()) {
            return new PacketAnalyzer.PacketViolationResult(false, 0.0, "Allowed flight");
        }
        if (Math.abs(vSpeed) > this.config.getMaxFlyVelocityY() && !player.isOnGround() && vSpeed > 0.0) {
            double severity = Math.min(1.0, vSpeed / this.config.getMaxFlyVelocityY());
            return new PacketAnalyzer.PacketViolationResult(true, severity, "Upward velocity: " + String.format("%.3f", vSpeed));
        }
        Object prevVSpeed = data.getMetadata("prevVerticalSpeed");
        if (prevVSpeed != null && (prev = ((Double)prevVSpeed).doubleValue()) < -0.5 && vSpeed > 0.3 && !player.isOnGround()) {
            return new PacketAnalyzer.PacketViolationResult(true, 0.85, "Impossible velocity change");
        }
        data.setMetadata("prevVerticalSpeed", vSpeed);
        return new PacketAnalyzer.PacketViolationResult(false, 0.0, "Clean");
    }

    private PacketAnalyzer.PacketViolationResult checkNoClipPackets(Player player, PacketAnalyzer.PacketData data) {
        Object xObj = data.getMetadata("lastPacketX");
        Object yObj = data.getMetadata("lastPacketY");
        Object zObj = data.getMetadata("lastPacketZ");
        if (xObj == null || yObj == null || zObj == null) {
            return new PacketAnalyzer.PacketViolationResult(false, 0.0, "No position data");
        }
        try {
            double x = (Double)xObj;
            double y = (Double)yObj;
            double z = (Double)zObj;
            Location packetLoc = new Location(player.getWorld(), x, y, z);
            Location actualLoc = player.getLocation();
            double distance = packetLoc.distance(actualLoc);
            if (distance > 5.0) {
                double severity = Math.min(1.0, distance / 10.0);
                return new PacketAnalyzer.PacketViolationResult(true, severity, "Position desync: " + String.format("%.2f", distance));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new PacketAnalyzer.PacketViolationResult(false, 0.0, "Clean");
    }
}

