/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.packets;

import NC.noChance.core.ACConfig;
import NC.noChance.core.ViolationType;
import NC.noChance.detection.player.BadPacketsCheck;
import NC.noChance.detection.player.BlinkCheck;
import NC.noChance.packetevents.api.PacketEvents;
import NC.noChance.packetevents.api.event.PacketListenerAbstract;
import NC.noChance.packetevents.api.event.PacketReceiveEvent;
import NC.noChance.packetevents.api.protocol.packettype.PacketType;
import NC.noChance.packets.BlockPacketAnalyzer;
import NC.noChance.packets.CombatPacketAnalyzer;
import NC.noChance.packets.MovementPacketAnalyzer;
import java.util.Deque;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PacketAnalyzer {
    private final Plugin plugin;
    private final Map<UUID, PacketData> packetDataMap;
    private final MovementPacketAnalyzer movementAnalyzer;
    private final CombatPacketAnalyzer combatAnalyzer;
    private final BlockPacketAnalyzer blockAnalyzer;
    private final ACConfig config;
    private final BlinkCheck blinkCheck;
    private BadPacketsCheck badPacketsCheck;

    public PacketAnalyzer(Plugin plugin, ACConfig config, BlinkCheck blinkCheck) {
        this.plugin = plugin;
        this.config = config;
        this.blinkCheck = blinkCheck;
        this.packetDataMap = new ConcurrentHashMap<UUID, PacketData>();
        this.movementAnalyzer = new MovementPacketAnalyzer(config);
        this.combatAnalyzer = new CombatPacketAnalyzer(config, plugin);
        this.blockAnalyzer = new BlockPacketAnalyzer(config);
        this.registerPacketListeners();
    }

    public void setBadPacketsCheck(BadPacketsCheck badPacketsCheck) {
        this.badPacketsCheck = badPacketsCheck;
    }

    private void registerPacketListeners() {
        PacketEvents.getAPI().getEventManager().registerListener(new PacketListenerAbstract(){

            @Override
            public void onPacketReceive(PacketReceiveEvent event) {
                try {
                    Object playerObj = event.getPlayer();
                    if (playerObj == null || !(playerObj instanceof Player)) {
                        return;
                    }
                    Player player = (Player)playerObj;
                    PacketData data = PacketAnalyzer.this.packetDataMap.computeIfAbsent(player.getUniqueId(), k -> new PacketData());
                    long timestamp = System.currentTimeMillis();
                    String packetType = event.getPacketType().getName();
                    if (PacketAnalyzer.this.blinkCheck != null) {
                        PacketAnalyzer.this.blinkCheck.onPacketReceived(player, packetType, timestamp);
                    }
                    if (PacketAnalyzer.this.badPacketsCheck != null) {
                        PacketAnalyzer.this.badPacketsCheck.processPacket(player, event);
                    }
                    if (event.getPacketType() == PacketType.Play.Client.PLAYER_POSITION || event.getPacketType() == PacketType.Play.Client.PLAYER_POSITION_AND_ROTATION || event.getPacketType() == PacketType.Play.Client.PLAYER_ROTATION) {
                        PacketAnalyzer.this.movementAnalyzer.analyzeMovementPacket(event, player, data);
                    } else if (event.getPacketType() == PacketType.Play.Client.INTERACT_ENTITY || event.getPacketType() == PacketType.Play.Client.ANIMATION) {
                        PacketAnalyzer.this.combatAnalyzer.analyzeCombatPacket(event, player, data);
                    } else if (event.getPacketType() == PacketType.Play.Client.PLAYER_BLOCK_PLACEMENT || event.getPacketType() == PacketType.Play.Client.PLAYER_DIGGING) {
                        PacketAnalyzer.this.blockAnalyzer.analyzeBlockPacket(event, player, data);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public PacketViolationResult analyzeForViolations(Player player, ViolationType type) {
        PacketData data = this.packetDataMap.get(player.getUniqueId());
        if (data == null) {
            return new PacketViolationResult(false, 0.0, "No packet data");
        }
        switch (type) {
            case FLY: 
            case SPEED: 
            case NOCLIP: {
                return this.movementAnalyzer.checkMovementViolation(player, data, type);
            }
            case KILLAURA: 
            case KILLAURA_ANGLE: 
            case KILLAURA_ROTATION: 
            case KILLAURA_PATTERN: 
            case AUTOCLICKER: 
            case REACH: {
                return this.combatAnalyzer.checkCombatViolation(player, data, type);
            }
            case SCAFFOLD: 
            case FASTPLACE: 
            case FASTBREAK: 
            case NUKER: {
                return this.blockAnalyzer.checkBlockViolation(player, data, type);
            }
        }
        return new PacketViolationResult(false, 0.0, "Type not supported");
    }

    public void cleanup(UUID playerId) {
        this.packetDataMap.remove(playerId);
    }

    public static class PacketData {
        private final Deque<Long> movementPacketTimes = new ConcurrentLinkedDeque<Long>();
        private final Deque<Long> combatPacketTimes = new ConcurrentLinkedDeque<Long>();
        private final Deque<Long> blockPacketTimes = new ConcurrentLinkedDeque<Long>();
        private final Map<String, Object> metadata = new ConcurrentHashMap<String, Object>();

        public void recordPacket(PacketCategory category) {
            long now = System.currentTimeMillis();
            switch (category.ordinal()) {
                case 0: {
                    this.movementPacketTimes.addLast(now);
                    if (this.movementPacketTimes.size() <= 50) break;
                    this.movementPacketTimes.removeFirst();
                    break;
                }
                case 1: {
                    this.combatPacketTimes.addLast(now);
                    if (this.combatPacketTimes.size() <= 50) break;
                    this.combatPacketTimes.removeFirst();
                    break;
                }
                case 2: {
                    this.blockPacketTimes.addLast(now);
                    if (this.blockPacketTimes.size() <= 50) break;
                    this.blockPacketTimes.removeFirst();
                }
            }
        }

        public Deque<Long> getMovementPacketTimes() {
            return this.movementPacketTimes;
        }

        public Deque<Long> getCombatPacketTimes() {
            return this.combatPacketTimes;
        }

        public Deque<Long> getBlockPacketTimes() {
            return this.blockPacketTimes;
        }

        public void setMetadata(String key, Object value) {
            this.metadata.put(key, value);
        }

        public Object getMetadata(String key) {
            return this.metadata.get(key);
        }
    }

    public static class PacketViolationResult {
        public final boolean violated;
        public final double severity;
        public final String reason;

        public PacketViolationResult(boolean violated, double severity, String reason) {
            this.violated = violated;
            this.severity = severity;
            this.reason = reason;
        }
    }

    public static enum PacketCategory {
        MOVEMENT,
        COMBAT,
        BLOCK;

    }
}

