/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.punishment;

import NC.noChance.core.ACConfig;
import NC.noChance.core.ViolationType;
import NC.noChance.database.DatabaseManager;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PunishmentManager {
    private final Plugin plugin;
    private final ACConfig config;
    private final DatabaseManager database;
    private final Map<UUID, PunishmentTracker> trackers;
    private final Map<UUID, Long> lastWarningTime;
    private static final long WARNING_THROTTLE_MS = 30000L;

    public PunishmentManager(Plugin plugin, ACConfig config, DatabaseManager database) {
        this.plugin = plugin;
        this.config = config;
        this.database = database;
        this.trackers = new ConcurrentHashMap<UUID, PunishmentTracker>();
        this.lastWarningTime = new ConcurrentHashMap<UUID, Long>();
    }

    public void handleViolation(Player player, ViolationType type, double severity, String details, String confidenceLevel) {
        int typeViolations;
        UUID uuid = player.getUniqueId();
        PunishmentTracker tracker = this.trackers.computeIfAbsent(uuid, k -> new PunishmentTracker());
        tracker.addViolation(type, severity);
        if (this.config.isOpExempt() && player.isOp()) {
            return;
        }
        if (player.hasPermission("nochance.bypass") || player.hasPermission("nochance.bypass." + type.name().toLowerCase())) {
            return;
        }
        int totalViolations = tracker.getTotalViolations();
        PunishmentAction action = this.determinePunishment(totalViolations, typeViolations = tracker.getTypeViolations(type), confidenceLevel, severity);
        if (action != null) {
            this.executePunishment(player, action, type, details, confidenceLevel);
            tracker.reset();
        }
    }

    private PunishmentAction determinePunishment(int totalViolations, int typeViolations, String confidenceLevel, double severity) {
        if (confidenceLevel.equals("EXTREME") && severity >= 0.95) {
            if (totalViolations >= 8) {
                return new PunishmentAction(DatabaseManager.PunishmentType.BAN, 0L, "Extreme confidence cheating detected");
            }
            if (totalViolations >= 5) {
                return new PunishmentAction(DatabaseManager.PunishmentType.TEMPBAN, TimeUnit.HOURS.toMillis(24L), "High severity violations");
            }
            if (totalViolations >= 3) {
                return new PunishmentAction(DatabaseManager.PunishmentType.KICK, 0L, "Multiple extreme violations");
            }
        }
        if (confidenceLevel.equals("HIGH") && severity >= 0.85) {
            if (totalViolations >= 12) {
                return new PunishmentAction(DatabaseManager.PunishmentType.TEMPBAN, TimeUnit.HOURS.toMillis(12L), "Repeated high confidence violations");
            }
            if (totalViolations >= 8) {
                return new PunishmentAction(DatabaseManager.PunishmentType.KICK, 0L, "Consistent suspicious behavior");
            }
            if (totalViolations >= 5) {
                return new PunishmentAction(DatabaseManager.PunishmentType.WARN, 0L, "High confidence detection");
            }
        }
        if (confidenceLevel.equals("MEDIUM") && severity >= 0.75) {
            if (totalViolations >= 18) {
                return new PunishmentAction(DatabaseManager.PunishmentType.KICK, 0L, "Excessive medium confidence violations");
            }
            if (totalViolations >= 12) {
                return new PunishmentAction(DatabaseManager.PunishmentType.WARN, 0L, "Multiple suspicious actions");
            }
        }
        if (typeViolations >= 15) {
            return new PunishmentAction(DatabaseManager.PunishmentType.KICK, 0L, "Repeated violations of same type");
        }
        return null;
    }

    private void executePunishment(Player player, PunishmentAction action, ViolationType type, String details, String confidenceLevel) {
        String reason = String.format("\u00a7c[NoChance] %s\n\u00a77Type: %s\n\u00a77Confidence: %s", action.reason, type.name(), confidenceLevel);
        this.database.logPunishment(player.getUniqueId(), player.getName(), action.type, reason, action.duration, "NoChance");
        Bukkit.getScheduler().runTask(this.plugin, () -> {
            switch (action.type) {
                case WARN: {
                    UUID uuid = player.getUniqueId();
                    long now = System.currentTimeMillis();
                    Long lastWarn = this.lastWarningTime.get(uuid);
                    if (this.config.shouldNotifyPlayerOnFlag() && (lastWarn == null || now - lastWarn >= 30000L)) {
                        player.sendMessage("\u00a7c\u00a7l[!] \u00a7cANTI-CHEAT WARNING");
                        player.sendMessage("\u00a77You have been flagged for: \u00a7e" + type.name());
                        player.sendMessage("\u00a77Stop suspicious behavior or face punishment.");
                        this.lastWarningTime.put(uuid, now);
                    }
                    for (Player staff : Bukkit.getOnlinePlayers()) {
                        if (!staff.hasPermission("nochance.alerts")) continue;
                        staff.sendMessage("\u00a76[NoChance] \u00a7e" + player.getName() + " \u00a77was \u00a7ewarned \u00a77for \u00a7e" + type.name());
                    }
                    break;
                }
                case KICK: {
                    player.kickPlayer(reason);
                    for (Player staff : Bukkit.getOnlinePlayers()) {
                        if (!staff.hasPermission("nochance.alerts")) continue;
                        staff.sendMessage("\u00a76[NoChance] \u00a7e" + player.getName() + " \u00a77was \u00a7ckicked \u00a77for \u00a7e" + type.name());
                    }
                    break;
                }
                case TEMPBAN: {
                    long minutes = action.duration / 60000L;
                    String duration = this.formatDuration(action.duration);
                    Date expirationDate = new Date(System.currentTimeMillis() + action.duration);
                    Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(player.getName(), reason + "\n\u00a77Duration: " + duration, expirationDate, "NoChance");
                    player.kickPlayer(reason + "\n\n\u00a77Banned for: \u00a7e" + duration);
                    for (Player staff : Bukkit.getOnlinePlayers()) {
                        if (!staff.hasPermission("nochance.alerts")) continue;
                        staff.sendMessage("\u00a76[NoChance] \u00a7e" + player.getName() + " \u00a77was \u00a7ctempbanned \u00a77(" + duration + ") for \u00a7e" + type.name());
                    }
                    break;
                }
                case BAN: {
                    Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(player.getName(), reason, (Date)null, "NoChance");
                    player.kickPlayer(reason + "\n\n\u00a7c\u00a7lPERMANENTLY BANNED");
                    for (Player staff : Bukkit.getOnlinePlayers()) {
                        if (!staff.hasPermission("nochance.alerts")) continue;
                        staff.sendMessage("\u00a76[NoChance] \u00a7e" + player.getName() + " \u00a77was \u00a74\u00a7lPERMABANNED \u00a77for \u00a7e" + type.name());
                    }
                    break;
                }
            }
        });
    }

    private String formatDuration(long millis) {
        long days = TimeUnit.MILLISECONDS.toDays(millis);
        long hours = TimeUnit.MILLISECONDS.toHours(millis) % 24L;
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis) % 60L;
        if (days > 0L) {
            return days + "d " + hours + "h";
        }
        if (hours > 0L) {
            return hours + "h " + minutes + "m";
        }
        return minutes + "m";
    }

    public void cleanup(UUID uuid) {
        this.trackers.remove(uuid);
        this.lastWarningTime.remove(uuid);
    }

    private static class PunishmentTracker {
        private final Map<ViolationType, Integer> violationCounts = new HashMap<ViolationType, Integer>();
        private int totalViolations = 0;

        private PunishmentTracker() {
        }

        void addViolation(ViolationType type, double severity) {
            if (severity >= 0.6) {
                this.violationCounts.put(type, this.violationCounts.getOrDefault((Object)type, 0) + 1);
                ++this.totalViolations;
            }
        }

        int getTotalViolations() {
            return this.totalViolations;
        }

        int getTypeViolations(ViolationType type) {
            return this.violationCounts.getOrDefault((Object)type, 0);
        }

        void reset() {
            this.violationCounts.clear();
            this.totalViolations = 0;
        }
    }

    private static class PunishmentAction {
        final DatabaseManager.PunishmentType type;
        final long duration;
        final String reason;

        PunishmentAction(DatabaseManager.PunishmentType type, long duration, String reason) {
            this.type = type;
            this.duration = duration;
            this.reason = reason;
        }
    }
}

