/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.replay;

import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;

public class FakePlayer {
    private final Player viewer;
    private final String name;
    private final World world;
    private NPC npc;
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;
    private boolean spawned;

    public FakePlayer(Player viewer, String name, World world) {
        this.viewer = viewer;
        this.name = name;
        this.world = world;
        this.spawned = false;
    }

    public void spawn(double x, double y, double z, float yaw, float pitch) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.spawned = true;
    }

    public void sendSpawnPackets() {
        if (!this.isCitizensEnabled()) {
            return;
        }
        try {
            NPCRegistry registry = CitizensAPI.getNPCRegistry();
            this.npc = registry.createNPC(EntityType.PLAYER, "\u00a7c[REPLAY] \u00a77" + this.name);
            this.npc.setProtected(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendSpawnEntity() {
        if (this.npc == null) {
            return;
        }
        try {
            Location loc = new Location(this.world, this.x, this.y, this.z, this.yaw, this.pitch);
            this.npc.spawn(loc);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void move(double x, double y, double z, float yaw, float pitch, boolean onGround) {
        if (!this.spawned || this.npc == null || !this.npc.isSpawned()) {
            return;
        }
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        Location loc = new Location(this.world, x, y, z, yaw, pitch);
        this.npc.teleport(loc, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public void swing() {
        if (this.npc == null || !this.npc.isSpawned()) {
            return;
        }
        if (this.npc.getEntity() instanceof Player) {
            ((Player)this.npc.getEntity()).swingMainHand();
        }
    }

    public void sneak(boolean sneaking) {
        if (this.npc == null || !this.npc.isSpawned()) {
            return;
        }
        if (this.npc.getEntity() instanceof Player) {
            ((Player)this.npc.getEntity()).setSneaking(sneaking);
        }
    }

    public void setSprinting(boolean sprinting) {
        if (this.npc == null || !this.npc.isSpawned()) {
            return;
        }
        if (this.npc.getEntity() instanceof Player) {
            ((Player)this.npc.getEntity()).setSprinting(sprinting);
        }
    }

    public void setGliding(boolean gliding) {
        if (this.npc == null || !this.npc.isSpawned()) {
            return;
        }
        if (this.npc.getEntity() instanceof Player) {
            ((Player)this.npc.getEntity()).setGliding(gliding);
        }
    }

    public void setSwimming(boolean swimming) {
        if (this.npc == null || !this.npc.isSpawned()) {
            return;
        }
        if (this.npc.getEntity() instanceof Player) {
            ((Player)this.npc.getEntity()).setSwimming(swimming);
        }
    }

    public void setSlot(int slot, ItemStack item) {
        if (this.npc == null || !this.npc.isSpawned()) {
            return;
        }
        if (this.npc.getEntity() instanceof Player) {
            ((Player)this.npc.getEntity()).getInventory().setItemInMainHand(item);
        }
    }

    public void destroy() {
        if (this.npc != null) {
            this.npc.destroy();
            this.npc = null;
        }
        this.spawned = false;
    }

    public Location getLocation() {
        return new Location(this.world, this.x, this.y, this.z, this.yaw, this.pitch);
    }

    public boolean isSpawned() {
        return this.spawned && this.npc != null && this.npc.isSpawned();
    }

    public int getEntityId() {
        if (this.npc != null && this.npc.getEntity() != null) {
            return this.npc.getEntity().getEntityId();
        }
        return -1;
    }

    private boolean isCitizensEnabled() {
        return Bukkit.getPluginManager().isPluginEnabled("Citizens");
    }
}

