/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.replay;

import NC.noChance.replay.Snapshot;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class ReplayBuffer {
    private final int capacity;
    private final Deque<Snapshot> buffer;
    private Snapshot.Action pendingAction = Snapshot.Action.NONE;
    private int pendingTargetId = -1;

    public ReplayBuffer(int capacity) {
        this.capacity = capacity;
        this.buffer = new ArrayDeque<Snapshot>(capacity);
    }

    public synchronized void capture(Player player) {
        Location loc = player.getLocation();
        Vector vel = player.getVelocity();
        ItemStack hand = player.getInventory().getItemInMainHand();
        Material mat = hand != null ? hand.getType() : Material.AIR;
        Snapshot snapshot = new Snapshot(System.currentTimeMillis(), loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch(), vel.getX(), vel.getY(), vel.getZ(), player.isSneaking(), player.isSprinting(), player.isBlocking(), player.isOnGround(), player.isSwimming(), player.isGliding(), mat, this.pendingAction, this.pendingTargetId, player.getInventory().getHeldItemSlot(), (float)player.getHealth());
        if (this.buffer.size() >= this.capacity) {
            this.buffer.pollFirst();
        }
        this.buffer.addLast(snapshot);
        this.pendingAction = Snapshot.Action.NONE;
        this.pendingTargetId = -1;
    }

    public synchronized void setAction(Snapshot.Action action, int targetId) {
        this.pendingAction = action;
        this.pendingTargetId = targetId;
    }

    public synchronized void setAction(Snapshot.Action action) {
        this.setAction(action, -1);
    }

    public synchronized List<Snapshot> drain() {
        ArrayList<Snapshot> snapshots = new ArrayList<Snapshot>(this.buffer);
        this.buffer.clear();
        return snapshots;
    }

    public synchronized List<Snapshot> copy() {
        return new ArrayList<Snapshot>(this.buffer);
    }

    public synchronized void clear() {
        this.buffer.clear();
    }

    public synchronized int size() {
        return this.buffer.size();
    }
}

