/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.replay;

import NC.noChance.core.ViolationType;
import NC.noChance.replay.Snapshot;
import java.util.List;
import java.util.UUID;

public class ReplayData {
    private final UUID playerId;
    private final String playerName;
    private final String world;
    private final ViolationType violationType;
    private final String confidence;
    private final long recordTime;
    private final List<Snapshot> snapshots;

    public ReplayData(UUID playerId, String playerName, String world, ViolationType violationType, String confidence, long recordTime, List<Snapshot> snapshots) {
        this.playerId = playerId;
        this.playerName = playerName;
        this.world = world;
        this.violationType = violationType;
        this.confidence = confidence;
        this.recordTime = recordTime;
        this.snapshots = snapshots;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public String getWorld() {
        return this.world;
    }

    public ViolationType getViolationType() {
        return this.violationType;
    }

    public String getConfidence() {
        return this.confidence;
    }

    public long getRecordTime() {
        return this.recordTime;
    }

    public List<Snapshot> getSnapshots() {
        return this.snapshots;
    }

    public long getDuration() {
        if (this.snapshots.isEmpty()) {
            return 0L;
        }
        return this.snapshots.get((int)(this.snapshots.size() - 1)).timestamp - this.snapshots.get((int)0).timestamp;
    }
}

