/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.replay;

import NC.noChance.core.ViolationType;
import NC.noChance.replay.ReplayData;
import NC.noChance.replay.Snapshot;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ReplayIO {
    private static final int VERSION = 1;
    private static final byte[] MAGIC = new byte[]{78, 67, 82, 80};
    private final Path replayDir;

    public ReplayIO(Path dataFolder) {
        this.replayDir = dataFolder.resolve("replays");
        try {
            Files.createDirectories(this.replayDir, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void save(ReplayData data) throws IOException {
        String shortTime = Long.toString(data.getRecordTime() / 1000L % 100000L, 36);
        String filename = String.format("%s_%s_%s.ncrp", data.getPlayerName().substring(0, Math.min(8, data.getPlayerName().length())), shortTime, data.getViolationType().name().substring(0, Math.min(4, data.getViolationType().name().length())).toLowerCase());
        Path file = this.replayDir.resolve(filename);
        try (DataOutputStream out = new DataOutputStream(new GZIPOutputStream(new FileOutputStream(file.toFile())));){
            out.write(MAGIC);
            out.writeInt(1);
            out.writeLong(data.getPlayerId().getMostSignificantBits());
            out.writeLong(data.getPlayerId().getLeastSignificantBits());
            out.writeUTF(data.getPlayerName());
            out.writeUTF(data.getWorld());
            out.writeUTF(data.getViolationType().name());
            out.writeUTF(data.getConfidence());
            out.writeLong(data.getRecordTime());
            out.writeInt(data.getSnapshots().size());
            for (Snapshot snap : data.getSnapshots()) {
                snap.write(out);
            }
        }
    }

    public ReplayData load(String filename) throws IOException {
        Path file = this.replayDir.resolve(filename);
        if (!Files.exists(file, new LinkOption[0])) {
            throw new FileNotFoundException("Replay not found: " + filename);
        }
        try (DataInputStream in = new DataInputStream(new GZIPInputStream(new FileInputStream(file.toFile())));){
            byte[] magic = new byte[4];
            in.readFully(magic);
            for (int i = 0; i < 4; ++i) {
                if (magic[i] == MAGIC[i]) continue;
                throw new IOException("Invalid replay file");
            }
            int version = in.readInt();
            if (version != 1) {
                throw new IOException("Unsupported replay version: " + version);
            }
            long mostSig = in.readLong();
            long leastSig = in.readLong();
            UUID playerId = new UUID(mostSig, leastSig);
            String playerName = in.readUTF();
            String world = in.readUTF();
            ViolationType violationType = ViolationType.valueOf(in.readUTF());
            String confidence = in.readUTF();
            long recordTime = in.readLong();
            int count = in.readInt();
            ArrayList<Snapshot> snapshots = new ArrayList<Snapshot>(count);
            for (int i = 0; i < count; ++i) {
                snapshots.add(Snapshot.read(in));
            }
            ReplayData replayData = new ReplayData(playerId, playerName, world, violationType, confidence, recordTime, snapshots);
            return replayData;
        }
    }

    public List<String> listReplays(String playerName) {
        ArrayList<String> result = new ArrayList<String>();
        File[] files = this.replayDir.toFile().listFiles((dir, name) -> name.endsWith(".ncrp") && (playerName == null || name.startsWith(playerName + "_")));
        if (files != null) {
            for (File f : files) {
                result.add(f.getName());
            }
        }
        result.sort((a, b) -> b.compareTo((String)a));
        return result;
    }

    public void cleanup(long maxAgeMs) {
        long cutoff = System.currentTimeMillis() - maxAgeMs;
        File[] files = this.replayDir.toFile().listFiles((dir, name) -> name.endsWith(".ncrp"));
        if (files != null) {
            for (File f : files) {
                if (f.lastModified() >= cutoff) continue;
                f.delete();
            }
        }
    }

    public Path getReplayDir() {
        return this.replayDir;
    }
}

