/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.replay;

import NC.noChance.replay.FakePlayer;
import NC.noChance.replay.ReplayData;
import NC.noChance.replay.Snapshot;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ReplayTask
extends BukkitRunnable {
    private final Plugin plugin;
    private final Player viewer;
    private final ReplayData data;
    private final List<Snapshot> snapshots;
    private final FakePlayer fakePlayer;
    private final Location originalLocation;
    private final GameMode originalGameMode;
    private int index;
    private long startTime;
    private long baseTimestamp;
    private boolean paused;
    private float speed;
    private boolean finished;
    private boolean following;
    private Snapshot lastSnap;

    public ReplayTask(Plugin plugin, Player viewer, ReplayData data) {
        this.plugin = plugin;
        this.viewer = viewer;
        this.data = data;
        this.snapshots = data.getSnapshots();
        this.index = 0;
        this.paused = false;
        this.speed = 1.0f;
        this.finished = false;
        this.following = false;
        this.originalLocation = viewer.getLocation().clone();
        this.originalGameMode = viewer.getGameMode();
        World world = Bukkit.getWorld((String)data.getWorld());
        if (world == null) {
            world = viewer.getWorld();
        }
        this.fakePlayer = new FakePlayer(viewer, data.getPlayerName(), world);
    }

    public void start() {
        if (this.snapshots.isEmpty()) {
            this.viewer.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Replay has no data.");
            return;
        }
        Snapshot first = this.snapshots.get(0);
        this.baseTimestamp = first.timestamp;
        World world = Bukkit.getWorld((String)this.data.getWorld());
        if (world == null) {
            world = this.viewer.getWorld();
        }
        double offsetX = -Math.sin(Math.toRadians(first.yaw)) * 8.0;
        double offsetZ = Math.cos(Math.toRadians(first.yaw)) * 8.0;
        Location start = new Location(world, first.x + offsetX, first.y + 5.0, first.z + offsetZ, first.yaw, 15.0f);
        this.viewer.setGameMode(GameMode.SPECTATOR);
        this.viewer.teleport(start);
        this.fakePlayer.spawn(first.x, first.y, first.z, first.yaw, first.pitch);
        this.fakePlayer.sendSpawnPackets();
        this.viewer.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Replay: \u00a7f" + this.data.getPlayerName() + " \u00a78| \u00a7c" + this.data.getViolationType().name());
        this.viewer.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Duration: \u00a7f" + String.format("%.1f", (double)this.data.getDuration() / 1000.0) + "s \u00a78| \u00a77Confidence: \u00a7f" + this.data.getConfidence());
        this.viewer.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Controls: \u00a7fstop\u00a78, \u00a7fpause\u00a78, \u00a7fspeed <x>\u00a78, \u00a7ffollow");
        Bukkit.getScheduler().runTaskLater(this.plugin, () -> {
            if (!this.finished && this.viewer.isOnline()) {
                this.fakePlayer.sendSpawnEntity();
                this.startTime = System.currentTimeMillis();
                this.runTaskTimer(this.plugin, 0L, 1L);
            }
        }, 5L);
    }

    public void run() {
        if (this.finished || !this.viewer.isOnline()) {
            this.stop();
            return;
        }
        if (this.paused) {
            return;
        }
        long elapsed = (long)((float)(System.currentTimeMillis() - this.startTime) * this.speed);
        long targetTime = this.baseTimestamp + elapsed;
        while (this.index < this.snapshots.size()) {
            Snapshot snap = this.snapshots.get(this.index);
            if (snap.timestamp > targetTime) break;
            this.processSnapshot(snap);
            this.lastSnap = snap;
            ++this.index;
        }
        if (this.following && this.lastSnap != null) {
            World world = Bukkit.getWorld((String)this.data.getWorld());
            if (world == null) {
                world = this.viewer.getWorld();
            }
            double offX = -Math.sin(Math.toRadians(this.lastSnap.yaw)) * 6.0;
            double offZ = Math.cos(Math.toRadians(this.lastSnap.yaw)) * 6.0;
            Location target = new Location(world, this.lastSnap.x + offX, this.lastSnap.y + 3.0, this.lastSnap.z + offZ, this.lastSnap.yaw, 15.0f);
            this.viewer.teleport(target);
        }
        if (this.index >= this.snapshots.size()) {
            this.viewer.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Replay finished.");
            this.stop();
        }
    }

    private void processSnapshot(Snapshot snap) {
        this.fakePlayer.move(snap.x, snap.y, snap.z, snap.yaw, snap.pitch, snap.onGround);
        switch (snap.action) {
            case SWING: 
            case ATTACK: 
            case BREAK_BLOCK: {
                this.fakePlayer.swing();
                break;
            }
        }
        this.fakePlayer.sneak(snap.sneaking);
        this.fakePlayer.setSprinting(snap.sprinting);
        this.fakePlayer.setGliding(snap.gliding);
        this.fakePlayer.setSwimming(snap.swimming);
        if (snap.mainHand != null) {
            ItemStack item = new ItemStack(snap.mainHand);
            this.fakePlayer.setSlot(snap.slot, item);
        }
    }

    public void stop() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.fakePlayer.destroy();
        if (this.viewer.isOnline()) {
            this.viewer.teleport(this.originalLocation);
            this.viewer.setGameMode(this.originalGameMode);
            this.viewer.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Replay stopped.");
        }
        try {
            this.cancel();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void pause() {
        if (this.paused) {
            this.paused = false;
            this.startTime = System.currentTimeMillis() - (long)((float)(this.snapshots.get((int)Math.min((int)this.index, (int)(this.snapshots.size() - 1))).timestamp - this.baseTimestamp) / this.speed);
            this.viewer.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Resumed.");
        } else {
            this.paused = true;
            this.viewer.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Paused.");
        }
    }

    public void setSpeed(float speed) {
        this.speed = Math.max(0.25f, Math.min(4.0f, speed));
        if (this.index < this.snapshots.size()) {
            long currentProgress = this.snapshots.get((int)this.index).timestamp - this.baseTimestamp;
            this.startTime = System.currentTimeMillis() - (long)((float)currentProgress / this.speed);
        }
        this.viewer.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Speed: \u00a7f" + this.speed + "x");
    }

    public void toggleFollow() {
        this.following = !this.following;
        this.viewer.sendMessage("\u00a7c\u00a7lNoChance \u00a78\u00bb \u00a77Follow: " + (this.following ? "\u00a7aON" : "\u00a7cOFF"));
    }

    public boolean isFinished() {
        return this.finished;
    }

    public ReplayData getData() {
        return this.data;
    }
}

