/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.replay;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.bukkit.Material;

public class Snapshot {
    public final long timestamp;
    public final double x;
    public final double y;
    public final double z;
    public final float yaw;
    public final float pitch;
    public final double velX;
    public final double velY;
    public final double velZ;
    public final boolean sneaking;
    public final boolean sprinting;
    public final boolean blocking;
    public final boolean onGround;
    public final boolean swimming;
    public final boolean gliding;
    public final Material mainHand;
    public final Action action;
    public final int targetId;
    public final int slot;
    public final float health;

    public Snapshot(long timestamp, double x, double y, double z, float yaw, float pitch, double velX, double velY, double velZ, boolean sneaking, boolean sprinting, boolean blocking, boolean onGround, boolean swimming, boolean gliding, Material mainHand, Action action, int targetId, int slot, float health) {
        this.timestamp = timestamp;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.velX = velX;
        this.velY = velY;
        this.velZ = velZ;
        this.sneaking = sneaking;
        this.sprinting = sprinting;
        this.blocking = blocking;
        this.onGround = onGround;
        this.swimming = swimming;
        this.gliding = gliding;
        this.mainHand = mainHand;
        this.action = action;
        this.targetId = targetId;
        this.slot = slot;
        this.health = health;
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeLong(this.timestamp);
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
        out.writeFloat(this.yaw);
        out.writeFloat(this.pitch);
        out.writeDouble(this.velX);
        out.writeDouble(this.velY);
        out.writeDouble(this.velZ);
        int flags = 0;
        if (this.sneaking) {
            flags |= 1;
        }
        if (this.sprinting) {
            flags |= 2;
        }
        if (this.blocking) {
            flags |= 4;
        }
        if (this.onGround) {
            flags |= 8;
        }
        if (this.swimming) {
            flags |= 0x10;
        }
        if (this.gliding) {
            flags |= 0x20;
        }
        out.writeByte(flags);
        out.writeUTF(this.mainHand != null ? this.mainHand.name() : "AIR");
        out.writeByte(this.action.ordinal());
        out.writeInt(this.targetId);
        out.writeInt(this.slot);
        out.writeFloat(this.health);
    }

    public static Snapshot read(DataInputStream in) throws IOException {
        Material mainHand;
        long timestamp = in.readLong();
        double x = in.readDouble();
        double y = in.readDouble();
        double z = in.readDouble();
        float yaw = in.readFloat();
        float pitch = in.readFloat();
        double velX = in.readDouble();
        double velY = in.readDouble();
        double velZ = in.readDouble();
        byte flags = in.readByte();
        boolean sneaking = (flags & 1) != 0;
        boolean sprinting = (flags & 2) != 0;
        boolean blocking = (flags & 4) != 0;
        boolean onGround = (flags & 8) != 0;
        boolean swimming = (flags & 0x10) != 0;
        boolean gliding = (flags & 0x20) != 0;
        String matName = in.readUTF();
        try {
            mainHand = Material.valueOf((String)matName);
        }
        catch (IllegalArgumentException e) {
            mainHand = Material.AIR;
        }
        Action action = Action.values()[in.readByte()];
        int targetId = in.readInt();
        int slot = in.readInt();
        float health = in.readFloat();
        return new Snapshot(timestamp, x, y, z, yaw, pitch, velX, velY, velZ, sneaking, sprinting, blocking, onGround, swimming, gliding, mainHand, action, targetId, slot, health);
    }

    public static enum Action {
        NONE,
        SWING,
        ATTACK,
        BREAK_BLOCK,
        PLACE_BLOCK,
        USE_ITEM;

    }
}

