/*
 * Decompiled with CFR 0.152.
 */
package NC.noChance.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Scanner;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class UpdateChecker {
    private final Plugin plugin;
    private final int resourceId;
    private volatile String latestVersion;
    private volatile boolean updateAvailable = false;
    private volatile boolean checkComplete = false;

    public UpdateChecker(Plugin plugin, int resourceId) {
        this.plugin = plugin;
        this.resourceId = resourceId;
    }

    public void checkForUpdates(Consumer<String> consumer) {
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, () -> {
            try (InputStream inputStream = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.resourceId).openStream();
                 Scanner scanner = new Scanner(inputStream);){
                if (scanner.hasNext()) {
                    consumer.accept(scanner.next());
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Failed to check for updates: " + e.getMessage());
                this.checkComplete = true;
            }
        });
    }

    public void performCheck() {
        this.checkForUpdates(version -> {
            String currentVersion = this.plugin.getDescription().getVersion();
            this.latestVersion = version;
            int comparison = this.compareVersions(currentVersion, (String)version);
            if (comparison < 0) {
                this.updateAvailable = true;
                this.plugin.getLogger().info(" ");
                this.plugin.getLogger().info("Update available! Current: " + currentVersion + " | Latest: " + version);
                this.plugin.getLogger().info("Download: https://www.spigotmc.org/resources/129357/");
                this.plugin.getLogger().info(" ");
            } else {
                this.updateAvailable = false;
                this.plugin.getLogger().info("You are running the latest version!");
            }
            this.checkComplete = true;
        });
    }

    private int compareVersions(String current, String latest) {
        try {
            String[] currentParts = current.split("\\.");
            String[] latestParts = latest.split("\\.");
            int maxLength = Math.max(currentParts.length, latestParts.length);
            for (int i = 0; i < maxLength; ++i) {
                int latestPart;
                int currentPart = i < currentParts.length ? this.parseVersionPart(currentParts[i]) : 0;
                int n = latestPart = i < latestParts.length ? this.parseVersionPart(latestParts[i]) : 0;
                if (currentPart < latestPart) {
                    return -1;
                }
                if (currentPart <= latestPart) continue;
                return 1;
            }
            return 0;
        }
        catch (NumberFormatException e) {
            return current.compareTo(latest);
        }
    }

    private int parseVersionPart(String part) {
        try {
            return Integer.parseInt(part.replaceAll("[^0-9]", ""));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable && this.checkComplete;
    }

    public String getLatestVersion() {
        return this.latestVersion != null ? this.latestVersion : "Unknown";
    }

    public String getCurrentVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean isCheckComplete() {
        return this.checkComplete;
    }
}

