/*
 * Decompiled with CFR 0.152.
 */
package cz.lukesmith.automaticsorter.block.custom;

import cz.lukesmith.automaticsorter.block.custom.FilterBlock;
import cz.lukesmith.automaticsorter.block.custom.SorterControllerBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PipeBlock
extends Block {
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static final BooleanProperty UP = BooleanProperty.create((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.create((String)"down");

    public PipeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{NORTH, SOUTH, WEST, EAST, UP, DOWN});
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        VoxelShape shape = Shapes.box((double)0.375, (double)0.375, (double)0.375, (double)0.625, (double)0.625, (double)0.625);
        int[][] directions = new int[][]{{6, 6, 0, 10, 10, 6}, {6, 6, 10, 10, 10, 16}, {10, 6, 6, 16, 10, 10}, {0, 6, 6, 6, 10, 10}, {6, 10, 6, 10, 16, 10}, {6, 0, 6, 10, 6, 10}};
        boolean[] directionsActive = new boolean[]{(Boolean)state.getValue((Property)NORTH), (Boolean)state.getValue((Property)SOUTH), (Boolean)state.getValue((Property)EAST), (Boolean)state.getValue((Property)WEST), (Boolean)state.getValue((Property)UP), (Boolean)state.getValue((Property)DOWN)};
        for (int i = 0; i < directions.length; ++i) {
            if (!directionsActive[i]) continue;
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)((double)directions[i][0] / 16.0), (double)((double)directions[i][1] / 16.0), (double)((double)directions[i][2] / 16.0), (double)((double)directions[i][3] / 16.0), (double)((double)directions[i][4] / 16.0), (double)((double)directions[i][5] / 16.0)));
        }
        return shape;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected BlockState updateShape(BlockState pState, LevelReader pLevel, ScheduledTickAccess pScheduledTickAccess, BlockPos pPos, Direction pDirection, BlockPos pNeighborPos, BlockState pNeighborState, RandomSource pRandom) {
        boolean isConnected = this.isConnectedToNeighbor(pNeighborState, pDirection);
        return (BlockState)pState.setValue((Property)this.getPropertyForDirection(pDirection), (Comparable)Boolean.valueOf(isConnected));
    }

    private boolean isConnectedToNeighbor(BlockState neighborState, Direction direction) {
        if (direction == Direction.UP && neighborState.getBlock() instanceof SorterControllerBlock) {
            return true;
        }
        if (neighborState.getBlock() instanceof FilterBlock) {
            Direction filterFacing = (Direction)neighborState.getValue(FilterBlock.FACING);
            return direction == filterFacing;
        }
        return neighborState.getBlock() instanceof PipeBlock;
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, world, pos, oldState, isMoving);
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = pos.relative(direction);
            BlockState neighborState = world.getBlockState(neighborPos);
            state = (BlockState)state.setValue((Property)this.getPropertyForDirection(direction), (Comparable)Boolean.valueOf(this.isConnectedToNeighbor(neighborState, direction)));
        }
        world.setBlock(pos, state, 3);
    }

    private BooleanProperty getPropertyForDirection(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> NORTH;
            case Direction.EAST -> EAST;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            case Direction.UP -> UP;
            case Direction.DOWN -> DOWN;
        };
    }
}

