/*
 * Decompiled with CFR 0.152.
 */
package cz.lukesmith.automaticsorter.inventory.inventoryAdapters;

import cz.lukesmith.automaticsorter.inventory.inventoryAdapters.IInventoryAdapter;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.class_1799;

public class MultiInventoryAdapter
implements IInventoryAdapter {
    private ArrayList<IInventoryAdapter> inventoryAdapters = new ArrayList();

    public MultiInventoryAdapter(IInventoryAdapter inventoryAdapters) {
        this.inventoryAdapters.add(inventoryAdapters);
    }

    @Override
    public class_1799 containsItem(class_1799 itemStack) {
        if (itemStack == null || itemStack.method_7960()) {
            return class_1799.field_8037;
        }
        for (IInventoryAdapter inventoryAdapter : this.inventoryAdapters) {
            class_1799 stack = inventoryAdapter.containsItem(itemStack);
            if (stack.method_7960()) continue;
            return stack;
        }
        return class_1799.field_8037;
    }

    @Override
    public void removeItem(int index, int amount) {
        int i = 0;
        for (IInventoryAdapter inventoryAdapter : this.inventoryAdapters) {
            if (index < i + inventoryAdapter.getSize()) {
                inventoryAdapter.removeItem(index - i, amount);
                return;
            }
            i += inventoryAdapter.getSize();
        }
    }

    @Override
    public int addItem(class_1799 itemStack, int maxAmount) {
        IInventoryAdapter inventoryAdapter;
        int added;
        int toTransfer = Math.min(maxAmount, itemStack.method_7947());
        int transferred = 0;
        Iterator<IInventoryAdapter> iterator = this.inventoryAdapters.iterator();
        while (iterator.hasNext() && (transferred += (added = (inventoryAdapter = iterator.next()).addItem(itemStack, toTransfer - transferred))) < toTransfer) {
        }
        return transferred;
    }

    public void addInventoryAdapter(IInventoryAdapter inventoryAdapter) {
        this.inventoryAdapters.add(inventoryAdapter);
    }

    public void addInventoryAdapterAsFirst(IInventoryAdapter inventoryAdapter) {
        this.inventoryAdapters.add(0, inventoryAdapter);
    }

    public void setInventoryAdapters(ArrayList<IInventoryAdapter> inventoryAdapters) {
        this.inventoryAdapters = inventoryAdapters;
    }

    @Override
    public ArrayList<class_1799> getAllStacks() {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        for (IInventoryAdapter inventoryAdapter : this.inventoryAdapters) {
            stacks.addAll(inventoryAdapter.getAllStacks());
        }
        return stacks;
    }

    @Override
    public int getSize() {
        int size = 0;
        for (IInventoryAdapter inventoryAdapter : this.inventoryAdapters) {
            size += inventoryAdapter.getSize();
        }
        return size;
    }
}

