/*
 * Decompiled with CFR 0.152.
 */
package cz.lukesmith.automaticsorter.inventory.inventoryUtils;

import cz.lukesmith.automaticsorter.inventory.inventoryAdapters.IInventoryAdapter;
import cz.lukesmith.automaticsorter.inventory.inventoryAdapters.InventoryAdapter;
import cz.lukesmith.automaticsorter.inventory.inventoryAdapters.MultiInventoryAdapter;
import cz.lukesmith.automaticsorter.inventory.inventoryAdapters.NoInventoryAdapter;
import cz.lukesmith.automaticsorter.inventory.inventoryUtils.IInventoryUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.class_1263;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class ExpandedInventoryUtil
implements IInventoryUtil {
    private static final String MAIN_CLASSNAME = "dev.compasses.expandedstorage.block.AbstractChestBlock";
    private static final String CHEST_BLOCK_ENTITY_CLASSNAME = "dev.compasses.expandedstorage.block.entity.ChestBlockEntity";

    @Override
    public IInventoryAdapter getInventoryAdapter(class_1937 world, class_2338 pos, class_2248 block, class_2586 blockEntity) {
        try {
            Class<?> chestBlockClass = Class.forName(MAIN_CLASSNAME);
            if (chestBlockClass.isInstance(block)) {
                MultiInventoryAdapter multiInventoryAdapter = new MultiInventoryAdapter(new InventoryAdapter(ExpandedInventoryUtil.getExpandedStorageInventory(blockEntity)));
                try {
                    Object chestBlock = chestBlockClass.cast(block);
                    Method getContainerMethod = chestBlockClass.getMethod("getDirectionToAttached", class_2680.class);
                    class_2350 direction = (class_2350)getContainerMethod.invoke(chestBlock, world.method_8320(pos));
                    class_2338 secondPos = pos.method_10093(direction);
                    class_2586 secondBlockEntity = world.method_8321(secondPos);
                    class_2350 facing = (class_2350)world.method_8320(pos).method_11654((class_2769)class_2281.field_10768);
                    InventoryAdapter secondInventoryAdapter = new InventoryAdapter(ExpandedInventoryUtil.getExpandedStorageInventory(secondBlockEntity));
                    if (facing == class_2350.field_11034 && direction == class_2350.field_11035 || facing == class_2350.field_11035 && direction == class_2350.field_11039 || facing == class_2350.field_11039 && direction == class_2350.field_11043 || facing == class_2350.field_11043 && direction == class_2350.field_11034 || direction == class_2350.field_11036) {
                        multiInventoryAdapter.addInventoryAdapterAsFirst(secondInventoryAdapter);
                    } else {
                        multiInventoryAdapter.addInventoryAdapter(secondInventoryAdapter);
                    }
                    return multiInventoryAdapter;
                }
                catch (InvocationTargetException invocationTargetException) {
                    return multiInventoryAdapter;
                }
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
        return new NoInventoryAdapter();
    }

    @Override
    public boolean isRelatedStorage(class_2248 block, class_2586 blockEntity) {
        try {
            Class<?> chestBlockClass = Class.forName(MAIN_CLASSNAME);
            return chestBlockClass.isInstance(block);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static class_1263 getExpandedStorageInventory(class_2586 blockEntity) {
        try {
            Class<?> chestBlockEntityClass = Class.forName(CHEST_BLOCK_ENTITY_CLASSNAME);
            if (chestBlockEntityClass.isInstance(blockEntity)) {
                Object chestBlockEntity = chestBlockEntityClass.cast(blockEntity);
                Method getInventory = chestBlockEntityClass.getMethod("getInventory", new Class[0]);
                Object object = getInventory.invoke(chestBlockEntity, new Object[0]);
                if (object instanceof class_1263) {
                    class_1263 inventory = (class_1263)object;
                    return inventory;
                }
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }
}

