/*
 * Decompiled with CFR 0.152.
 */
package cz.lukesmith.automaticsorter.network;

import cz.lukesmith.automaticsorter.block.entity.FilterBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.network.CustomPayloadEvent;

public class FilterTypePacket {
    private final BlockPos pos;
    private final int filterType;

    public FilterTypePacket(BlockPos pos, int filterType) {
        this.pos = pos;
        this.filterType = filterType;
    }

    public static void encode(FilterTypePacket msg, FriendlyByteBuf buf) {
        buf.writeBlockPos(msg.pos);
        buf.writeInt(msg.filterType);
    }

    public static FilterTypePacket decode(FriendlyByteBuf buf) {
        return new FilterTypePacket(buf.readBlockPos(), buf.readInt());
    }

    public static void handle(FilterTypePacket msg, CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            Level world = player.level();
            BlockEntity patt0$temp = world.getBlockEntity(msg.pos);
            if (patt0$temp instanceof FilterBlockEntity) {
                FilterBlockEntity fe = (FilterBlockEntity)patt0$temp;
                fe.setFilterType(msg.filterType);
                fe.setChanged();
            }
        });
        context.setPacketHandled(true);
    }
}

