/*
 * Decompiled with CFR 0.152.
 */
package cz.lukesmith.automaticsorter.block.entity;

import cz.lukesmith.automaticsorter.block.custom.FilterBlock;
import cz.lukesmith.automaticsorter.block.custom.PipeBlock;
import cz.lukesmith.automaticsorter.block.custom.SorterControllerBlock;
import cz.lukesmith.automaticsorter.block.entity.FilterBlockEntity;
import cz.lukesmith.automaticsorter.block.entity.ModBlockEntities;
import cz.lukesmith.automaticsorter.config.ModConfig;
import cz.lukesmith.automaticsorter.inventory.inventoryAdapters.IInventoryAdapter;
import cz.lukesmith.automaticsorter.inventory.inventoryAdapters.NoInventoryAdapter;
import cz.lukesmith.automaticsorter.inventory.inventoryUtils.MainInventoryUtil;
import cz.lukesmith.automaticsorter.item.ModItems;
import cz.lukesmith.automaticsorter.screen.SorterControllerScreenHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class SorterControllerBlockEntity
extends BlockEntity
implements MenuProvider {
    private int ticker = 0;
    private static final int MAX_TICKER = 5;
    private double overflow = 0.0;
    private final ItemStackHandler inventory = new ItemStackHandler(1);

    public SorterControllerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.SORTER_CONTROLLER_BLOCK_ENTITY.get(), pos, state);
    }

    public static SorterControllerBlockEntity create(BlockPos pos, BlockState state) {
        return new SorterControllerBlockEntity(pos, state);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    protected void loadAdditional(ValueInput pInput) {
        super.loadAdditional(pInput);
        NonNullList items = NonNullList.withSize((int)this.inventory.getSlots(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((ValueInput)pInput, (NonNullList)items);
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, (ItemStack)items.get(i));
        }
        this.setChanged();
    }

    protected void saveAdditional(ValueOutput pOutput) {
        super.saveAdditional(pOutput);
        NonNullList items = NonNullList.withSize((int)this.inventory.getSlots(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            items.set(i, (Object)this.inventory.getStackInSlot(i));
        }
        ContainerHelper.saveAllItems((ValueOutput)pOutput, (NonNullList)items);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.automaticsorter.sorter_controller");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new SorterControllerScreenHandler(pContainerId, pPlayerInventory, this);
    }

    private static int tryWhitelistMode(IInventoryAdapter rootInventoryAdapter, IInventoryAdapter chestInventoryAdapter, IInventoryAdapter filterInventoryAdapter, int maxTransfer) {
        if (rootInventoryAdapter.isEmpty()) {
            return maxTransfer;
        }
        int transferLeft = maxTransfer;
        ArrayList<ItemStack> stacks = rootInventoryAdapter.getAllStacks();
        int stackSize = stacks.size();
        for (int i = 0; i < stackSize; ++i) {
            ItemStack containItemStack;
            ItemStack rootInventoryItemStack = stacks.get(i);
            if (rootInventoryItemStack.isEmpty() || (containItemStack = filterInventoryAdapter.containsItem(rootInventoryItemStack)).isEmpty()) continue;
            int transferedInStack = chestInventoryAdapter.addItem(rootInventoryItemStack, transferLeft);
            transferLeft -= transferedInStack;
            if (transferedInStack <= 0) continue;
            rootInventoryAdapter.removeItem(i, transferedInStack);
            if (transferLeft > 0) continue;
            return 0;
        }
        return transferLeft;
    }

    private static int tryInInventoryMode(IInventoryAdapter rootInventoryAdapter, IInventoryAdapter chestInventoryAdapter, int maxTransfer) {
        if (rootInventoryAdapter.isEmpty()) {
            return maxTransfer;
        }
        int transferLeft = maxTransfer;
        ArrayList<ItemStack> stacks = rootInventoryAdapter.getAllStacks();
        int stackSize = stacks.size();
        for (int i = 0; i < stackSize; ++i) {
            ItemStack containItemStack;
            ItemStack rootInventoryItemStack = stacks.get(i);
            if (rootInventoryItemStack.isEmpty() || (containItemStack = chestInventoryAdapter.containsItem(rootInventoryItemStack)).isEmpty()) continue;
            int transferedInStack = chestInventoryAdapter.addItem(rootInventoryItemStack, transferLeft);
            transferLeft -= transferedInStack;
            if (transferedInStack <= 0) continue;
            rootInventoryAdapter.removeItem(i, transferedInStack);
            if (transferLeft > 0) continue;
            return 0;
        }
        return transferLeft;
    }

    private static int tryRejectsMode(IInventoryAdapter rootInventoryAdapter, IInventoryAdapter chestInventoryAdapter, int maxTransfer) {
        if (rootInventoryAdapter.isEmpty()) {
            return maxTransfer;
        }
        int transferLeft = maxTransfer;
        ArrayList<ItemStack> stacks = rootInventoryAdapter.getAllStacks();
        int stackSize = stacks.size();
        for (int i = 0; i < stackSize; ++i) {
            ItemStack rootInventoryItemStack = stacks.get(i);
            if (rootInventoryItemStack.isEmpty()) continue;
            int transferedInStack = chestInventoryAdapter.addItem(rootInventoryItemStack, transferLeft);
            transferLeft -= transferedInStack;
            if (transferedInStack <= 0) continue;
            rootInventoryAdapter.removeItem(i, transferedInStack);
            if (transferLeft > 0) continue;
            return 0;
        }
        return transferLeft;
    }

    private static int tryToTransferItem(Level world, FilterBlockEntity filterBlockEntity, BlockPos filterPos, IInventoryAdapter rootInventoryAdapter, int maxTransfer) {
        Direction filterDirection = (Direction)world.getBlockState(filterPos).getValue(FilterBlock.FACING);
        Vec3i filterOffset = filterDirection.getUnitVec3i();
        BlockPos chestPos = filterPos.offset(filterOffset);
        IInventoryAdapter chestInventoryAdapter = MainInventoryUtil.getInventoryAdapter(world, chestPos);
        if (chestInventoryAdapter instanceof NoInventoryAdapter) {
            return maxTransfer;
        }
        int filterType = filterBlockEntity.getFilterType();
        return switch (FilterBlockEntity.FilterTypeEnum.fromValue(filterType)) {
            case FilterBlockEntity.FilterTypeEnum.WHITELIST -> {
                IInventoryAdapter filterInventoryAdapter = MainInventoryUtil.getInventoryAdapter(world, filterPos);
                yield SorterControllerBlockEntity.tryWhitelistMode(rootInventoryAdapter, chestInventoryAdapter, filterInventoryAdapter, maxTransfer);
            }
            case FilterBlockEntity.FilterTypeEnum.IN_INVENTORY -> SorterControllerBlockEntity.tryInInventoryMode(rootInventoryAdapter, chestInventoryAdapter, maxTransfer);
            case FilterBlockEntity.FilterTypeEnum.REJECTS -> SorterControllerBlockEntity.tryRejectsMode(rootInventoryAdapter, chestInventoryAdapter, maxTransfer);
            default -> maxTransfer;
        };
    }

    private int getAmplifierCount() {
        if (!this.inventory.getStackInSlot(0).isEmpty() && this.inventory.getStackInSlot(0).getItem().equals(ModItems.SORTER_AMPLIFIER)) {
            return this.inventory.getStackInSlot(0).getCount();
        }
        return 0;
    }

    public double getSpeedPerSecond() {
        if (ModConfig.get().instantSort) {
            return Double.MAX_VALUE;
        }
        double baseSpeed = ModConfig.get().baseSortingSpeed;
        double speedBoost = (double)this.getAmplifierCount() * ModConfig.get().baseSpeedBoostPerUpgrade;
        return baseSpeed + speedBoost;
    }

    public double getSpeedPerTick() {
        return this.getSpeedPerSecond() / 20.0;
    }

    public void tick(Level world, BlockPos pos, BlockState state) {
        if (world.isClientSide) {
            return;
        }
        if (this.ticker > 0) {
            --this.ticker;
            return;
        }
        double speed = this.getSpeedPerTick() * 5.0;
        int maxTransfer = (int)Math.floor(speed + this.overflow);
        this.overflow = speed + this.overflow - (double)maxTransfer;
        if (ModConfig.get().instantSort && this.overflow != 0.0) {
            this.overflow = 0.0;
        }
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        Direction facing = (Direction)world.getBlockState(pos).getValue(SorterControllerBlock.FACING);
        BlockPos nextPos = pos.offset(facing.getOpposite().getUnitVec3i());
        if (world.getBlockState(nextPos).getBlock() instanceof PipeBlock) {
            LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
            queue.add(nextPos);
            IInventoryAdapter rootInventoryAdapter = MainInventoryUtil.getInventoryAdapter(world, pos.offset(facing.getUnitVec3i()));
            boolean noInventoryRootChest = rootInventoryAdapter instanceof NoInventoryAdapter;
            int itemsLeftToTransfer = maxTransfer;
            ArrayList<FilterBlockEntity> rejectedFilters = new ArrayList<FilterBlockEntity>();
            block0: while (!queue.isEmpty() && itemsLeftToTransfer >= 0 && !noInventoryRootChest) {
                BlockPos currentPos = (BlockPos)queue.poll();
                if (visited.contains(currentPos)) continue;
                visited.add(currentPos);
                for (Direction direction : Direction.values()) {
                    BlockEntity filterEntity;
                    Vec3i offsetDirection = direction.getUnitVec3i();
                    BlockPos neighborPos = currentPos.offset(offsetDirection);
                    Block block = world.getBlockState(neighborPos).getBlock();
                    if (block instanceof PipeBlock) {
                        queue.add(neighborPos);
                        continue;
                    }
                    if (!(block instanceof FilterBlock) || !((filterEntity = world.getBlockEntity(neighborPos)) instanceof FilterBlockEntity)) continue;
                    FilterBlockEntity filterBlockEntity = (FilterBlockEntity)filterEntity;
                    Direction filterFacing = (Direction)world.getBlockState(neighborPos).getValue(FilterBlock.FACING);
                    if (direction != filterFacing) continue;
                    if (filterBlockEntity.getFilterType() == FilterBlockEntity.FilterTypeEnum.REJECTS.getValue()) {
                        rejectedFilters.add(filterBlockEntity);
                        continue;
                    }
                    if ((itemsLeftToTransfer = SorterControllerBlockEntity.tryToTransferItem(world, filterBlockEntity, neighborPos, rootInventoryAdapter, itemsLeftToTransfer)) >= 0) continue block0;
                }
            }
            if (itemsLeftToTransfer >= 0) {
                FilterBlockEntity filterBlockEntity;
                Iterator iterator = rejectedFilters.iterator();
                while (iterator.hasNext() && (itemsLeftToTransfer = SorterControllerBlockEntity.tryToTransferItem(world, filterBlockEntity = (FilterBlockEntity)((Object)iterator.next()), filterBlockEntity.getBlockPos(), rootInventoryAdapter, itemsLeftToTransfer)) < 0) {
                }
            }
        }
        this.ticker = 5;
    }

    public void onDataPacket(Connection connection, ValueInput data, HolderLookup.Provider lookup) {
        super.onDataPacket(connection, data, lookup);
    }
}

