/*
 * Decompiled with CFR 0.152.
 */
package cz.lukesmith.automaticsorter.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import cz.lukesmith.automaticsorter.config.ModConfig;
import cz.lukesmith.automaticsorter.network.NetworkHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ModCommands {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"as_basespeed").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)Double.MAX_VALUE)).executes(ctx -> {
            double value = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"value");
            ModConfig config = ModConfig.get();
            config.baseSortingSpeed = value;
            ModConfig.save();
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"message.automaticsorter.basespeed_set", (Object[])new Object[]{value}), true);
            ModCommands.sendSyncConfigPacketToAllPlayers((CommandContext<CommandSourceStack>)ctx);
            return 1;
        })));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"as_basespeedboostperupgrade").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)Double.MAX_VALUE)).executes(ctx -> {
            double value = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"value");
            ModConfig config = ModConfig.get();
            config.baseSpeedBoostPerUpgrade = value;
            ModConfig.save();
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"message.automaticsorter.basespeedboost_set", (Object[])new Object[]{value}), true);
            ModCommands.sendSyncConfigPacketToAllPlayers((CommandContext<CommandSourceStack>)ctx);
            return 1;
        })));
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"as_instantsort").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            boolean value = BoolArgumentType.getBool((CommandContext)ctx, (String)"value");
            ModConfig config = ModConfig.get();
            config.instantSort = value;
            ModConfig.save();
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"message.automaticsorter.instantsort_set", (Object[])new Object[]{value ? "true" : "false"}), true);
            ModCommands.sendSyncConfigPacketToAllPlayers((CommandContext<CommandSourceStack>)ctx);
            return 1;
        })));
    }

    private static void sendSyncConfigPacketToAllPlayers(CommandContext<CommandSourceStack> ctx) {
        for (ServerPlayer player : ((CommandSourceStack)ctx.getSource()).getServer().getPlayerList().getPlayers()) {
            NetworkHandler.sendConfigTo(player);
        }
    }
}

