/*
 * Decompiled with CFR 0.152.
 */
package cz.lukesmith.automaticsorter.inventory.inventoryAdapters;

import cz.lukesmith.automaticsorter.inventory.inventoryAdapters.IInventoryAdapter;
import java.util.ArrayList;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;

public class InventoryAdapter
implements IInventoryAdapter {
    private final Container inventory;

    public InventoryAdapter(Container inventory) {
        this.inventory = inventory;
    }

    @Override
    public ItemStack containsItem(ItemStack itemStack) {
        if (itemStack == null || itemStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int size = this.inventory.getContainerSize();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = this.inventory.getItem(i);
            if (!this.compareStacks(stack, itemStack)) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void removeItem(int index, int amount) {
        this.inventory.removeItem(index, amount);
    }

    @Override
    public int addItem(ItemStack itemStack, int maxAmount) {
        int size = this.inventory.getContainerSize();
        int toTransfer = Math.min(maxAmount, itemStack.getCount());
        int transferred = 0;
        for (int i = 0; i < size && transferred < toTransfer; ++i) {
            ItemStack stack = this.inventory.getItem(i);
            if (this.canCombineStacks(stack, itemStack) && stack.getCount() < stack.getMaxStackSize()) {
                int canAdd = Math.min(toTransfer - transferred, stack.getMaxStackSize() - stack.getCount());
                stack.grow(canAdd);
                transferred += canAdd;
                this.inventory.setChanged();
                continue;
            }
            if (!stack.isEmpty()) continue;
            int put = toTransfer - transferred;
            ItemStack newStack = itemStack.copyWithCount(put);
            this.inventory.setItem(i, newStack);
            transferred += put;
            this.inventory.setChanged();
        }
        return transferred;
    }

    @Override
    public ArrayList<ItemStack> getAllStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        int size = this.inventory.getContainerSize();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = this.inventory.getItem(i);
            stacks.add(stack);
        }
        return stacks;
    }

    @Override
    public int getSize() {
        return this.inventory.getContainerSize();
    }
}

