/*
 * Decompiled with CFR 0.152.
 */
package cz.lukesmith.automaticsorter.network;

import cz.lukesmith.automaticsorter.config.ModConfig;
import cz.lukesmith.automaticsorter.network.FilterTypePacket;
import cz.lukesmith.automaticsorter.network.ModConfigSyncPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.SimpleChannel;

@Mod.EventBusSubscriber
public class NetworkHandler {
    private static final String CHANNEL_NAME = "main";
    public static final SimpleChannel CHANNEL = ChannelBuilder.named((ResourceLocation)ResourceLocation.tryBuild((String)"automaticsorter", (String)"main")).simpleChannel();
    private static int packetId = 0;

    public static void register() {
        CHANNEL.messageBuilder(FilterTypePacket.class, packetId++, NetworkDirection.PLAY_TO_SERVER).encoder(FilterTypePacket::encode).decoder(FilterTypePacket::decode).consumer(FilterTypePacket::handle).add();
        CHANNEL.messageBuilder(ModConfigSyncPacket.class, packetId++, NetworkDirection.PLAY_TO_CLIENT).encoder(ModConfigSyncPacket::encode).decoder(ModConfigSyncPacket::decode).consumerMainThread(ModConfigSyncPacket::handle).add();
    }

    public static void registerClient() {
    }

    public static void sendConfigTo(ServerPlayer player) {
        ModConfig config = ModConfig.get();
        ModConfigSyncPacket packet = new ModConfigSyncPacket(config.baseSortingSpeed, config.baseSpeedBoostPerUpgrade, config.instantSort);
        System.out.println("Sending config to player " + player.getName().getString() + ": baseSortingSpeed=" + config.baseSortingSpeed + ", baseSpeedBoostPerUpgrade=" + config.baseSpeedBoostPerUpgrade + ", instantSort=" + config.instantSort);
        CHANNEL.send((Object)packet, player.connection.getConnection());
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            NetworkHandler.sendConfigTo(player2);
        }
    }
}

