/*
 * Decompiled with CFR 0.152.
 */
package cz.lukesmith.automaticsorter.block.custom;

import com.mojang.serialization.MapCodec;
import cz.lukesmith.automaticsorter.block.entity.FilterBlockEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FilterBlock
extends BaseEntityBlock {
    public static final EnumProperty<Direction> FACING = EnumProperty.create((String)"facing", Direction.class);
    public static final MapCodec<FilterBlock> CODEC = FilterBlock.simpleCodec(FilterBlock::new);
    public static BlockPos pos = BlockPos.ZERO;

    public FilterBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.UP));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected List<ItemStack> getDrops(BlockState pState, LootParams.Builder pParams) {
        Object object = pParams.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (object instanceof FilterBlockEntity) {
            FilterBlockEntity filterBlockEntity = (FilterBlockEntity)((Object)object);
            Containers.dropContents((Level)pParams.getLevel(), (BlockPos)pos, (Container)filterBlockEntity.getContainer());
        }
        return super.getDrops(pState, pParams);
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Vec3[][] shapes = this.getShapesForFacing((Direction)pState.getValue(FACING));
        VoxelShape shape = Shapes.empty();
        for (Vec3[] shapePart : shapes) {
            shapePart[0] = shapePart[0].scale(0.0625);
            shapePart[1] = shapePart[1].scale(0.0625);
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)Shapes.box((double)shapePart[0].get(Direction.Axis.X), (double)shapePart[0].get(Direction.Axis.Y), (double)shapePart[0].get(Direction.Axis.Z), (double)shapePart[1].get(Direction.Axis.X), (double)shapePart[1].get(Direction.Axis.Y), (double)shapePart[1].get(Direction.Axis.Z)));
        }
        return shape;
    }

    private Vec3[][] getShapesForFacing(Direction facing) {
        Vec3[][] shapes = new Vec3[][]{{new Vec3(6.0, 0.0, 6.0), new Vec3(10.0, 9.0, 10.0)}, {new Vec3(3.0, 9.0, 3.0), new Vec3(13.0, 13.0, 13.0)}, {new Vec3(2.0, 13.0, 2.0), new Vec3(14.0, 16.0, 14.0)}};
        switch (facing) {
            case DOWN: {
                shapes[0] = new Vec3[]{new Vec3(6.0, 7.0, 6.0), new Vec3(10.0, 16.0, 10.0)};
                shapes[1] = new Vec3[]{new Vec3(3.0, 3.0, 3.0), new Vec3(13.0, 7.0, 13.0)};
                shapes[2] = new Vec3[]{new Vec3(2.0, 0.0, 2.0), new Vec3(14.0, 3.0, 14.0)};
                break;
            }
            case NORTH: {
                shapes[0] = new Vec3[]{new Vec3(6.0, 6.0, 7.0), new Vec3(10.0, 10.0, 16.0)};
                shapes[1] = new Vec3[]{new Vec3(3.0, 3.0, 3.0), new Vec3(13.0, 13.0, 7.0)};
                shapes[2] = new Vec3[]{new Vec3(2.0, 2.0, 0.0), new Vec3(14.0, 14.0, 3.0)};
                break;
            }
            case SOUTH: {
                shapes[0] = new Vec3[]{new Vec3(6.0, 6.0, 0.0), new Vec3(10.0, 10.0, 9.0)};
                shapes[1] = new Vec3[]{new Vec3(3.0, 3.0, 9.0), new Vec3(13.0, 13.0, 13.0)};
                shapes[2] = new Vec3[]{new Vec3(2.0, 2.0, 13.0), new Vec3(14.0, 14.0, 16.0)};
                break;
            }
            case WEST: {
                shapes[0] = new Vec3[]{new Vec3(7.0, 6.0, 6.0), new Vec3(16.0, 10.0, 10.0)};
                shapes[1] = new Vec3[]{new Vec3(3.0, 3.0, 3.0), new Vec3(7.0, 13.0, 13.0)};
                shapes[2] = new Vec3[]{new Vec3(0.0, 2.0, 2.0), new Vec3(3.0, 14.0, 14.0)};
                break;
            }
            case EAST: {
                shapes[0] = new Vec3[]{new Vec3(0.0, 6.0, 6.0), new Vec3(9.0, 10.0, 10.0)};
                shapes[1] = new Vec3[]{new Vec3(9.0, 3.0, 3.0), new Vec3(13.0, 13.0, 13.0)};
                shapes[2] = new Vec3[]{new Vec3(13.0, 2.0, 2.0), new Vec3(16.0, 14.0, 14.0)};
            }
        }
        return shapes;
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        pos = pPos;
        return new FilterBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> GameEventListener getListener(ServerLevel pLevel, T pBlockEntity) {
        return super.getListener(pLevel, pBlockEntity);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!world.isClientSide) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof FilterBlockEntity) {
                FilterBlockEntity filterBlockEntity = (FilterBlockEntity)blockEntity;
                ((ServerPlayer)player).openMenu((MenuProvider)new SimpleMenuProvider((MenuConstructor)filterBlockEntity, (Component)Component.literal((String)"Growth Chamber")), pos);
            } else {
                throw new IllegalStateException("Our Container provider is missing!");
            }
        }
        return InteractionResult.SUCCESS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getClickedFace().getOpposite());
    }
}

