/*
 * Decompiled with CFR 0.152.
 */
package cz.lukesmith.automaticsorter.block.entity;

import cz.lukesmith.automaticsorter.block.entity.ModBlockEntities;
import cz.lukesmith.automaticsorter.screen.FilterScreenHandler;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class FilterBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler inventory = new ItemStackHandler(24){

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            FilterBlockEntity.this.setChanged();
            if (!FilterBlockEntity.this.level.isClientSide()) {
                FilterBlockEntity.this.level.sendBlockUpdated(FilterBlockEntity.this.getBlockPos(), FilterBlockEntity.this.getBlockState(), FilterBlockEntity.this.getBlockState(), 3);
            }
        }
    };
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    private int filterType = FilterTypeEnum.IN_INVENTORY.getValue();

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryCap.invalidate();
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public Container getContainer() {
        return new Container(){

            public int getContainerSize() {
                return FilterBlockEntity.this.inventory.getSlots();
            }

            public boolean isEmpty() {
                for (int i = 0; i < this.getContainerSize(); ++i) {
                    if (this.getItem(i).isEmpty()) continue;
                    return false;
                }
                return true;
            }

            @NotNull
            public ItemStack getItem(int index) {
                return FilterBlockEntity.this.inventory.getStackInSlot(index);
            }

            @NotNull
            public ItemStack removeItem(int index, int count) {
                return FilterBlockEntity.this.inventory.extractItem(index, count, false);
            }

            @NotNull
            public ItemStack removeItemNoUpdate(int pSlot) {
                ItemStack stack = FilterBlockEntity.this.inventory.getStackInSlot(pSlot);
                if (!stack.isEmpty()) {
                    FilterBlockEntity.this.inventory.setStackInSlot(pSlot, ItemStack.EMPTY);
                    return stack;
                }
                return ItemStack.EMPTY;
            }

            public void setItem(int index, @NotNull ItemStack stack) {
                FilterBlockEntity.this.inventory.setStackInSlot(index, stack);
            }

            public void setChanged() {
            }

            public boolean stillValid(@NotNull Player pPlayer) {
                return false;
            }

            public void clearContent() {
                FilterBlockEntity.this.inventory.setSize(0);
            }
        };
    }

    public FilterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.FILTER_BLOCK_ENTITY.get(), pos, state);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.inventory.deserializeNBT(pRegistries, pTag.getCompound("FilterInventory"));
        this.filterType = pTag.getInt("FilterType");
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.put("FilterInventory", (Tag)this.inventory.serializeNBT(pRegistries));
        pTag.putInt("FilterType", this.filterType);
    }

    public static FilterBlockEntity create(BlockPos pos, BlockState state) {
        return new FilterBlockEntity(pos, state);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"automaticsorter.filter_block_entity");
    }

    public int getFilterType() {
        return this.filterType;
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null) {
            this.level.setBlock(this.getBlockPos(), this.getBlockState(), 3);
        }
    }

    public void setFilterType(int filterType) {
        this.filterType = filterType;
        this.setChanged();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new FilterScreenHandler(pContainerId, pPlayerInventory, this, new ContainerData(){

            public int get(int index) {
                if (index == 0) {
                    return FilterBlockEntity.this.filterType;
                }
                return 0;
            }

            public void set(int index, int value) {
                if (index == 0) {
                    FilterBlockEntity.this.filterType = value;
                }
            }

            public int getCount() {
                return 1;
            }
        });
    }

    public static enum FilterTypeEnum {
        WHITELIST(0),
        IN_INVENTORY(1),
        REJECTS(2);

        private final int value;

        private FilterTypeEnum(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static FilterTypeEnum fromValue(int value) {
            for (FilterTypeEnum type : FilterTypeEnum.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown enum value: " + value);
        }

        public static int nextValue(int number) {
            return switch (FilterTypeEnum.fromValue(number).ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> IN_INVENTORY.getValue();
                case 1 -> REJECTS.getValue();
                case 2 -> WHITELIST.getValue();
            };
        }

        public static String getName(FilterTypeEnum type) {
            return switch (type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "Whitelist";
                case 1 -> "In Inventory";
                case 2 -> "Rejects";
            };
        }

        public static String getName(int value) {
            return FilterTypeEnum.getName(FilterTypeEnum.fromValue(value));
        }
    }
}

