/*
 * Decompiled with CFR 0.152.
 */
package cz.lukesmith.automaticsorter.block.entity;

import cz.lukesmith.automaticsorter.block.custom.FilterBlock;
import cz.lukesmith.automaticsorter.block.custom.PipeBlock;
import cz.lukesmith.automaticsorter.block.entity.FilterBlockEntity;
import cz.lukesmith.automaticsorter.block.entity.ModBlockEntities;
import cz.lukesmith.automaticsorter.inventory.inventoryAdapters.IInventoryAdapter;
import cz.lukesmith.automaticsorter.inventory.inventoryAdapters.NoInventoryAdapter;
import cz.lukesmith.automaticsorter.inventory.inventoryUtils.MainInventoryUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SorterControllerBlockEntity
extends BlockEntity {
    private int ticker = 0;
    private static final int MAX_TICKER = 5;

    public SorterControllerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.SORTER_CONTROLLER_BLOCK_ENTITY.get(), pos, state);
    }

    public static SorterControllerBlockEntity create(BlockPos pos, BlockState state) {
        return new SorterControllerBlockEntity(pos, state);
    }

    private static boolean tryWhitelistMode(IInventoryAdapter rootInventoryAdapter, IInventoryAdapter chestInventoryAdapter, IInventoryAdapter filterInventoryAdapter) {
        if (rootInventoryAdapter.isEmpty()) {
            return false;
        }
        ArrayList<ItemStack> stacks = rootInventoryAdapter.getAllStacks();
        int stackSize = stacks.size();
        for (int i = 0; i < stackSize; ++i) {
            ItemStack containItemStack;
            ItemStack rootInventoryItemStack = stacks.get(i);
            if (rootInventoryItemStack.isEmpty() || (containItemStack = filterInventoryAdapter.containsItem(rootInventoryItemStack)).isEmpty() || !chestInventoryAdapter.addItem(rootInventoryItemStack)) continue;
            rootInventoryAdapter.removeItem(i, 1);
            return true;
        }
        return false;
    }

    private static boolean tryInInventoryMode(IInventoryAdapter rootInventoryAdapter, IInventoryAdapter chestInventoryAdapter) {
        if (rootInventoryAdapter.isEmpty()) {
            return false;
        }
        ArrayList<ItemStack> stacks = rootInventoryAdapter.getAllStacks();
        int stackSize = stacks.size();
        for (int i = 0; i < stackSize; ++i) {
            ItemStack containItemStack;
            ItemStack rootInventoryItemStack = stacks.get(i);
            if (rootInventoryItemStack.isEmpty() || (containItemStack = chestInventoryAdapter.containsItem(rootInventoryItemStack)).isEmpty() || !chestInventoryAdapter.addItem(rootInventoryItemStack)) continue;
            rootInventoryAdapter.removeItem(i, 1);
            return true;
        }
        return false;
    }

    private static boolean tryRejectsMode(IInventoryAdapter rootInventoryAdapter, IInventoryAdapter chestInventoryAdapter) {
        if (rootInventoryAdapter.isEmpty()) {
            return false;
        }
        ArrayList<ItemStack> stacks = rootInventoryAdapter.getAllStacks();
        int stackSize = stacks.size();
        for (int i = 0; i < stackSize; ++i) {
            ItemStack rootInventoryItemStack = stacks.get(i);
            if (rootInventoryItemStack.isEmpty() || !chestInventoryAdapter.addItem(rootInventoryItemStack)) continue;
            rootInventoryAdapter.removeItem(i, 1);
            return true;
        }
        return false;
    }

    private static boolean tryToTransferItem(Level world, FilterBlockEntity filterBlockEntity, BlockPos filterPos, IInventoryAdapter rootInventoryAdapter) {
        Direction filterDirection = (Direction)world.getBlockState(filterPos).getValue(FilterBlock.FACING);
        BlockPos chestPos = filterPos.relative(filterDirection);
        IInventoryAdapter chestInventoryAdapter = MainInventoryUtil.getInventoryAdapter(world, chestPos);
        if (chestInventoryAdapter instanceof NoInventoryAdapter) {
            return false;
        }
        int filterType = filterBlockEntity.getFilterType();
        return switch (FilterBlockEntity.FilterTypeEnum.fromValue(filterType)) {
            case FilterBlockEntity.FilterTypeEnum.WHITELIST -> {
                IInventoryAdapter filterInventoryAdapter = MainInventoryUtil.getInventoryAdapter(world, filterPos);
                yield SorterControllerBlockEntity.tryWhitelistMode(rootInventoryAdapter, chestInventoryAdapter, filterInventoryAdapter);
            }
            case FilterBlockEntity.FilterTypeEnum.IN_INVENTORY -> SorterControllerBlockEntity.tryInInventoryMode(rootInventoryAdapter, chestInventoryAdapter);
            case FilterBlockEntity.FilterTypeEnum.REJECTS -> SorterControllerBlockEntity.tryRejectsMode(rootInventoryAdapter, chestInventoryAdapter);
            default -> false;
        };
    }

    public void tick(Level world, BlockPos pos, BlockState state) {
        if (world.isClientSide) {
            return;
        }
        if (this.ticker > 0) {
            --this.ticker;
            return;
        }
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        BlockPos belowPos = pos.below();
        if (world.getBlockState(belowPos).getBlock() instanceof PipeBlock) {
            LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
            queue.add(belowPos);
            IInventoryAdapter rootInventoryAdapter = MainInventoryUtil.getInventoryAdapter(world, pos.above());
            boolean noInventoryRootChest = rootInventoryAdapter instanceof NoInventoryAdapter;
            boolean itemTransfered = false;
            ArrayList<FilterBlockEntity> rejectedFilters = new ArrayList<FilterBlockEntity>();
            block0: while (!(queue.isEmpty() || itemTransfered || noInventoryRootChest)) {
                BlockPos currentPos = (BlockPos)queue.poll();
                if (visited.contains(currentPos)) continue;
                visited.add(currentPos);
                for (Direction direction : Direction.values()) {
                    BlockEntity filterEntity;
                    BlockPos neighborPos = currentPos.relative(direction);
                    Block block = world.getBlockState(neighborPos).getBlock();
                    if (block instanceof PipeBlock) {
                        queue.add(neighborPos);
                        continue;
                    }
                    if (!(block instanceof FilterBlock) || !((filterEntity = world.getBlockEntity(neighborPos)) instanceof FilterBlockEntity)) continue;
                    FilterBlockEntity filterBlockEntity = (FilterBlockEntity)filterEntity;
                    Direction filterFacing = (Direction)world.getBlockState(neighborPos).getValue(FilterBlock.FACING);
                    if (direction != filterFacing) continue;
                    if (filterBlockEntity.getFilterType() == FilterBlockEntity.FilterTypeEnum.REJECTS.getValue()) {
                        rejectedFilters.add(filterBlockEntity);
                        continue;
                    }
                    if (!SorterControllerBlockEntity.tryToTransferItem(world, filterBlockEntity, neighborPos, rootInventoryAdapter)) continue;
                    itemTransfered = true;
                    continue block0;
                }
            }
            if (!itemTransfered) {
                FilterBlockEntity filterBlockEntity;
                Iterator iterator = rejectedFilters.iterator();
                while (iterator.hasNext() && !SorterControllerBlockEntity.tryToTransferItem(world, filterBlockEntity = (FilterBlockEntity)((Object)iterator.next()), filterBlockEntity.getBlockPos(), rootInventoryAdapter)) {
                }
            }
        }
        this.ticker = 5;
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookup) {
        super.onDataPacket(connection, pkt, lookup);
    }
}

