/*
 * Decompiled with CFR 0.152.
 */
package cz.lukesmith.automaticsorter.screen;

import cz.lukesmith.automaticsorter.block.ModBlocks;
import cz.lukesmith.automaticsorter.block.entity.SorterControllerBlockEntity;
import cz.lukesmith.automaticsorter.screen.ModScreenHandlers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class SorterControllerScreenHandler
extends AbstractContainerMenu {
    private final SorterControllerBlockEntity blockEntity;
    private final Level level;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int SORTER_CONTROLLER_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int SORTER_CONTROLLER_INVENTORY_SLOT_COUNT = 1;

    public SorterControllerScreenHandler(int syncId, Inventory inventory, FriendlyByteBuf extraData) {
        this(syncId, inventory, inventory.player.level().getBlockEntity(extraData.readBlockPos()));
    }

    public SorterControllerScreenHandler(int containerId, Inventory playerInventory, BlockEntity blockEntity) {
        super((MenuType)ModScreenHandlers.SORTER_CONTROLLER_SCREEN_HANDLER.get(), containerId);
        if (!(blockEntity instanceof SorterControllerBlockEntity)) {
            throw new IllegalStateException("Invalid block entity at container open");
        }
        SorterControllerBlockEntity sorterControllerBlockEntity = (SorterControllerBlockEntity)blockEntity;
        this.blockEntity = sorterControllerBlockEntity;
        this.level = playerInventory.player.level();
        ItemStackHandler inventory = this.blockEntity.getInventory();
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)inventory, 0, 80, 33));
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copy = sourceStack.copy();
        if (index < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 37, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < 37) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            return ItemStack.EMPTY;
        }
        if (sourceStack.isEmpty()) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(player, sourceStack);
        return copy;
    }

    public boolean stillValid(Player pPlayer) {
        return SorterControllerScreenHandler.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)pPlayer, (Block)((Block)ModBlocks.SORTER_CONTROLLER_BLOCK.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public String getSpeedBoostText() {
        double speed = this.blockEntity.getSpeedPerSecond();
        if (speed == Double.MAX_VALUE) {
            return "\u221e";
        }
        return String.format("%.2f", speed);
    }
}

