/*
 * Decompiled with CFR 0.152.
 */
package cz.lukesmith.automaticsorter.block;

import cz.lukesmith.automaticsorter.block.custom.FilterBlock;
import cz.lukesmith.automaticsorter.block.custom.PipeBlock;
import cz.lukesmith.automaticsorter.block.custom.SorterControllerBlock;
import cz.lukesmith.automaticsorter.item.ModItems;
import java.util.function.Function;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"automaticsorter");
    public static final RegistryObject<Block> PIPE_BLOCK = ModBlocks.registerBlock("pipe", properties -> new PipeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COPPER_BLOCK).strength(1.0f, 2.0f).noOcclusion()));
    public static final RegistryObject<Block> SORTER_CONTROLLER_BLOCK = ModBlocks.registerBlock("sorter_controller", properties -> new SorterControllerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COPPER_BLOCK).strength(3.0f, 6.0f).noOcclusion()));
    public static final RegistryObject<Block> FILTER_BLOCK = ModBlocks.registerBlock("filter", properties -> new FilterBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COPPER_BLOCK).strength(3.0f, 6.0f).noOcclusion()));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Function<BlockBehaviour.Properties, T> blockSupplier) {
        RegistryObject toReturn = BLOCKS.register(name, () -> (Block)blockSupplier.apply(BlockBehaviour.Properties.of()));
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, RegistryObject<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

