/*
 * Decompiled with CFR 0.152.
 */
package cz.lukesmith.automaticsorter.screen;

import cz.lukesmith.automaticsorter.block.ModBlocks;
import cz.lukesmith.automaticsorter.block.entity.FilterBlockEntity;
import cz.lukesmith.automaticsorter.network.FilterTypePacket;
import cz.lukesmith.automaticsorter.network.NetworkHandler;
import cz.lukesmith.automaticsorter.screen.FilterScreenHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.network.PacketDistributor;

public class FilterScreen
extends AbstractContainerScreen<FilterScreenHandler> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"automaticsorter", (String)"textures/gui/filter.png");
    private Button receiveItemsButton;
    private static final ItemStack CHEST_BLOCK = new ItemStack((ItemLike)Blocks.CHEST);
    private static final ItemStack FILTER_BLOCK = new ItemStack((ItemLike)ModBlocks.FILTER_BLOCK.get());
    private static final ItemStack REJECTS = new ItemStack((ItemLike)Blocks.BARRIER);

    public FilterScreen(FilterScreenHandler handler, Inventory inv, Component title) {
        super((AbstractContainerMenu)handler, inv, title);
    }

    protected void renderBg(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        pGuiGraphics.blit(TEXTURE, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    private Component getButtonText() {
        return Component.literal((String)FilterBlockEntity.FilterTypeEnum.getName(((FilterScreenHandler)this.menu).getFilterType()));
    }

    protected void init() {
        super.init();
        this.inventoryLabelY = 1000;
        this.titleLabelY = 1000;
        this.receiveItemsButton = new Button.Builder((Component)Component.literal((String)""), button -> {
            int value = ((FilterScreenHandler)this.menu).toggleFilterType();
            BlockPos blockPos = ((FilterScreenHandler)this.menu).getBlockPos();
            FilterTypePacket payload = new FilterTypePacket(blockPos, value);
            NetworkHandler.CHANNEL.send((Object)payload, PacketDistributor.SERVER.noArg());
        }).pos(this.leftPos + 6, this.topPos + 14).size(18, 18).build();
        this.addRenderableWidget((GuiEventListener)this.receiveItemsButton);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.renderBackground(context, mouseX, mouseY, delta);
        super.render(context, mouseX, mouseY, delta);
        this.renderTooltip(context, mouseX, mouseY);
        if (this.receiveItemsButton.isMouseOver((double)mouseX, (double)mouseY)) {
            context.renderTooltip(this.font, this.getButtonText(), mouseX, mouseY);
        }
        if (!this.receiveItemsButton.isMouseOver((double)mouseX, (double)mouseY)) {
            this.receiveItemsButton.setFocused(false);
        }
        int filterType = ((FilterScreenHandler)this.menu).getFilterType();
        ItemStack renderButtonBlock = this.getDisplayedItemStack();
        context.renderItem(renderButtonBlock, this.leftPos + 7, this.topPos + 15);
        switch (FilterBlockEntity.FilterTypeEnum.fromValue(filterType)) {
            case REJECTS: 
            case IN_INVENTORY: {
                int x = this.leftPos + 25;
                int y = this.topPos + 14;
                int width = 144;
                int height = 54;
                int color = Integer.MIN_VALUE;
                context.fill(x, y, x + width, y + height, color);
                break;
            }
        }
    }

    private ItemStack getDisplayedItemStack() {
        int filterType = ((FilterScreenHandler)this.menu).getFilterType();
        if (filterType == FilterBlockEntity.FilterTypeEnum.WHITELIST.getValue()) {
            return FILTER_BLOCK;
        }
        if (filterType == FilterBlockEntity.FilterTypeEnum.IN_INVENTORY.getValue()) {
            return CHEST_BLOCK;
        }
        return REJECTS;
    }
}

